/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.control;

import java.util.Iterator;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.joinpoint.MethodJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.control.AbstractJoinPointController;
import org.codehaus.aspectwerkz.joinpoint.control.JoinPointController;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;

public class DefaultJoinPointController
extends AbstractJoinPointController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed(MethodJoinPoint joinPoint) throws Throwable {
        if (joinPoint.getPointcuts().length == 0) {
            return joinPoint.invokeOriginalMethod();
        }
        if (joinPoint.getCFlowExpressions().size() != 0) {
            boolean isInCFlow = false;
            Iterator it = joinPoint.getCFlowExpressions().iterator();
            while (it.hasNext()) {
                Expression cflowExpression = (Expression)it.next();
                if (!joinPoint.getSystem().isInControlFlowOf(cflowExpression)) continue;
                isInCFlow = true;
                break;
            }
            if (!isInCFlow) {
                return joinPoint.invokeOriginalMethod();
            }
        }
        Object result = null;
        boolean pointcutSwitch = false;
        if (this.m_currentAdviceIndex == joinPoint.getPointcuts()[this.m_currentPointcutIndex].getAdviceIndexes().length - 1 && this.m_currentPointcutIndex < joinPoint.getPointcuts().length - 1) {
            ++this.m_currentPointcutIndex;
            this.m_currentAdviceIndex = -1;
            pointcutSwitch = true;
        }
        if (this.m_currentAdviceIndex == joinPoint.getPointcuts()[this.m_currentPointcutIndex].getAdviceIndexes().length - 1 && this.m_currentPointcutIndex == joinPoint.getPointcuts().length - 1) {
            result = joinPoint.invokeOriginalMethod();
        } else {
            try {
                System system;
                ++this.m_currentAdviceIndex;
                if (joinPoint.getSystem().isAttribDef()) {
                    system = (AttribDefSystem)joinPoint.getSystem();
                    ExecutionPointcut methodPointcut = joinPoint.getPointcuts()[this.m_currentPointcutIndex];
                    IndexTuple index = methodPointcut.getAdviceIndex(this.m_currentAdviceIndex);
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    result = ((AttribDefSystem)system).getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, joinPoint);
                } else {
                    system = (XmlDefSystem)joinPoint.getSystem();
                    IndexTuple index = joinPoint.getPointcuts()[this.m_currentPointcutIndex].getAdviceIndex(this.m_currentAdviceIndex);
                    result = ((XmlDefSystem)system).getAdvice(index).doExecute(joinPoint);
                }
            }
            finally {
                --this.m_currentAdviceIndex;
            }
        }
        if (pointcutSwitch) {
            --this.m_currentPointcutIndex;
            this.m_currentAdviceIndex = joinPoint.getPointcuts()[this.m_currentPointcutIndex].getAdviceIndexes().length - 1;
        }
        return result;
    }

    public JoinPointController deepCopy() {
        DefaultJoinPointController clone = new DefaultJoinPointController();
        clone.m_currentAdviceIndex = this.m_currentAdviceIndex;
        clone.m_currentPointcutIndex = this.m_currentPointcutIndex;
        return clone;
    }
}

