/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.metadata;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.ExpressionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.QDoxParser;
import org.codehaus.aspectwerkz.util.Strings;
import org.codehaus.aspectwerkz.util.UuidGenerator;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPostAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPreAdvice;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.xmldef.definition.BindAdviceRule;
import org.codehaus.aspectwerkz.xmldef.definition.BindIntroductionRule;
import org.codehaus.aspectwerkz.xmldef.definition.DefinitionValidator;
import org.codehaus.aspectwerkz.xmldef.definition.IntroductionDefinition;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class AttributeC {
    public static final String METHOD_POINTCUT_NAME = "__aw_method_pointcut_";
    public static final String SETFIELD_POINTCUT_NAME = "__aw_setfield_pointcut_";
    public static final String GETFIELD_POINTCUT_NAME = "__aw_getfield_pointcut_";
    public static final String THROWS_POINTCUT_NAME = "__aw_throws_pointcut_";
    public static final String CALLERSIDE_POINTCUT_NAME = "__aw_callerside_pointcut_";
    public static final String CFLOW_POINTCUT_NAME = "__aw_cflow_pointcut_";
    public static final String CONTROLLER_POINTCUT_NAME = "__aw_controller_pointcut_";

    public static void compile(String sourcePath, String fileName) {
        AttributeC.compile(sourcePath, fileName, null, null);
    }

    public static void compile(String sourcePath, String fileName, String definitionFileToMerge, String uuid) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("source path can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("file name can not be null");
        }
        AspectWerkzDefinitionImpl definition = AttributeC.getDefinition(definitionFileToMerge);
        AttributeC.parseRuntimeAttributes(definition, sourcePath);
        AttributeC.validate(definition);
        if (uuid == null) {
            uuid = UuidGenerator.generate(definition);
        }
        Document document = AttributeC.createDocument(definition, uuid);
        AttributeC.writeDocumentToFile(document, fileName);
    }

    public static void parseRuntimeAttributes(AspectWerkzDefinitionImpl definition, String sourcePath) {
        String className;
        int i;
        QDoxParser qdoxParser = new QDoxParser(sourcePath);
        String[] allClasses = qdoxParser.getAllClassNames();
        definition.addAdvice(CFlowPreAdvice.getDefinition());
        for (i = 0; i < allClasses.length; ++i) {
            className = allClasses[i];
            if (!qdoxParser.parse(className)) continue;
            AttributeC.weaveIntroductionDefinitionAttributes(qdoxParser, definition);
            AttributeC.weaveAdviceDefinitionAttributes(qdoxParser, definition);
        }
        for (i = 0; i < allClasses.length; ++i) {
            className = allClasses[i];
            if (!qdoxParser.parse(className)) continue;
            AttributeC.parseCFlowPointcutAttributes(definition, className, qdoxParser);
            AttributeC.parseIntroductionAttributes(definition, className, qdoxParser);
            AttributeC.parseMethodPointcutAttributes(definition, className, qdoxParser);
            AttributeC.parseJoinPointControllerAttributes(definition, className, qdoxParser);
            AttributeC.parseSetFieldPointcutAttributes(definition, className, qdoxParser);
            AttributeC.parseGetFieldPointcutAttributes(definition, className, qdoxParser);
            AttributeC.parseThrowsPointcutAttributes(definition, className, qdoxParser);
            AttributeC.parseCallerSidePointcutAttributes(definition, className, qdoxParser);
        }
    }

    public static Document createDocument(AspectWerkzDefinitionImpl definition, String uuid) {
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        Document document = DocumentHelper.createDocument();
        document.addDocType("aspectwerkz", "-//AspectWerkz//DTD//EN", "http://aspectwerkz.codehaus.org/dtd/aspectwerkz.dtd");
        Element root = document.addElement("aspectwerkz");
        Element system = root.addElement("system");
        system.addAttribute("id", uuid);
        AttributeC.handleIntroductionDefinitions(system, definition);
        AttributeC.handleAdviceDefinitions(system, definition);
        AttributeC.handleAspectDefinitions(system, definition);
        return document;
    }

    public static void writeDocumentToFile(Document document, String fileName) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(fileName), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void handleIntroductionDefinitions(Element root, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getIntroductionDefinitions().iterator();
        while (it.hasNext()) {
            IntroductionDefinition def = (IntroductionDefinition)it.next();
            AttributeC.addIntroductionDefElement(root, def);
        }
    }

    private static AspectWerkzDefinitionImpl getDefinition(String fileName) {
        File definitionFile;
        AspectWerkzDefinitionImpl definition = null;
        if (fileName != null && (definitionFile = new File(fileName)).exists()) {
            List definitions = DefinitionLoader.loadDefinitionsFromFile(fileName);
            Iterator it = definitions.iterator();
            while (it.hasNext()) {
                AspectWerkzDefinition def = (AspectWerkzDefinition)it.next();
                if (!def.isXmlDef()) continue;
                definition = (AspectWerkzDefinitionImpl)def;
                break;
            }
        }
        if (definition == null) {
            definition = new AspectWerkzDefinitionImpl();
        }
        return definition;
    }

    private static void handleAdviceDefinitions(Element root, AspectWerkzDefinitionImpl definition) {
        AttributeC.addAdviceDefElement(root, CFlowPreAdvice.getDefinition());
        AttributeC.addAdviceDefElement(root, CFlowPostAdvice.getDefinition());
        Iterator it = definition.getAdviceDefinitions().iterator();
        while (it.hasNext()) {
            AdviceDefinition def = (AdviceDefinition)it.next();
            AttributeC.addAdviceDefElement(root, def);
        }
    }

    private static Element addIntroductionDefElement(Element root, IntroductionDefinition introDef) {
        String deploymentModel;
        if (root == null) {
            throw new IllegalArgumentException("root element can not be null");
        }
        if (introDef == null) {
            throw new IllegalArgumentException("introduction definition can not be null");
        }
        Element introDefElement = root.addElement("introduction-def");
        introDefElement.addAttribute("name", introDef.getName());
        introDefElement.addAttribute("interface", introDef.getInterface());
        String implementation = introDef.getImplementation();
        if (implementation != null) {
            introDefElement.addAttribute("implementation", implementation);
        }
        if ((deploymentModel = introDef.getDeploymentModel()) != null && deploymentModel.length() != 0) {
            introDefElement.addAttribute("deployment-model", deploymentModel);
        } else {
            introDefElement.addAttribute("deployment-model", "perJVM");
        }
        String attribute = introDef.getAttribute();
        if (attribute != null && attribute.length() != 0) {
            introDefElement.addAttribute("attribute", attribute);
        }
        return introDefElement;
    }

    private static Element addAdviceDefElement(Element root, AdviceDefinition adviceDef) {
        if (root == null) {
            throw new IllegalArgumentException("root element can not be null");
        }
        if (adviceDef == null) {
            throw new IllegalArgumentException("advice definition can not be null");
        }
        Element adviceDefElement = root.addElement("advice-def");
        adviceDefElement.addAttribute("name", adviceDef.getName());
        adviceDefElement.addAttribute("class", adviceDef.getAdviceClassName());
        String deploymentModel = adviceDef.getDeploymentModel();
        if (deploymentModel != null && deploymentModel.length() != 0) {
            adviceDefElement.addAttribute("deployment-model", deploymentModel);
        } else {
            adviceDefElement.addAttribute("deployment-model", "perJVM");
        }
        String attribute = adviceDef.getAttribute();
        if (attribute != null && attribute.length() != 0) {
            adviceDefElement.addAttribute("attribute", attribute);
        }
        AttributeC.addAdviceParamElements(adviceDefElement, adviceDef);
        return adviceDefElement;
    }

    private static void addAdviceParamElements(Element adviceElement, AdviceDefinition adviceDef) {
        if (adviceElement == null) {
            throw new IllegalArgumentException("advice element can not be null");
        }
        if (adviceDef == null) {
            throw new IllegalArgumentException("advice definition can not be null");
        }
        Iterator it = adviceDef.getParameters().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Element adviceParamElement = adviceElement.addElement("param");
            adviceParamElement.addAttribute("name", (String)entry.getKey());
            adviceParamElement.addAttribute("value", (String)entry.getValue());
        }
    }

    private static void handleAspectDefinitions(Element root, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Element aspectElement = root.addElement("aspect");
            aspectElement.addAttribute("name", aspectDef.getName());
            AttributeC.handlePointcutDefinitions(aspectElement, aspectDef);
            AttributeC.handleControllerDefinitions(aspectElement, aspectDef);
            AttributeC.handleBindIntroductionRules(aspectElement, aspectDef);
            AttributeC.handleBindAdviceRules(aspectElement, aspectDef);
        }
    }

    private static void handlePointcutDefinitions(Element aspectElement, AspectDefinition aspectDef) {
        Iterator it2 = aspectDef.getPointcutDefs().iterator();
        while (it2.hasNext()) {
            PointcutDefinition pointcutDef = (PointcutDefinition)it2.next();
            Element pointcutDefElement = aspectElement.addElement("pointcut-def");
            pointcutDefElement.addAttribute("name", pointcutDef.getName());
            PointcutType pointcutType = pointcutDef.getType();
            if (pointcutType.equals(PointcutType.EXECUTION)) {
                pointcutDefElement.addAttribute("type", "method");
            } else if (pointcutType.equals(PointcutType.CALL)) {
                pointcutDefElement.addAttribute("type", "callerSide");
            } else if (pointcutType.equals(PointcutType.GET)) {
                pointcutDefElement.addAttribute("type", "getField");
            } else if (pointcutType.equals(PointcutType.SET)) {
                pointcutDefElement.addAttribute("type", "setField");
            } else if (pointcutType.equals(PointcutType.CFLOW)) {
                pointcutDefElement.addAttribute("type", "cflow");
            } else if (pointcutType.equals(PointcutType.THROWS)) {
                pointcutDefElement.addAttribute("type", "throws");
            } else if (pointcutType.equals(PointcutType.CLASS)) {
                pointcutDefElement.addAttribute("type", "class");
            } else {
                throw new ExpressionException("pointcut type not supported: " + pointcutType);
            }
            pointcutDefElement.addAttribute("pattern", pointcutDef.getExpression());
        }
    }

    private static void handleControllerDefinitions(Element aspectElement, AspectDefinition aspectDef) {
    }

    private static void handleBindIntroductionRules(Element aspectElement, AspectDefinition aspectDef) {
        Iterator it = aspectDef.getBindIntroductionRules().iterator();
        while (it.hasNext()) {
            BindIntroductionRule bindIntroductionRule = (BindIntroductionRule)it.next();
            Element element = aspectElement.addElement("bind-introduction");
            element.addAttribute("class", bindIntroductionRule.getExpression().getExpression());
            Iterator it2 = bindIntroductionRule.getIntroductionRefs().iterator();
            while (it2.hasNext()) {
                String introductionRef = (String)it2.next();
                Element introductionRefElement = element.addElement("introduction-ref");
                introductionRefElement.addAttribute("name", introductionRef);
            }
        }
    }

    private static void handleBindAdviceRules(Element aspectElement, AspectDefinition aspectDef) {
        Iterator it = aspectDef.getBindAdviceRules().iterator();
        while (it.hasNext()) {
            BindAdviceRule bindAdviceRule = (BindAdviceRule)it.next();
            Element element = aspectElement.addElement("bind-advice");
            String exprName = bindAdviceRule.getExpression().getName();
            if (exprName != null && exprName.length() > 0) {
                element.addAttribute("pointcut", exprName);
            } else {
                element.addAttribute("pointcut", bindAdviceRule.getExpression().getExpression());
            }
            Iterator it2 = bindAdviceRule.getAdviceRefs().iterator();
            while (it2.hasNext()) {
                String adviceRef = (String)it2.next();
                Element adviceRefElement = element.addElement("advice-ref");
                adviceRefElement.addAttribute("name", adviceRef);
            }
        }
    }

    private static void weaveIntroductionDefinitionAttributes(QDoxParser qdoxParser, AspectWerkzDefinitionImpl definition) {
        JavaClass javaClass = qdoxParser.getJavaClass();
        DocletTag[] introductionDefTags = javaClass.getTagsByName("aspectwerkz.introduction-def");
        for (int i = 0; i < introductionDefTags.length; ++i) {
            if (introductionDefTags[i] == null) continue;
            IntroductionDefinition introDef = new IntroductionDefinition();
            introDef.setName(introductionDefTags[i].getNamedParameter("name"));
            introDef.setInterface(javaClass.getFullyQualifiedName());
            introDef.setImplementation(introductionDefTags[i].getNamedParameter("implementation"));
            introDef.setDeploymentModel(introductionDefTags[i].getNamedParameter("deployment-model"));
            introDef.setAttribute(introductionDefTags[i].getNamedParameter("attribute"));
            definition.addIntroduction(introDef);
        }
    }

    private static void weaveAdviceDefinitionAttributes(QDoxParser qdoxParser, AspectWerkzDefinitionImpl definition) {
        JavaClass javaClass = qdoxParser.getJavaClass();
        DocletTag[] adviceDefTags = javaClass.getTagsByName("aspectwerkz.advice-def");
        for (int i = 0; i < adviceDefTags.length; ++i) {
            if (adviceDefTags[i] == null) continue;
            AdviceDefinition adviceDef = new AdviceDefinition();
            adviceDef.setName(adviceDefTags[i].getNamedParameter("name"));
            adviceDef.setAdviceClassName(javaClass.getFullyQualifiedName());
            adviceDef.setDeploymentModel(adviceDefTags[i].getNamedParameter("deployment-model"));
            adviceDef.setAttribute(adviceDefTags[i].getNamedParameter("attribute"));
            AttributeC.weaveAdviceParamAttributes(javaClass, adviceDef);
            definition.addAdvice(adviceDef);
        }
    }

    private static void weaveAdviceParamAttributes(JavaClass javaClass, AdviceDefinition adviceDefinition) {
        DocletTag[] adviceDefTags = javaClass.getTagsByName("aspectwerkz.advice-param");
        for (int i = 0; i < adviceDefTags.length; ++i) {
            String adviceRef;
            if (adviceDefTags[i] == null || !(adviceRef = adviceDefTags[i].getNamedParameter("advice-ref")).equals(adviceDefinition.getName())) continue;
            adviceDefinition.addParameter(adviceDefTags[i].getNamedParameter("name"), adviceDefTags[i].getNamedParameter("value"));
        }
    }

    private static void parseIntroductionAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        JavaClass javaClass = qdoxParser.getJavaClass();
        DocletTag[] introductionTags = javaClass.getTagsByName("aspectwerkz.introduction");
        BindIntroductionRule bindIntroductionRule = new BindIntroductionRule();
        bindIntroductionRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).createExpression(className, PointcutType.CLASS));
        for (int i = 0; i < introductionTags.length; ++i) {
            if (introductionTags[i] == null) continue;
            String[] attributes = introductionTags[i].getParameters();
            for (int j = 0; j < attributes.length; ++j) {
                String introductionRef = definition.getIntroductionNameByAttribute(attributes[j]);
                if (introductionRef == null) continue;
                bindIntroductionRule.addIntroductionRef(introductionRef);
            }
            aspectDef.addBindIntroductionRule(bindIntroductionRule);
        }
    }

    private static void parseJoinPointControllerAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
    }

    private static void parseMethodPointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        String pointcutName = METHOD_POINTCUT_NAME + Strings.replaceSubString(className, ".", "_");
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        int counter = 0;
        JavaMethod[] javaMethods = qdoxParser.getJavaMethods();
        for (int i = 0; i < javaMethods.length; ++i) {
            DocletTag[] methodTags = javaMethods[i].getTagsByName("aspectwerkz.advice.method");
            for (int j = 0; j < methodTags.length; ++j) {
                if (methodTags[j] == null) continue;
                String cflowRef = methodTags[j].getNamedParameter("cflow");
                String isNonReentrant = methodTags[j].getNamedParameter("non-reentrant");
                String[] attributes = methodTags[j].getParameters();
                block2: for (int k = 0; k < attributes.length; ++k) {
                    String attribute = attributes[k];
                    if (attribute.startsWith("cflow=") || attribute.startsWith("non-reentrant=")) continue;
                    Iterator it2 = definition.getAdviceDefinitions().iterator();
                    while (it2.hasNext()) {
                        String adviceRef;
                        String expression = pointcutName + counter;
                        PointcutDefinition pointcutDef = new PointcutDefinition();
                        pointcutDef.setName(expression);
                        pointcutDef.setExpression(AttributeC.createExecutionPattern(className, javaMethods[i]));
                        pointcutDef.setType(PointcutType.EXECUTION);
                        pointcutDef.setNonReentrant(isNonReentrant);
                        aspectDef.addPointcutDef(pointcutDef);
                        ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", expression, PointcutType.EXECUTION);
                        String adviceAttribute = ((AdviceDefinition)it2.next()).getAttribute();
                        if (adviceAttribute == null || !adviceAttribute.equals(attribute) || (adviceRef = definition.getAdviceNameByAttribute(adviceAttribute)) == null) continue;
                        BindAdviceRule bindAdviceRule = new BindAdviceRule();
                        if (cflowRef != null) {
                            bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).createExpression(expression + " IN " + cflowRef));
                        } else {
                            bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).getExpression(expression));
                        }
                        bindAdviceRule.addAdviceRef(adviceRef);
                        aspectDef.addBindAdviceRule(bindAdviceRule);
                        ++counter;
                        continue block2;
                    }
                }
            }
        }
    }

    private static void parseSetFieldPointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        String pointcutName = SETFIELD_POINTCUT_NAME + Strings.replaceSubString(className, ".", "_");
        int counter = 0;
        JavaField[] javaFields = qdoxParser.getJavaFields();
        for (int i = 0; i < javaFields.length; ++i) {
            DocletTag[] setFieldTags = javaFields[i].getTagsByName("aspectwerkz.advice.setfield");
            for (int j = 0; j < setFieldTags.length; ++j) {
                if (setFieldTags[j] == null) continue;
                String[] setFieldAttributes = setFieldTags[j].getParameters();
                block2: for (int k = 0; k < setFieldAttributes.length; ++k) {
                    String attribute = setFieldAttributes[k];
                    Iterator it2 = definition.getAdviceDefinitions().iterator();
                    while (it2.hasNext()) {
                        String adviceRef;
                        String expression = pointcutName + counter;
                        PointcutDefinition pointcutDef = new PointcutDefinition();
                        pointcutDef.setName(expression);
                        pointcutDef.setExpression(AttributeC.createFieldPattern(className, javaFields[i]));
                        pointcutDef.setType(PointcutType.SET);
                        aspectDef.addPointcutDef(pointcutDef);
                        ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", expression, PointcutType.SET);
                        String adviceAttribute = ((AdviceDefinition)it2.next()).getAttribute();
                        if (adviceAttribute == null || !adviceAttribute.equals(attribute) || (adviceRef = definition.getAdviceNameByAttribute(adviceAttribute)) == null) continue;
                        BindAdviceRule bindAdviceRule = new BindAdviceRule();
                        bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).getExpression(expression));
                        bindAdviceRule.addAdviceRef(adviceRef);
                        aspectDef.addBindAdviceRule(bindAdviceRule);
                        ++counter;
                        continue block2;
                    }
                }
            }
        }
    }

    private static void parseGetFieldPointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        String pointcutName = GETFIELD_POINTCUT_NAME + Strings.replaceSubString(className, ".", "_");
        int counter = 0;
        JavaField[] javaFields = qdoxParser.getJavaFields();
        for (int i = 0; i < javaFields.length; ++i) {
            DocletTag[] getFieldTags = javaFields[i].getTagsByName("aspectwerkz.advice.getfield");
            for (int j = 0; j < getFieldTags.length; ++j) {
                if (getFieldTags[j] == null) continue;
                String[] getFieldAttributes = getFieldTags[j].getParameters();
                block2: for (int k = 0; k < getFieldAttributes.length; ++k) {
                    String attribute = getFieldAttributes[k];
                    Iterator it2 = definition.getAdviceDefinitions().iterator();
                    while (it2.hasNext()) {
                        String adviceRef;
                        String expression = pointcutName + counter;
                        PointcutDefinition pointcutDef = new PointcutDefinition();
                        pointcutDef.setName(expression);
                        pointcutDef.setExpression(AttributeC.createFieldPattern(className, javaFields[i]));
                        pointcutDef.setType(PointcutType.GET);
                        aspectDef.addPointcutDef(pointcutDef);
                        ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", expression, PointcutType.GET);
                        String adviceAttribute = ((AdviceDefinition)it2.next()).getAttribute();
                        if (adviceAttribute == null || !adviceAttribute.equals(attribute) || (adviceRef = definition.getAdviceNameByAttribute(adviceAttribute)) == null) continue;
                        BindAdviceRule bindAdviceRule = new BindAdviceRule();
                        bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).getExpression(expression));
                        bindAdviceRule.addAdviceRef(adviceRef);
                        aspectDef.addBindAdviceRule(bindAdviceRule);
                        ++counter;
                        continue block2;
                    }
                }
            }
        }
    }

    private static void parseThrowsPointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        String pointcutName = THROWS_POINTCUT_NAME + Strings.replaceSubString(className, ".", "_");
        int counter = 0;
        JavaMethod[] javaMethods = qdoxParser.getJavaMethods();
        for (int i = 0; i < javaMethods.length; ++i) {
            DocletTag[] throwsTags = javaMethods[i].getTagsByName("aspectwerkz.advice.throws");
            for (int j = 0; j < throwsTags.length; ++j) {
                if (throwsTags[j] == null) continue;
                String exceptionClassPattern = throwsTags[j].getNamedParameter("exception");
                if (exceptionClassPattern == null) {
                    throw new DefinitionException("exception class not specified for throws attribute at method <" + javaMethods[i].getName() + ">");
                }
                String[] attributes = throwsTags[j].getParameters();
                block2: for (int k = 0; k < attributes.length; ++k) {
                    String attribute = attributes[k];
                    if (attribute.startsWith("exception=")) continue;
                    Iterator it2 = definition.getAdviceDefinitions().iterator();
                    while (it2.hasNext()) {
                        String adviceRef;
                        String expression = pointcutName + counter;
                        PointcutDefinition pointcutDef = new PointcutDefinition();
                        pointcutDef.setName(expression);
                        pointcutDef.setExpression(AttributeC.createThrowsPattern(exceptionClassPattern, javaMethods[i]));
                        pointcutDef.setType(PointcutType.THROWS);
                        aspectDef.addPointcutDef(pointcutDef);
                        ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", expression, PointcutType.THROWS);
                        String adviceAttribute = ((AdviceDefinition)it2.next()).getAttribute();
                        if (adviceAttribute == null || !adviceAttribute.equals(attribute) || (adviceRef = definition.getAdviceNameByAttribute(adviceAttribute)) == null) continue;
                        BindAdviceRule bindAdviceRule = new BindAdviceRule();
                        bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).getExpression(expression));
                        bindAdviceRule.addAdviceRef(adviceRef);
                        aspectDef.addBindAdviceRule(bindAdviceRule);
                        ++counter;
                        continue block2;
                    }
                }
            }
        }
    }

    private static void parseCallerSidePointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        String pointcutName = CALLERSIDE_POINTCUT_NAME + Strings.replaceSubString(className, ".", "_");
        int counter = 0;
        JavaMethod[] javaMethods = qdoxParser.getJavaMethods();
        for (int i = 0; i < javaMethods.length; ++i) {
            DocletTag[] callerSideTags = javaMethods[i].getTagsByName("aspectwerkz.advice.callerside");
            for (int j = 0; j < callerSideTags.length; ++j) {
                if (callerSideTags[j] == null) continue;
                String callerClassPattern = callerSideTags[j].getNamedParameter("callerclass");
                if (callerClassPattern == null) {
                    throw new DefinitionException("caller class not specified for caller side attribute at method <" + javaMethods[i].getName() + ">");
                }
                String[] callerSideAttributes = callerSideTags[j].getParameters();
                block2: for (int k = 0; k < callerSideAttributes.length; ++k) {
                    String attribute = callerSideAttributes[k];
                    if (attribute.startsWith("callerclass=")) continue;
                    Iterator it2 = definition.getAdviceDefinitions().iterator();
                    while (it2.hasNext()) {
                        String adviceRef;
                        String expression = pointcutName + counter;
                        PointcutDefinition pointcutDef = new PointcutDefinition();
                        pointcutDef.setName(expression);
                        pointcutDef.setExpression(AttributeC.createCallerSidePattern(callerClassPattern, className, javaMethods[i]));
                        pointcutDef.setType(PointcutType.CALL);
                        aspectDef.addPointcutDef(pointcutDef);
                        ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", expression, PointcutType.CALL);
                        String adviceAttribute = ((AdviceDefinition)it2.next()).getAttribute();
                        if (adviceAttribute == null || !adviceAttribute.equals(attribute) || (adviceRef = definition.getAdviceNameByAttribute(adviceAttribute)) == null) continue;
                        BindAdviceRule bindAdviceRule = new BindAdviceRule();
                        bindAdviceRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).getExpression(expression));
                        bindAdviceRule.addAdviceRef(adviceRef);
                        aspectDef.addBindAdviceRule(bindAdviceRule);
                        ++counter;
                        continue block2;
                    }
                }
            }
        }
    }

    private static void parseCFlowPointcutAttributes(AspectWerkzDefinitionImpl definition, String className, QDoxParser qdoxParser) {
        AspectDefinition aspectDef = definition.getAspectDefinition("org/codehaus/aspectwerkz/system");
        JavaMethod[] javaMethods = qdoxParser.getJavaMethods();
        block0: for (int i = 0; i < javaMethods.length; ++i) {
            DocletTag[] cflowTags = javaMethods[i].getTagsByName("aspectwerkz.cflow");
            for (int j = 0; j < cflowTags.length; ++j) {
                String[] attributes;
                if (cflowTags[j] == null || (attributes = cflowTags[j].getParameters()).length == 0) continue;
                String name = attributes[0];
                PointcutDefinition pointcutDef = new PointcutDefinition();
                pointcutDef.setName(name);
                pointcutDef.setExpression(AttributeC.createCallerSidePattern("*", className, javaMethods[i]));
                pointcutDef.setType(PointcutType.CFLOW);
                aspectDef.addPointcutDef(pointcutDef);
                ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).registerExpression(pointcutDef.getExpression(), "", name, PointcutType.CFLOW);
                continue block0;
            }
        }
    }

    private static String createMethodPattern(JavaMethod javaMethod) {
        StringBuffer pattern = new StringBuffer();
        pattern.append(javaMethod.getReturns().getValue());
        pattern.append(' ');
        pattern.append(javaMethod.getName());
        pattern.append('(');
        JavaParameter[] parameters = javaMethod.getParameters();
        for (int l = 0; l < parameters.length; ++l) {
            JavaParameter parameter = parameters[l];
            String value = parameter.getType().getValue();
            for (int i = 1; i <= parameter.getType().getDimensions(); ++i) {
                value = value + "[]";
            }
            pattern.append(value);
            if (l == parameters.length - 1) continue;
            pattern.append(',');
        }
        pattern.append(')');
        return pattern.toString();
    }

    private static String createExecutionPattern(String className, JavaMethod javaMethod) {
        StringBuffer pattern = new StringBuffer();
        pattern.append(javaMethod.getReturns().getValue());
        pattern.append(' ');
        pattern.append(className).append('.');
        pattern.append(javaMethod.getName());
        pattern.append('(');
        JavaParameter[] parameters = javaMethod.getParameters();
        for (int l = 0; l < parameters.length; ++l) {
            JavaParameter parameter = parameters[l];
            String value = parameter.getType().getValue();
            for (int i = 1; i <= parameter.getType().getDimensions(); ++i) {
                value = value + "[]";
            }
            pattern.append(value);
            if (l == parameters.length - 1) continue;
            pattern.append(',');
        }
        pattern.append(')');
        return pattern.toString();
    }

    private static String createFieldPattern(String className, JavaField javaField) {
        StringBuffer pattern = new StringBuffer();
        String value = javaField.getType().getValue();
        for (int i = 1; i <= javaField.getType().getDimensions(); ++i) {
            value = value + "[]";
        }
        pattern.append(value);
        pattern.append(' ');
        pattern.append(className).append(".");
        pattern.append(javaField.getName());
        return pattern.toString();
    }

    private static String createThrowsPattern(String exceptionClassPattern, JavaMethod javaMethod) {
        StringBuffer throwsPattern = new StringBuffer();
        throwsPattern.append(AttributeC.createMethodPattern(javaMethod));
        throwsPattern.append('#');
        throwsPattern.append(exceptionClassPattern);
        return throwsPattern.toString();
    }

    private static String createCallerSidePattern(String callerClassPattern, String className, JavaMethod javaMethod) {
        StringBuffer callerSidePattern = new StringBuffer();
        callerSidePattern.append(callerClassPattern);
        callerSidePattern.append("->");
        callerSidePattern.append(AttributeC.createExecutionPattern(className, javaMethod));
        return callerSidePattern.toString();
    }

    private static void validate(AspectWerkzDefinitionImpl definition) {
        if (System.getProperty("aspectwerkz.definition.validate", "false").equals("true")) {
            DefinitionValidator validator = new DefinitionValidator(definition);
            validator.validate();
            List errors = validator.getErrorMessages();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                String errorMsg = (String)i.next();
                System.out.println(errorMsg);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java [options...] org.codehaus.aspectwerkz.metadata.AttributeC <path to src dir> <file name> -merge <file name to merge with> -uuid <uuid for definition>");
            System.out.println("       -merge (or -m) <file name to merge with> tells the compiler which file it should append the compiled attributes to");
            System.out.println("       -uuid (or -u) <uuid for definition> is optional (if not specified one will be generated)");
            System.exit(0);
        }
        System.out.println("AspectWerkz - AttributeC");
        String mergeFile = null;
        String uuid = null;
        if (args.length >= 4) {
            if ((args[2].equals("-m") || args[2].equals("-merge")) && args[3] != null) {
                mergeFile = args[3];
            } else if ((args[2].equals("-u") || args[2].equals("-uuid")) && args[3] != null) {
                uuid = args[3];
            }
        }
        if (args.length >= 6) {
            if ((args[4].equals("-m") || args[4].equals("-merge")) && args[5] != null) {
                mergeFile = args[5];
            } else if ((args[4].equals("-u") || args[4].equals("-uuid")) && args[5] != null) {
                uuid = args[5];
            }
        }
        System.out.println("Compiling XML definition...");
        if (args.length == 2) {
            AttributeC.compile(args[0], args[1]);
        } else {
            if (mergeFile != null) {
                System.out.println("    Merging with: " + mergeFile);
            }
            if (uuid != null) {
                System.out.println("    UUID: " + uuid);
            }
            AttributeC.compile(args[0], args[1], mergeFile, uuid);
        }
        System.out.println("XML definition for classes in " + args[0] + " have been compiled to " + args[1]);
    }
}

