/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.InterfaceMetaData;
import org.codehaus.aspectwerkz.metadata.MetaDataMaker;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;

public class BcelMetaDataMaker
extends MetaDataMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMetaData createClassMetaData(JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (s_classMetaDataCache.containsKey(javaClass.getClassName())) {
            return (ClassMetaData)s_classMetaDataCache.get(javaClass.getClassName());
        }
        ClassMetaData classMetaData = new ClassMetaData();
        classMetaData.setName(javaClass.getClassName());
        classMetaData.setModifiers(javaClass.getModifiers());
        ArrayList<MethodMetaData> methodList = new ArrayList<MethodMetaData>();
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            methodList.add(BcelMetaDataMaker.createMethodMetaData(method));
        }
        classMetaData.setMethods(methodList);
        ArrayList<FieldMetaData> fieldList = new ArrayList<FieldMetaData>();
        Field[] fields = javaClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            fieldList.add(BcelMetaDataMaker.createFieldMetaData(field));
        }
        classMetaData.setFields(fieldList);
        try {
            ArrayList<InterfaceMetaData> interfaceList = new ArrayList<InterfaceMetaData>();
            JavaClass[] interfaces = javaClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                JavaClass anInterface = interfaces[i];
                interfaceList.add(BcelMetaDataMaker.createInterfaceMetaData(anInterface));
            }
            classMetaData.setInterfaces(interfaceList);
            JavaClass superClass = javaClass.getSuperClass();
            if (superClass != null) {
                ClassMetaData superClassMetaData = BcelMetaDataMaker.createClassMetaData(superClass);
                classMetaData.setSuperClass(superClassMetaData);
            }
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
        Map map = s_classMetaDataCache;
        synchronized (map) {
            s_classMetaDataCache.put(classMetaData.getName(), classMetaData);
        }
        return classMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InterfaceMetaData createInterfaceMetaData(JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (s_interfaceMetaDataCache.containsKey(javaClass.getClassName())) {
            return (InterfaceMetaData)s_interfaceMetaDataCache.get(javaClass.getClassName());
        }
        InterfaceMetaData interfaceMetaData = new InterfaceMetaData();
        interfaceMetaData.setName(javaClass.getClassName());
        try {
            ArrayList<InterfaceMetaData> interfaceList = new ArrayList<InterfaceMetaData>();
            JavaClass[] interfaces = javaClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                JavaClass anInterface = interfaces[i];
                interfaceList.add(BcelMetaDataMaker.createInterfaceMetaData(anInterface));
            }
            interfaceMetaData.setInterfaces(interfaceList);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
        Map map = s_interfaceMetaDataCache;
        synchronized (map) {
            s_interfaceMetaDataCache.put(interfaceMetaData.getName(), interfaceMetaData);
        }
        return interfaceMetaData;
    }

    public static MethodMetaData createMethodMetaData(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("method can not be null");
        }
        MethodMetaData methodMetaData = new MethodMetaData();
        methodMetaData.setName(method.getName());
        methodMetaData.setReturnType(method.getReturnType().toString());
        Type[] javaParameters = method.getArgumentTypes();
        String[] parameterTypes = new String[javaParameters.length];
        for (int j = 0; j < javaParameters.length; ++j) {
            parameterTypes[j] = javaParameters[j].toString();
        }
        methodMetaData.setParameterTypes(parameterTypes);
        ExceptionTable exceptionTable = method.getExceptionTable();
        String[] exceptions = exceptionTable != null ? exceptionTable.getExceptionNames() : new String[]{};
        methodMetaData.setExceptionTypes(exceptions);
        methodMetaData.setModifiers(method.getModifiers());
        return methodMetaData;
    }

    public static MethodMetaData createMethodMetaData(InvokeInstruction instruction, ConstantPoolGen cpg) {
        if (instruction == null) {
            throw new IllegalArgumentException("instruction can not be null");
        }
        if (cpg == null) {
            throw new IllegalArgumentException("constant pool can not be null");
        }
        MethodMetaData methodMetaData = new MethodMetaData();
        String signature = instruction.getSignature(cpg);
        methodMetaData.setName(instruction.getName(cpg));
        Type[] parameterTypes = Type.getArgumentTypes((String)signature);
        String[] parameterTypeNames = new String[parameterTypes.length];
        for (int j = 0; j < parameterTypes.length; ++j) {
            parameterTypeNames[j] = parameterTypes[j].toString();
        }
        methodMetaData.setParameterTypes(parameterTypeNames);
        methodMetaData.setReturnType(Type.getReturnType((String)signature).toString());
        return methodMetaData;
    }

    private static FieldMetaData createFieldMetaData(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("field can not be null");
        }
        FieldMetaData fieldMetaData = new FieldMetaData();
        fieldMetaData.setName(field.getName());
        fieldMetaData.setType(field.getType().toString());
        fieldMetaData.setModifiers(field.getModifiers());
        return fieldMetaData;
    }

    public static FieldMetaData createFieldMetaData(FieldInstruction instruction, ConstantPoolGen cpg) {
        if (instruction == null) {
            throw new IllegalArgumentException("instruction can not be null");
        }
        if (cpg == null) {
            throw new IllegalArgumentException("constant pool can not be null");
        }
        FieldMetaData fieldMetaData = new FieldMetaData();
        fieldMetaData.setName(instruction.getFieldName(cpg));
        fieldMetaData.setType(instruction.getFieldType(cpg).toString());
        return fieldMetaData;
    }
}

