/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.metadata;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.InterfaceMetaData;
import org.codehaus.aspectwerkz.metadata.MetaDataMaker;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.TypeConverter;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class QDoxMetaDataMaker
extends MetaDataMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMetaData createClassMetaData(JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (s_classMetaDataCache.containsKey(javaClass.getName())) {
            return (ClassMetaData)s_classMetaDataCache.get(javaClass.getName());
        }
        ClassMetaData classMetaData = new ClassMetaData();
        classMetaData.setName(javaClass.getName());
        ArrayList<MethodMetaData> methodList = new ArrayList<MethodMetaData>();
        JavaMethod[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            methodList.add(QDoxMetaDataMaker.createMethodMetaData(method));
        }
        classMetaData.setMethods(methodList);
        ArrayList<FieldMetaData> fieldList = new ArrayList<FieldMetaData>();
        JavaField[] fields = javaClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            JavaField field = fields[i];
            fieldList.add(QDoxMetaDataMaker.createFieldMetaData(field));
        }
        classMetaData.setFields(fieldList);
        ArrayList<InterfaceMetaData> interfaceList = new ArrayList<InterfaceMetaData>();
        Type[] interfaces = javaClass.getImplements();
        for (int i = 0; i < interfaces.length; ++i) {
            Type anInterface = interfaces[i];
            interfaceList.add(QDoxMetaDataMaker.createInterfaceMetaData(anInterface));
        }
        classMetaData.setInterfaces(interfaceList);
        JavaClass superClass = javaClass.getSuperJavaClass();
        if (superClass != null) {
            ClassMetaData superClassMetaData = QDoxMetaDataMaker.createClassMetaData(superClass);
            classMetaData.setSuperClass(superClassMetaData);
        }
        Map map = s_classMetaDataCache;
        synchronized (map) {
            s_classMetaDataCache.put(classMetaData.getName(), classMetaData);
        }
        return classMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterfaceMetaData createInterfaceMetaData(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("interface can not be null");
        }
        if (s_interfaceMetaDataCache.containsKey(type.getValue())) {
            return (InterfaceMetaData)s_interfaceMetaDataCache.get(type.getValue());
        }
        InterfaceMetaData interfaceMetaData = new InterfaceMetaData();
        interfaceMetaData.setName(type.getValue());
        Map map = s_interfaceMetaDataCache;
        synchronized (map) {
            s_interfaceMetaDataCache.put(interfaceMetaData.getName(), interfaceMetaData);
        }
        return interfaceMetaData;
    }

    public static MethodMetaData createMethodMetaData(JavaMethod method) {
        MethodMetaData data = new MethodMetaData();
        data.setName(method.getName());
        data.setModifiers(TransformationUtil.getModifiersAsInt(method.getModifiers()));
        Type returnType = method.getReturns();
        if (returnType != null) {
            data.setReturnType(TypeConverter.convertTypeToJava(returnType));
        }
        JavaParameter[] parameters = method.getParameters();
        String[] parameterTypes = new String[parameters.length];
        for (int j = 0; j < parameters.length; ++j) {
            parameterTypes[j] = TypeConverter.convertTypeToJava(parameters[j].getType());
        }
        data.setParameterTypes(parameterTypes);
        Type[] exceptions = method.getExceptions();
        String[] exceptionTypes = new String[exceptions.length];
        for (int j = 0; j < exceptions.length; ++j) {
            exceptionTypes[j] = TypeConverter.convertTypeToJava(exceptions[j]);
        }
        data.setExceptionTypes(exceptionTypes);
        return data;
    }

    public static FieldMetaData createFieldMetaData(JavaField field) {
        FieldMetaData data = new FieldMetaData();
        data.setName(field.getName());
        data.setModifiers(TransformationUtil.getModifiersAsInt(field.getModifiers()));
        data.setType(TypeConverter.convertTypeToJava(field.getType()));
        return data;
    }
}

