/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.InterfaceMetaData;
import org.codehaus.aspectwerkz.metadata.MetaDataMaker;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.TypeConverter;

public class ReflectionMetaDataMaker
extends MetaDataMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMetaData createClassMetaData(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (s_classMetaDataCache.containsKey(klass.getName())) {
            return (ClassMetaData)s_classMetaDataCache.get(klass.getName());
        }
        ClassMetaData classMetaData = new ClassMetaData();
        classMetaData.setName(klass.getName());
        classMetaData.setModifiers(klass.getModifiers());
        ArrayList<MethodMetaData> methodList = new ArrayList<MethodMetaData>();
        Method[] methods = klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            methodList.add(ReflectionMetaDataMaker.createMethodMetaData(method));
        }
        Constructor<?>[] constructors = klass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            methodList.add(ReflectionMetaDataMaker.createMethodMetaData(constructor));
        }
        classMetaData.setMethods(methodList);
        ArrayList<FieldMetaData> fieldList = new ArrayList<FieldMetaData>();
        Field[] fields = klass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            fieldList.add(ReflectionMetaDataMaker.createFieldMetaData(field));
        }
        classMetaData.setFields(fieldList);
        ArrayList<InterfaceMetaData> interfaceList = new ArrayList<InterfaceMetaData>();
        Class<?>[] interfaces = klass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            interfaceList.add(ReflectionMetaDataMaker.createInterfaceMetaData(anInterface));
        }
        classMetaData.setInterfaces(interfaceList);
        Class superClass = klass.getSuperclass();
        if (superClass != null) {
            ClassMetaData superClassMetaData = ReflectionMetaDataMaker.createClassMetaData(superClass);
            classMetaData.setSuperClass(superClassMetaData);
        }
        Map map = s_classMetaDataCache;
        synchronized (map) {
            s_classMetaDataCache.put(classMetaData.getName(), classMetaData);
        }
        return classMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterfaceMetaData createInterfaceMetaData(Class anInterface) {
        if (anInterface == null) {
            throw new IllegalArgumentException("interface can not be null");
        }
        if (s_interfaceMetaDataCache.containsKey(anInterface.getName())) {
            return (InterfaceMetaData)s_interfaceMetaDataCache.get(anInterface.getName());
        }
        InterfaceMetaData interfaceMetaData = new InterfaceMetaData();
        interfaceMetaData.setName(anInterface.getName());
        ArrayList<InterfaceMetaData> interfaceList = new ArrayList<InterfaceMetaData>();
        Class<?>[] interfaces = anInterface.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> klass = interfaces[i];
            interfaceList.add(ReflectionMetaDataMaker.createInterfaceMetaData(klass));
        }
        interfaceMetaData.setInterfaces(interfaceList);
        Map map = s_interfaceMetaDataCache;
        synchronized (map) {
            s_interfaceMetaDataCache.put(interfaceMetaData.getName(), interfaceMetaData);
        }
        return interfaceMetaData;
    }

    public static MethodMetaData createMethodMetaData(String methodName, Class[] parameterTypes, Class returnType) {
        MethodMetaData data = new MethodMetaData();
        data.setName(methodName);
        data.setParameterTypes(TypeConverter.convertTypeToJava(parameterTypes));
        data.setReturnType(TypeConverter.convertTypeToJava(returnType));
        return data;
    }

    public static MethodMetaData createMethodMetaData(Method method) {
        MethodMetaData data = new MethodMetaData();
        data.setName(method.getName());
        data.setModifiers(method.getModifiers());
        data.setReturnType(TypeConverter.convertTypeToJava(method.getReturnType()));
        data.setParameterTypes(TypeConverter.convertTypeToJava(method.getParameterTypes()));
        data.setExceptionTypes(TypeConverter.convertTypeToJava(method.getExceptionTypes()));
        return data;
    }

    public static MethodMetaData createMethodMetaData(Constructor method) {
        MethodMetaData data = new MethodMetaData();
        data.setName("<init>");
        data.setModifiers(method.getModifiers());
        data.setReturnType("void");
        data.setParameterTypes(TypeConverter.convertTypeToJava(method.getParameterTypes()));
        data.setExceptionTypes(TypeConverter.convertTypeToJava(method.getExceptionTypes()));
        return data;
    }

    public static FieldMetaData createFieldMetaData(String fieldName, String typeName) {
        FieldMetaData data = new FieldMetaData();
        data.setName(fieldName);
        data.setType(typeName);
        return data;
    }

    public static FieldMetaData createFieldMetaData(Field field) {
        FieldMetaData fieldMetaData = new FieldMetaData();
        fieldMetaData.setName(field.getName());
        fieldMetaData.setModifiers(field.getModifiers());
        fieldMetaData.setType(TypeConverter.convertTypeToJava(field.getType()));
        return fieldMetaData;
    }
}

