/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.pointcut;

import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.NameIndexTuple;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.definition.expression.Expression;

public abstract class AbstractPointcut {
    protected Expression m_expression;
    protected String m_cflowExpression;
    protected Map m_pointcutPatterns = new HashMap();
    protected String[] m_names = new String[0];
    protected IndexTuple[] m_indexes = new IndexTuple[0];
    protected String m_uuid;

    public AbstractPointcut(String uuid, Expression expression) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression be null");
        }
        this.m_uuid = uuid;
        this.m_expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_names;
        synchronized (this.m_names) {
            IndexTuple[] indexTupleArray = this.m_indexes;
            synchronized (this.m_indexes) {
                String[] tmp = new String[this.m_names.length + 1];
                System.arraycopy(this.m_names, 0, tmp, 0, this.m_names.length);
                tmp[this.m_names.length] = advice;
                this.m_names = new String[this.m_names.length + 1];
                System.arraycopy(tmp, 0, this.m_names, 0, tmp.length);
                this.m_indexes = new IndexTuple[this.m_names.length];
                int j = this.m_names.length;
                for (int i = 0; i < j; ++i) {
                    this.m_indexes[i] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_names[i]);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdvices(String[] advicesToAdd) {
        for (int i = 0; i < advicesToAdd.length; ++i) {
            if (advicesToAdd[i] != null && advicesToAdd[i].trim().length() != 0) continue;
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_names;
        synchronized (this.m_names) {
            IndexTuple[] indexTupleArray = this.m_indexes;
            synchronized (this.m_indexes) {
                String[] clone = new String[advicesToAdd.length];
                System.arraycopy(advicesToAdd, 0, clone, 0, advicesToAdd.length);
                String[] tmp = new String[this.m_names.length + advicesToAdd.length];
                System.arraycopy(this.m_names, 0, tmp, 0, this.m_names.length);
                System.arraycopy(clone, 0, tmp, this.m_names.length, tmp.length);
                this.m_names = new String[tmp.length];
                System.arraycopy(tmp, 0, this.m_names, 0, tmp.length);
                this.m_indexes = new IndexTuple[this.m_names.length];
                for (int j = 0; j < this.m_names.length; ++j) {
                    this.m_indexes[j] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_names[j]);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to remove can not be null or an empty string");
        }
        String[] stringArray = this.m_names;
        synchronized (this.m_names) {
            IndexTuple[] indexTupleArray = this.m_indexes;
            synchronized (this.m_indexes) {
                int index = -1;
                for (int i = 0; i < this.m_names.length; ++i) {
                    if (!this.m_names[i].equals(advice)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    throw new RuntimeException("can not remove advice with the name " + advice + ": no such advice");
                }
                String[] names = new String[this.m_names.length - 1];
                int j = 0;
                int k = 0;
                while (j < index) {
                    names[j] = this.m_names[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_names.length) {
                    names[k] = this.m_names[j];
                    ++j;
                    ++k;
                }
                this.m_names = new String[names.length];
                System.arraycopy(names, 0, this.m_names, 0, names.length);
                IndexTuple[] indexes = new IndexTuple[this.m_indexes.length - 1];
                j = 0;
                k = 0;
                while (j < index) {
                    indexes[j] = this.m_indexes[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_indexes.length) {
                    indexes[k] = this.m_indexes[j];
                    ++j;
                    ++k;
                }
                this.m_indexes = new IndexTuple[indexes.length];
                System.arraycopy(indexes, 0, this.m_indexes, 0, indexes.length);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public boolean hasAdvice(String advice) {
        for (int i = 0; i < this.m_names.length; ++i) {
            if (!this.m_names[i].equals(advice)) continue;
            return true;
        }
        return false;
    }

    public String getCFlowExpression() {
        return this.m_cflowExpression;
    }

    public void setCFlowExpression(String cflowExpression) {
        this.m_cflowExpression = cflowExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAdviceIndexTuples() {
        IndexTuple[] indexTupleArray = this.m_indexes;
        synchronized (this.m_indexes) {
            String[] stringArray = this.m_names;
            synchronized (this.m_names) {
                ArrayList<NameIndexTuple> advices = new ArrayList<NameIndexTuple>(this.m_names.length);
                for (int i = 0; i < this.m_names.length; ++i) {
                    advices.add(new NameIndexTuple(this.m_names[i], this.m_indexes[i]));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return advices;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdviceIndexTuples(List advices) {
        IndexTuple[] indexTupleArray = this.m_indexes;
        synchronized (this.m_indexes) {
            String[] stringArray = this.m_names;
            synchronized (this.m_names) {
                this.m_names = new String[advices.size()];
                this.m_indexes = new IndexTuple[advices.size()];
                int i = 0;
                Iterator it = advices.iterator();
                while (it.hasNext()) {
                    try {
                        NameIndexTuple tuple = (NameIndexTuple)it.next();
                        this.m_names[i] = tuple.getName();
                        this.m_indexes[i] = tuple.getIndex();
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("advice list must only contain AdviceIndexTuples");
                    }
                    ++i;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public IndexTuple getAdviceIndex(int index) {
        return this.m_indexes[index];
    }

    public IndexTuple[] getAdviceIndexes() {
        return this.m_indexes;
    }

    public String[] getAdviceNames() {
        return this.m_names;
    }

    public Expression getExpression() {
        return this.m_expression;
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_expression = (Expression)fields.get("m_expression", null);
        this.m_pointcutPatterns = (Map)fields.get("m_pointcutPatterns", null);
        this.m_names = (String[])fields.get("m_names", null);
        this.m_indexes = (IndexTuple[])fields.get("m_indexes", null);
        this.m_uuid = (String)fields.get("m_uuid", null);
    }
}

