/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.pointcut;

import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.NameIndexTuple;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;

public class GetPointcut {
    protected Expression m_expression;
    protected String m_cflowExpression;
    protected Map m_pointcutDefs = new HashMap();
    protected String m_uuid;
    protected String[] m_preNames = new String[0];
    protected String[] m_postNames = new String[0];
    protected IndexTuple[] m_preIndexes = new IndexTuple[0];
    protected IndexTuple[] m_postIndexes = new IndexTuple[0];

    public GetPointcut(String uuid, Expression expression) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression can not be null");
        }
        this.m_uuid = uuid;
        this.m_expression = expression;
    }

    public void addPointcutDef(PointcutDefinition pointcut) {
        this.m_pointcutDefs.put(pointcut.getName(), pointcut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeforeAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_preNames;
        synchronized (this.m_preNames) {
            IndexTuple[] indexTupleArray = this.m_preIndexes;
            synchronized (this.m_preIndexes) {
                String[] tmp = new String[this.m_preNames.length + 1];
                System.arraycopy(this.m_preNames, 0, tmp, 0, this.m_preNames.length);
                tmp[this.m_preNames.length] = advice;
                this.m_preNames = new String[this.m_preNames.length + 1];
                System.arraycopy(tmp, 0, this.m_preNames, 0, tmp.length);
                this.m_preIndexes = new IndexTuple[this.m_preNames.length];
                int j = this.m_preNames.length;
                for (int i = 0; i < j; ++i) {
                    this.m_preIndexes[i] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_preNames[i]);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfterAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_postNames;
        synchronized (this.m_postNames) {
            IndexTuple[] indexTupleArray = this.m_postIndexes;
            synchronized (this.m_postIndexes) {
                String[] tmp = new String[this.m_postNames.length + 1];
                System.arraycopy(this.m_postNames, 0, tmp, 0, this.m_postNames.length);
                tmp[this.m_postNames.length] = advice;
                this.m_postNames = new String[this.m_postNames.length + 1];
                System.arraycopy(tmp, 0, this.m_postNames, 0, tmp.length);
                this.m_postIndexes = new IndexTuple[this.m_postNames.length];
                int j = this.m_postNames.length;
                for (int i = 0; i < j; ++i) {
                    this.m_postIndexes[i] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_postNames[i]);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreAdvices(String[] advicesToAdd) {
        for (int i = 0; i < advicesToAdd.length; ++i) {
            if (advicesToAdd[i] != null && advicesToAdd[i].trim().length() != 0) continue;
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_preNames;
        synchronized (this.m_preNames) {
            IndexTuple[] indexTupleArray = this.m_preIndexes;
            synchronized (this.m_preIndexes) {
                String[] clone = new String[advicesToAdd.length];
                System.arraycopy(advicesToAdd, 0, clone, 0, advicesToAdd.length);
                String[] tmp = new String[this.m_preNames.length + advicesToAdd.length];
                System.arraycopy(this.m_preNames, 0, tmp, 0, this.m_preNames.length);
                System.arraycopy(clone, 0, tmp, this.m_preNames.length, tmp.length);
                this.m_preNames = new String[tmp.length];
                System.arraycopy(tmp, 0, this.m_preNames, 0, tmp.length);
                this.m_preIndexes = new IndexTuple[this.m_preNames.length];
                for (int j = 0; j < this.m_preNames.length; ++j) {
                    this.m_preIndexes[j] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_preNames[j]);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostAdvices(String[] advicesToAdd) {
        for (int i = 0; i < advicesToAdd.length; ++i) {
            if (advicesToAdd[i] != null && advicesToAdd[i].trim().length() != 0) continue;
            throw new IllegalArgumentException("name of advice to add can not be null or an empty string");
        }
        String[] stringArray = this.m_postNames;
        synchronized (this.m_postNames) {
            IndexTuple[] indexTupleArray = this.m_postIndexes;
            synchronized (this.m_postIndexes) {
                String[] clone = new String[advicesToAdd.length];
                System.arraycopy(advicesToAdd, 0, clone, 0, advicesToAdd.length);
                String[] tmp = new String[this.m_postNames.length + advicesToAdd.length];
                System.arraycopy(this.m_postNames, 0, tmp, 0, this.m_postNames.length);
                System.arraycopy(clone, 0, tmp, this.m_postNames.length, tmp.length);
                this.m_postNames = new String[tmp.length];
                System.arraycopy(tmp, 0, this.m_postNames, 0, tmp.length);
                this.m_postIndexes = new IndexTuple[this.m_postNames.length];
                for (int j = 0; j < this.m_postNames.length; ++j) {
                    this.m_postIndexes[j] = SystemLoader.getSystem(this.m_uuid).getAdviceIndexFor(this.m_postNames[j]);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to remove can not be null or an empty string");
        }
        String[] stringArray = this.m_preNames;
        synchronized (this.m_preNames) {
            IndexTuple[] indexTupleArray = this.m_preIndexes;
            synchronized (this.m_preIndexes) {
                int index = -1;
                for (int i = 0; i < this.m_preNames.length; ++i) {
                    if (!this.m_preNames[i].equals(advice)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    throw new RuntimeException("can not remove pre advice with the name " + advice + ": no such advice");
                }
                String[] names = new String[this.m_preNames.length - 1];
                int j = 0;
                int k = 0;
                while (j < index) {
                    names[j] = this.m_preNames[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_preNames.length) {
                    names[k] = this.m_preNames[j];
                    ++j;
                    ++k;
                }
                this.m_preNames = new String[names.length];
                System.arraycopy(names, 0, this.m_preNames, 0, names.length);
                IndexTuple[] indexes = new IndexTuple[this.m_preIndexes.length - 1];
                j = 0;
                k = 0;
                while (j < index) {
                    indexes[j] = this.m_preIndexes[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_preIndexes.length) {
                    indexes[k] = this.m_preIndexes[j];
                    ++j;
                    ++k;
                }
                this.m_preIndexes = new IndexTuple[indexes.length];
                System.arraycopy(indexes, 0, this.m_preIndexes, 0, indexes.length);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostAdvice(String advice) {
        if (advice == null || advice.trim().length() == 0) {
            throw new IllegalArgumentException("name of advice to remove can not be null or an empty string");
        }
        String[] stringArray = this.m_postNames;
        synchronized (this.m_postNames) {
            IndexTuple[] indexTupleArray = this.m_postIndexes;
            synchronized (this.m_postIndexes) {
                int index = -1;
                for (int i = 0; i < this.m_postNames.length; ++i) {
                    if (!this.m_postNames[i].equals(advice)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    throw new RuntimeException("can not remove post advice with the name " + advice + ": no such advice");
                }
                String[] names = new String[this.m_postNames.length - 1];
                int j = 0;
                int k = 0;
                while (j < index) {
                    names[j] = this.m_postNames[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_postNames.length) {
                    names[k] = this.m_postNames[j];
                    ++j;
                    ++k;
                }
                this.m_postNames = new String[names.length];
                System.arraycopy(names, 0, this.m_postNames, 0, names.length);
                IndexTuple[] indexes = new IndexTuple[this.m_postIndexes.length - 1];
                j = 0;
                k = 0;
                while (j < index) {
                    indexes[j] = this.m_postIndexes[j];
                    ++j;
                    ++k;
                }
                ++j;
                while (j < this.m_postIndexes.length) {
                    indexes[k] = this.m_postIndexes[j];
                    ++j;
                    ++k;
                }
                this.m_postIndexes = new IndexTuple[indexes.length];
                System.arraycopy(indexes, 0, this.m_postIndexes, 0, indexes.length);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public boolean hasPreAdvice(String advice) {
        for (int i = 0; i < this.m_preNames.length; ++i) {
            if (!this.m_preNames[i].equals(advice)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPostAdvice(String advice) {
        for (int i = 0; i < this.m_postNames.length; ++i) {
            if (!this.m_postNames[i].equals(advice)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameIndexTuple[] getPreAdviceIndexTuples() {
        IndexTuple[] indexTupleArray = this.m_preIndexes;
        synchronized (this.m_preIndexes) {
            String[] stringArray = this.m_preNames;
            synchronized (this.m_preNames) {
                NameIndexTuple[] tuples = new NameIndexTuple[this.m_preNames.length];
                for (int i = 0; i < this.m_preNames.length; ++i) {
                    tuples[i] = new NameIndexTuple(this.m_preNames[i], this.m_preIndexes[i]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return tuples;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreAdviceIndexTuples(NameIndexTuple[] tuple) {
        IndexTuple[] indexTupleArray = this.m_preIndexes;
        synchronized (this.m_preIndexes) {
            String[] stringArray = this.m_preNames;
            synchronized (this.m_preNames) {
                this.m_preNames = new String[tuple.length];
                this.m_preIndexes = new IndexTuple[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    this.m_preNames[i] = tuple[i].getName();
                    this.m_preIndexes[i] = tuple[i].getIndex();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameIndexTuple[] getPostAdviceIndexTuples() {
        IndexTuple[] indexTupleArray = this.m_postIndexes;
        synchronized (this.m_postIndexes) {
            String[] stringArray = this.m_postNames;
            synchronized (this.m_postNames) {
                NameIndexTuple[] tuples = new NameIndexTuple[this.m_postNames.length];
                for (int i = 0; i < this.m_postNames.length; ++i) {
                    tuples[i] = new NameIndexTuple(this.m_postNames[i], this.m_postIndexes[i]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return tuples;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostAdviceIndexTuples(NameIndexTuple[] tuple) {
        IndexTuple[] indexTupleArray = this.m_postIndexes;
        synchronized (this.m_postIndexes) {
            String[] stringArray = this.m_postNames;
            synchronized (this.m_postNames) {
                this.m_postNames = new String[tuple.length];
                this.m_postIndexes = new IndexTuple[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    this.m_postNames[i] = tuple[i].getName();
                    this.m_postIndexes[i] = tuple[i].getIndex();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public String getCFlowExpression() {
        return this.m_cflowExpression;
    }

    public void setCFlowExpression(String cflowExpression) {
        this.m_cflowExpression = cflowExpression;
    }

    public IndexTuple[] getPreAdviceIndexes() {
        return this.m_preIndexes;
    }

    public String[] getPreAdviceNames() {
        return this.m_preNames;
    }

    public IndexTuple[] getPostAdviceIndexes() {
        return this.m_postIndexes;
    }

    public String[] getPostAdviceNames() {
        return this.m_postNames;
    }

    public Expression getExpression() {
        return this.m_expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreAdvices(IndexTuple[] indexes, String[] names) {
        IndexTuple[] indexTupleArray = this.m_preIndexes;
        synchronized (this.m_preIndexes) {
            String[] stringArray = this.m_preNames;
            synchronized (this.m_preNames) {
                this.m_preIndexes = indexes;
                this.m_preNames = names;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostAdvices(IndexTuple[] indexes, String[] names) {
        IndexTuple[] indexTupleArray = this.m_postIndexes;
        synchronized (this.m_postIndexes) {
            String[] stringArray = this.m_postNames;
            synchronized (this.m_postNames) {
                this.m_postIndexes = indexes;
                this.m_postNames = names;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_expression = (Expression)fields.get("m_expression", null);
        this.m_pointcutDefs = (Map)fields.get("m_pointcutDefs", null);
        this.m_preNames = (String[])fields.get("m_preNames", null);
        this.m_postNames = (String[])fields.get("m_postNames", null);
        this.m_preIndexes = (IndexTuple[])fields.get("m_preIndexes", null);
        this.m_postIndexes = (IndexTuple[])fields.get("m_postIndexes", null);
        this.m_uuid = (String)fields.get("m_uuid", null);
    }
}

