/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.regexp;

import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.regexp.ClassPattern;
import org.codehaus.aspectwerkz.regexp.MethodPattern;
import org.codehaus.aspectwerkz.regexp.Pattern;

public class CallerSidePattern
extends Pattern {
    protected String m_pattern;
    protected ClassPattern m_callerClassPattern;
    protected ClassPattern m_calleeClassPattern;
    protected MethodPattern m_methodPattern;

    public boolean matches(String className) {
        return this.m_calleeClassPattern.matches(className);
    }

    public boolean matches(MethodMetaData methodMetaData) {
        return this.m_methodPattern.matches(methodMetaData);
    }

    public boolean matches(String className, MethodMetaData methodMetaData) {
        return this.m_calleeClassPattern.matches(className) && this.m_methodPattern.matches(methodMetaData);
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void parse(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(this.m_pattern, "->");
        try {
            this.m_calleeClassPattern = Pattern.compileClassPattern(tokenizer.nextToken());
            this.m_methodPattern = Pattern.compileMethodPattern(tokenizer.nextToken());
        }
        catch (Exception e) {
            throw new DefinitionException("method pattern is not well formed: " + pattern, e);
        }
    }

    CallerSidePattern(String pattern) {
        this.m_pattern = pattern;
        this.parse(this.m_pattern);
    }
}

