/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.regexp;

import java.io.ObjectInputStream;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.regexp.Pattern;
import org.codehaus.aspectwerkz.util.Strings;

public class ClassPattern
extends Pattern {
    protected transient com.karneim.util.collection.regex.Pattern m_classNamePattern;
    protected String m_pattern;

    public boolean matches(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (className.equals("")) {
            return false;
        }
        return this.m_classNamePattern.contains(className);
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void parse(String pattern) {
        String className = pattern;
        try {
            if (className.equals("*") || className.equals("..")) {
                className = "[a-zA-Z0-9_$.]+";
            } else {
                className = Strings.replaceSubString(className, "..", "[a-zA-Z0-9_$.]+");
                className = Strings.replaceSubString(className, ".", "\\.");
                className = Strings.replaceSubString(className, "*", "[a-zA-Z0-9_$]*");
            }
            this.m_classNamePattern = new com.karneim.util.collection.regex.Pattern(className);
        }
        catch (Throwable e) {
            throw new DefinitionException("class pattern is not well formed: " + pattern, e);
        }
    }

    ClassPattern(String pattern) {
        this.m_pattern = pattern;
        this.parse(this.m_pattern);
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_pattern = (String)fields.get("m_pattern", null);
        this.parse(this.m_pattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + ClassPattern.hashCodeOrZeroIfNull(this.m_pattern);
        result = 37 * result + ClassPattern.hashCodeOrZeroIfNull(this.m_classNamePattern);
        result = 37 * result + ClassPattern.hashCodeOrZeroIfNull(m_abbreviations);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassPattern)) {
            return false;
        }
        ClassPattern obj = (ClassPattern)o;
        if (!ClassPattern.areEqualsOrBothNull(obj.m_pattern, this.m_pattern)) return false;
        if (!ClassPattern.areEqualsOrBothNull(obj.m_classNamePattern, this.m_classNamePattern)) return false;
        if (!ClassPattern.areEqualsOrBothNull(m_abbreviations, m_abbreviations)) return false;
        return true;
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

