/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.regexp;

import java.io.ObjectInputStream;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.regexp.MethodPattern;
import org.codehaus.aspectwerkz.regexp.Pattern;
import org.codehaus.aspectwerkz.util.Strings;

public class FieldPattern
extends Pattern {
    protected transient com.karneim.util.collection.regex.Pattern m_fieldNamePattern;
    protected transient com.karneim.util.collection.regex.Pattern m_fieldTypePattern;
    protected String m_pattern;

    public boolean matches(FieldMetaData field) {
        if (!this.matchFieldName(field.getName())) {
            return false;
        }
        return this.matchFieldType(field.getType());
    }

    public boolean matchFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name can not be null");
        }
        if (fieldName.equals("")) {
            return false;
        }
        return this.m_fieldNamePattern.contains(fieldName);
    }

    public boolean matchFieldType(String fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("field type can not be null");
        }
        if (fieldType.equals("")) {
            return false;
        }
        return this.m_fieldTypePattern.contains(fieldType);
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void parse(String pattern) {
        try {
            this.parseFieldTypePattern(pattern);
            this.parseFieldNamePattern(pattern);
        }
        catch (Throwable e) {
            throw new DefinitionException("field pattern is not well formed: " + pattern, e);
        }
    }

    protected void parseFieldNamePattern(String pattern) {
        int startIndexFieldName = pattern.indexOf(32) + 1;
        String fieldName = pattern.substring(startIndexFieldName, pattern.length());
        fieldName = fieldName.equals("*") ? "[a-zA-Z0-9_$]*" : Strings.replaceSubString(fieldName, "*", "[a-zA-Z0-9_$]*");
        this.m_fieldNamePattern = new com.karneim.util.collection.regex.Pattern(fieldName);
    }

    protected void parseFieldTypePattern(String pattern) {
        int endIndexFieldType = pattern.indexOf(32);
        String fieldType = pattern.substring(0, endIndexFieldType);
        if (m_abbreviations.containsKey(fieldType)) {
            fieldType = (String)m_abbreviations.get(fieldType);
        }
        if (fieldType.equals("*")) {
            fieldType = "[a-zA-Z0-9_$.]+";
        } else {
            fieldType = Strings.replaceSubString(fieldType, ".", "\\.");
            fieldType = Strings.replaceSubString(fieldType, "[", "\\[");
            fieldType = Strings.replaceSubString(fieldType, "]", "\\]");
            fieldType = Strings.replaceSubString(fieldType, "*", "[a-zA-Z0-9_$]*");
        }
        this.m_fieldTypePattern = new com.karneim.util.collection.regex.Pattern(fieldType);
    }

    FieldPattern(String pattern) {
        this.m_pattern = pattern;
        this.parse(this.m_pattern);
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_pattern = (String)fields.get("m_pattern", null);
        this.parse(this.m_pattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + FieldPattern.hashCodeOrZeroIfNull(this.m_pattern);
        result = 37 * result + FieldPattern.hashCodeOrZeroIfNull(this.m_fieldNamePattern);
        result = 37 * result + FieldPattern.hashCodeOrZeroIfNull(this.m_fieldTypePattern);
        result = 37 * result + FieldPattern.hashCodeOrZeroIfNull(m_abbreviations);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodPattern)) {
            return false;
        }
        FieldPattern obj = (FieldPattern)o;
        if (!FieldPattern.areEqualsOrBothNull(obj.m_pattern, this.m_pattern)) return false;
        if (!FieldPattern.areEqualsOrBothNull(obj.m_fieldNamePattern, this.m_fieldNamePattern)) return false;
        if (!FieldPattern.areEqualsOrBothNull(obj.m_fieldTypePattern, this.m_fieldTypePattern)) return false;
        if (!FieldPattern.areEqualsOrBothNull(m_abbreviations, m_abbreviations)) return false;
        return true;
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

