/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.regexp;

import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.regexp.Pattern;
import org.codehaus.aspectwerkz.util.Strings;

public class MethodPattern
extends Pattern {
    protected transient com.karneim.util.collection.regex.Pattern m_methodNamePattern;
    protected transient List m_parameterTypePatterns;
    protected transient com.karneim.util.collection.regex.Pattern m_returnTypePattern;
    protected String m_pattern;

    public boolean matches(MethodMetaData method) {
        if (!this.matchMethodName(method.getName())) {
            return false;
        }
        if (!this.matchReturnType(method.getReturnType())) {
            return false;
        }
        return this.matchParameterTypes(method.getParameterTypes());
    }

    public boolean matchMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("method name can not be null");
        }
        if (methodName.equals("")) {
            return false;
        }
        return this.m_methodNamePattern.contains(methodName);
    }

    public boolean matchReturnType(String returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("return type class name can not be null");
        }
        if (returnType.equals("")) {
            return false;
        }
        return this.m_returnTypePattern.contains(returnType);
    }

    public boolean matchParameterTypes(String[] parameterTypes) {
        if (parameterTypes.length == 0 && this.m_parameterTypePatterns.size() == 0) {
            return true;
        }
        if (parameterTypes.length == 0 && this.m_parameterTypePatterns.size() != 0 && ((com.karneim.util.collection.regex.Pattern)this.m_parameterTypePatterns.get(0)).getRegEx().equals("MULTIPLE_WILDCARD_KEY")) {
            return true;
        }
        if (parameterTypes.length == 0) {
            return false;
        }
        if (this.m_parameterTypePatterns.size() > parameterTypes.length) {
            return false;
        }
        Iterator it = this.m_parameterTypePatterns.iterator();
        int i = 0;
        while (it.hasNext()) {
            String fullClassName = parameterTypes[i];
            com.karneim.util.collection.regex.Pattern pattern = (com.karneim.util.collection.regex.Pattern)it.next();
            if (pattern.getRegEx().equals("MULTIPLE_WILDCARD_KEY")) {
                return true;
            }
            if (parameterTypes.length <= i) {
                return false;
            }
            if (fullClassName == null) {
                throw new IllegalArgumentException("parameter class name can not be null");
            }
            if (fullClassName.equals("")) {
                return false;
            }
            if (!pattern.contains(fullClassName)) {
                return false;
            }
            ++i;
        }
        return parameterTypes.length == this.m_parameterTypePatterns.size();
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void parse(String pattern) {
        try {
            this.parseReturnTypePattern(pattern);
            this.parseMethodNamePattern(pattern);
            this.parserParameterTypesPattern(pattern);
        }
        catch (Throwable e) {
            throw new DefinitionException("method pattern is not well formed: " + pattern, e);
        }
    }

    protected void parseMethodNamePattern(String pattern) {
        int endIndexMethodName;
        int startIndexMethodName = pattern.indexOf(32) + 1;
        String methodNamePattern = pattern.substring(startIndexMethodName, endIndexMethodName = pattern.indexOf(40));
        methodNamePattern = methodNamePattern.equals("*") ? "[a-zA-Z0-9_$.]+" : Strings.replaceSubString(methodNamePattern, "*", "[a-zA-Z0-9_$]*");
        this.m_methodNamePattern = new com.karneim.util.collection.regex.Pattern(methodNamePattern);
    }

    protected void parseReturnTypePattern(String pattern) {
        int endIndexReturnType = pattern.indexOf(32);
        String returnTypePattern = pattern.substring(0, endIndexReturnType);
        int arraySize = 0;
        while (returnTypePattern.endsWith("[]")) {
            returnTypePattern = returnTypePattern.substring(0, returnTypePattern.length() - 2);
            ++arraySize;
        }
        if (m_abbreviations.containsKey(returnTypePattern)) {
            returnTypePattern = (String)m_abbreviations.get(returnTypePattern);
        }
        for (int i = arraySize; i > 0; --i) {
            returnTypePattern = returnTypePattern + "[]";
        }
        returnTypePattern = returnTypePattern.equals("*") ? "[a-zA-Z0-9_$.\\[\\]]+" : MethodPattern.escapeString(returnTypePattern);
        this.m_returnTypePattern = new com.karneim.util.collection.regex.Pattern(returnTypePattern);
    }

    protected void parserParameterTypesPattern(String pattern) {
        int startIndexParameterTypes = pattern.indexOf(40) + 1;
        int endIndexParameterTypes = pattern.indexOf(41);
        String parameterTypesPattern = pattern.substring(startIndexParameterTypes, endIndexParameterTypes);
        this.m_parameterTypePatterns = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(parameterTypesPattern, ",");
        if (tokenizer.hasMoreTokens()) {
            String firstParameter = tokenizer.nextToken().trim();
            int arraySize = 0;
            while (firstParameter.endsWith("[]")) {
                firstParameter = firstParameter.substring(0, firstParameter.length() - 2);
                ++arraySize;
            }
            if (m_abbreviations.containsKey(firstParameter)) {
                firstParameter = (String)m_abbreviations.get(firstParameter);
            }
            for (int i = arraySize; i > 0; --i) {
                firstParameter = firstParameter + "[]";
            }
            firstParameter = firstParameter.equals("*") ? "[a-zA-Z0-9_$.]+" : (firstParameter.equals("..") ? "MULTIPLE_WILDCARD_KEY" : MethodPattern.escapeString(firstParameter));
            this.m_parameterTypePatterns.add(new com.karneim.util.collection.regex.Pattern(firstParameter));
        }
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken().trim();
            if (m_abbreviations.containsKey(parameter)) {
                parameter = (String)m_abbreviations.get(parameter);
            }
            parameter = parameter.equals("*") ? "[a-zA-Z0-9_$.]+" : (parameter.equals("..") ? "MULTIPLE_WILDCARD_KEY" : MethodPattern.escapeString(parameter));
            this.m_parameterTypePatterns.add(new com.karneim.util.collection.regex.Pattern(parameter));
        }
    }

    protected static String escapeString(String oldString) {
        String escapedString = Strings.replaceSubString(oldString, ".", "\\.");
        escapedString = Strings.replaceSubString(escapedString, "[", "\\[");
        escapedString = Strings.replaceSubString(escapedString, "]", "\\]");
        escapedString = Strings.replaceSubString(escapedString, "*", "[a-zA-Z0-9_$]*");
        return escapedString;
    }

    MethodPattern(String pattern) {
        this.m_pattern = pattern;
        this.parse(this.m_pattern);
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_pattern = (String)fields.get("m_pattern", null);
        this.parse(this.m_pattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + MethodPattern.hashCodeOrZeroIfNull(this.m_pattern);
        result = 37 * result + MethodPattern.hashCodeOrZeroIfNull(this.m_methodNamePattern);
        result = 37 * result + MethodPattern.hashCodeOrZeroIfNull(this.m_parameterTypePatterns);
        result = 37 * result + MethodPattern.hashCodeOrZeroIfNull(this.m_returnTypePattern);
        result = 37 * result + MethodPattern.hashCodeOrZeroIfNull(m_abbreviations);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodPattern)) {
            return false;
        }
        MethodPattern obj = (MethodPattern)o;
        if (!MethodPattern.areEqualsOrBothNull(obj.m_pattern, this.m_pattern)) return false;
        if (!MethodPattern.areEqualsOrBothNull(obj.m_methodNamePattern, this.m_methodNamePattern)) return false;
        if (!MethodPattern.areEqualsOrBothNull(obj.m_parameterTypePatterns, this.m_parameterTypePatterns)) return false;
        if (!MethodPattern.areEqualsOrBothNull(obj.m_returnTypePattern, this.m_returnTypePattern)) return false;
        if (!MethodPattern.areEqualsOrBothNull(m_abbreviations, m_abbreviations)) return false;
        return true;
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

