/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.regexp;

import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.regexp.ClassPattern;
import org.codehaus.aspectwerkz.regexp.MethodPattern;
import org.codehaus.aspectwerkz.regexp.Pattern;

public class ThrowsPattern
extends Pattern {
    protected String m_pattern;
    protected MethodPattern m_methodPattern;
    protected ClassPattern m_exceptionPattern;

    public boolean matches(MethodMetaData method, String exceptionClassName) {
        return this.m_methodPattern.matches(method) && this.m_exceptionPattern.matches(exceptionClassName);
    }

    public boolean matches(MethodMetaData method) {
        return this.m_methodPattern.matches(method);
    }

    protected void parse(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(this.m_pattern, "#");
        try {
            this.m_methodPattern = Pattern.compileMethodPattern(tokenizer.nextToken());
            this.m_exceptionPattern = Pattern.compileClassPattern(tokenizer.nextToken());
        }
        catch (Exception e) {
            throw new DefinitionException("method pattern is not well formed: " + pattern, e);
        }
    }

    ThrowsPattern(String pattern) {
        this.m_pattern = pattern;
        this.parse(this.m_pattern);
    }
}

