/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class OfflineTransformationTask
extends Task {
    private String m_aspectWerkzHome;
    private String m_classesToTransform;
    private String m_definitionFile;
    private String m_classPath;

    public void setAspectWerkzHome(String aspectWerkzHome) {
        this.m_aspectWerkzHome = aspectWerkzHome;
    }

    public void setClassesToTransform(String classesToTransform) {
        this.m_classesToTransform = classesToTransform;
    }

    public void setDefinitionFile(String definitionFile) {
        this.m_definitionFile = definitionFile;
    }

    public void setClassPath(String classPath) {
        this.m_classPath = classPath;
    }

    public void execute() throws BuildException {
        if (this.m_aspectWerkzHome == null) {
            throw new BuildException("AspectWerkz home dir must be specified");
        }
        if (this.m_classesToTransform == null) {
            throw new BuildException("classes to transform must be specified");
        }
        if (this.m_definitionFile == null) {
            throw new BuildException("definition file must be specified");
        }
        System.out.println("CAUTION: This Ant task might be a bit shaky, does not show errors in compilation process properly (use at own risk or patch it :-))");
        System.out.println("NOTE: Make shure that you don't transform your classes more than once (without recompiling first)");
        StringBuffer command = new StringBuffer();
        command.append(this.m_aspectWerkzHome);
        command.append(File.separator);
        command.append("bin");
        command.append(File.separator);
        command.append("aspectwerkz");
        if (System.getProperty("os.name").startsWith("Win") || System.getProperty("os.name").startsWith("win")) {
            command.append(".bat");
        }
        command.append(" -offline ");
        command.append(this.m_definitionFile);
        command.append(' ');
        if (this.m_classPath != null) {
            command.append(this.m_classPath);
        }
        command.append(' ');
        command.append(this.m_classesToTransform);
        try {
            String out;
            Process p = Runtime.getRuntime().exec(command.toString(), new String[]{"ASPECTWERKZ_HOME=" + this.m_aspectWerkzHome, "JAVA_HOME=" + System.getProperty("java.home"), "CLASSPATH=" + System.getProperty("java.class.path")});
            System.out.flush();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String err = null;
            while ((out = stdOut.readLine()) != null || (err = stdErr.readLine()) != null) {
                if (out != null) {
                    System.out.println(out);
                    System.out.flush();
                }
                if (err == null) continue;
                System.err.println("Error: " + err);
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new BuildException("Failed to transform classes, exit code: " + p.exitValue());
            }
        }
        catch (Throwable e) {
            throw new BuildException("could not transform the classes due to: " + e);
        }
    }
}

