/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.attribdef.transform.IntroductionTransformer;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AddImplementationTransformer
implements AspectWerkzInterfaceTransformerComponent {
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformInterface(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(cg, classMetaData, definition)) {
                return;
            }
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            if (definition.isAttribDef()) {
                IntroductionTransformer.addMethodIntroductions(definition, context, classMetaData, cg, cpg, factory, this);
                continue;
            }
            if (!definition.isXmlDef()) continue;
            org.codehaus.aspectwerkz.xmldef.transform.IntroductionTransformer.addMethodIntroductions(definition, context, cg, cpg, factory, this);
        }
    }

    public void createProxyMethod(ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory, MethodMetaData methodMetaData, int mixinIndex, int methodIndex, String uuid) {
        InstructionList il = new InstructionList();
        String methodName = methodMetaData.getName();
        String[] parameters = methodMetaData.getParameterTypes();
        String returnType = methodMetaData.getReturnType();
        String[] exceptionTypes = methodMetaData.getExceptionTypes();
        int modifiers = methodMetaData.getModifiers();
        String[] parameterNames = new String[parameters.length];
        Type[] bcelParameterTypes = new Type[parameters.length];
        Type bcelReturnType = TransformationUtil.getBcelType(returnType);
        if (bcelReturnType == Type.NULL) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            bcelParameterTypes[i] = TransformationUtil.getBcelType(parameters[i]);
            parameterNames[i] = "arg" + i;
        }
        MethodGen methodGen = new MethodGen(modifiers, bcelReturnType, bcelParameterTypes, parameterNames, methodName, cg.getClassName(), il, cpg);
        if (AddImplementationTransformer.isMethodStatic(methodMetaData)) {
            return;
        }
        for (int i = 0; i < exceptionTypes.length; ++i) {
            methodGen.addException(exceptionTypes[i]);
        }
        int idxParam = 1;
        int idxStack = 0;
        if (parameters.length != 0) {
            il.append((CompoundInstruction)new PUSH(cpg, parameters.length));
            il.append(factory.createNewArray((Type)Type.OBJECT, (short)1));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cpg, idxStack));
            ++idxStack;
            for (int count = 0; count < parameters.length; ++count) {
                String wrapperClass = null;
                BasicType type = null;
                boolean hasLongOrDouble = false;
                if (bcelParameterTypes[count] instanceof ObjectType || bcelParameterTypes[count] instanceof ArrayType) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++idxParam;
                } else if (bcelParameterTypes[count] instanceof BasicType) {
                    hasLongOrDouble = false;
                    if (bcelParameterTypes[count].equals(Type.LONG)) {
                        wrapperClass = "java.lang.Long";
                        type = Type.LONG;
                        hasLongOrDouble = true;
                    } else if (bcelParameterTypes[count].equals(Type.INT)) {
                        wrapperClass = "java.lang.Integer";
                        type = Type.INT;
                    } else if (bcelParameterTypes[count].equals(Type.SHORT)) {
                        wrapperClass = "java.lang.Short";
                        type = Type.SHORT;
                    } else if (bcelParameterTypes[count].equals(Type.DOUBLE)) {
                        wrapperClass = "java.lang.Double";
                        type = Type.DOUBLE;
                        hasLongOrDouble = true;
                    } else if (bcelParameterTypes[count].equals(Type.FLOAT)) {
                        wrapperClass = "java.lang.Float";
                        type = Type.FLOAT;
                    } else if (bcelParameterTypes[count].equals(Type.CHAR)) {
                        wrapperClass = "java.lang.Character";
                        type = Type.CHAR;
                    } else if (bcelParameterTypes[count].equals(Type.BYTE)) {
                        wrapperClass = "java.lang.Byte";
                        type = Type.BYTE;
                    } else if (bcelParameterTypes[count].equals(Type.BOOLEAN)) {
                        wrapperClass = "java.lang.Boolean";
                        type = Type.BOOLEAN;
                    } else {
                        throw new RuntimeException("unknown parameter type: " + parameters[count]);
                    }
                    il.append((Instruction)factory.createNew(wrapperClass));
                    il.append((Instruction)InstructionConstants.DUP);
                    il.append((Instruction)InstructionFactory.createLoad((Type)type, (int)idxParam));
                    il.append((Instruction)factory.createInvoke(wrapperClass, "<init>", (Type)Type.VOID, new Type[]{type}, (short)183));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++idxParam;
                }
                if (count == bcelParameterTypes.length - 1) continue;
                il.append((Instruction)InstructionConstants.DUP);
                il.append((CompoundInstruction)new PUSH(cpg, idxStack));
                ++idxStack;
                if (!hasLongOrDouble) continue;
                ++idxParam;
            }
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)idxParam));
            il.append((CompoundInstruction)new PUSH(cpg, uuid));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.SystemLoader", "getSystem", (Type)new ObjectType("org.codehaus.aspectwerkz.System"), new Type[]{Type.STRING}, (short)184));
            il.append((CompoundInstruction)new PUSH(cpg, mixinIndex));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.System", "getMixin", (Type)new ObjectType("org.codehaus.aspectwerkz.Mixin"), new Type[]{Type.INT}, (short)185));
            il.append((CompoundInstruction)new PUSH(cpg, methodIndex));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.Mixin", "___AW_invokeMixin", (Type)Type.OBJECT, new Type[]{Type.INT, new ArrayType((Type)Type.OBJECT, 1), Type.OBJECT}, (short)185));
        } else {
            il.append((CompoundInstruction)new PUSH(cpg, uuid));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.SystemLoader", "getSystem", (Type)new ObjectType("org.codehaus.aspectwerkz.System"), new Type[]{Type.STRING}, (short)184));
            il.append((CompoundInstruction)new PUSH(cpg, mixinIndex));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.System", "getMixin", (Type)new ObjectType("org.codehaus.aspectwerkz.Mixin"), new Type[]{Type.INT}, (short)185));
            il.append((CompoundInstruction)new PUSH(cpg, methodIndex));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.Mixin", "___AW_invokeMixin", (Type)Type.OBJECT, new Type[]{Type.INT, Type.OBJECT}, (short)185));
        }
        if (!bcelReturnType.equals(Type.VOID)) {
            if (bcelReturnType instanceof BasicType) {
                if (bcelReturnType.equals(Type.LONG)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Long")));
                    il.append((Instruction)factory.createInvoke("java.lang.Long", "longValue", (Type)Type.LONG, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.INT)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Integer")));
                    il.append((Instruction)factory.createInvoke("java.lang.Integer", "intValue", (Type)Type.INT, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.SHORT)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Short")));
                    il.append((Instruction)factory.createInvoke("java.lang.Short", "shortValue", (Type)Type.SHORT, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.DOUBLE)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Double")));
                    il.append((Instruction)factory.createInvoke("java.lang.Double", "doubleValue", (Type)Type.DOUBLE, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.FLOAT)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Float")));
                    il.append((Instruction)factory.createInvoke("java.lang.Float", "floatValue", (Type)Type.FLOAT, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.CHAR)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Character")));
                    il.append((Instruction)factory.createInvoke("java.lang.Character", "charValue", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.BYTE)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Byte")));
                    il.append((Instruction)factory.createInvoke("java.lang.Byte", "byteValue", (Type)Type.BYTE, Type.NO_ARGS, (short)182));
                } else if (bcelReturnType.equals(Type.BOOLEAN)) {
                    il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Boolean")));
                    il.append((Instruction)factory.createInvoke("java.lang.Boolean", "booleanValue", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
                } else if (!bcelReturnType.equals(Type.VOID)) {
                    throw new Error("unknown return type: " + bcelReturnType);
                }
            } else {
                il.append(factory.createCast((Type)Type.OBJECT, bcelReturnType));
            }
        }
        il.append((Instruction)InstructionFactory.createReturn((Type)bcelReturnType));
        methodGen.setMaxStack();
        methodGen.setMaxLocals();
        TransformationUtil.addMethod(cg, methodGen.getMethod());
        il.dispose();
    }

    private static boolean isMethodStatic(MethodMetaData methodMetaData) {
        int modifiers = methodMetaData.getModifiers();
        return (modifiers & 8) != 0;
    }

    private boolean classFilter(ClassGen cg, ClassMetaData classMetaData, AspectWerkzDefinition definition) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        return !definition.inIncludePackage(className) || !definition.hasIntroductions(classMetaData);
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }
}

