/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public final class AddMetaDataTransformer
implements AspectWerkzCodeTransformerComponent,
AspectWerkzInterfaceTransformerComponent {
    private final Set m_hasBeenTransformed = new HashSet();
    private final AspectWerkzDefinition m_definition = (AspectWerkzDefinition)DefinitionLoader.getDefinitionsForTransformation().get(0);
    private static final String ADD_METADATA = System.getProperty("aspectwerkz.add.metadata", null);

    public void transformInterface(Context context, Klass klass) {
        if (ADD_METADATA == null) {
            return;
        }
        this.m_definition.loadAspects(context.getLoader());
        ClassGen cg = klass.getClassGen();
        ConstantPoolGen cpg = cg.getConstantPool();
        InstructionFactory factory = new InstructionFactory(cg);
        ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
        if (this.classFilter(classMetaData, cg)) {
            return;
        }
        if (this.m_hasBeenTransformed.contains(cg.getClassName())) {
            return;
        }
        this.m_hasBeenTransformed.add(cg.getClassName());
        context.markAsAdvised();
        this.addMetaDataEnhancableInterface(cg, cpg);
        this.addMapField(cg);
        this.addMetaDataGetterMethod(cg, cpg, factory);
        this.addMetaDataSetterMethod(cg, cpg, factory);
    }

    public void transformCode(Context context, Klass klass) {
        if (ADD_METADATA == null) {
            return;
        }
        ClassGen cg = klass.getClassGen();
        ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
        if (this.classFilter(classMetaData, cg)) {
            return;
        }
        if (cg.containsField("___AW_meta_data") == null) {
            return;
        }
        InstructionFactory factory = new InstructionFactory(cg);
        ConstantPoolGen cpg = cg.getConstantPool();
        Method[] methods = cg.getMethods();
        ArrayList<Integer> initIndexes = new ArrayList<Integer>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<init>")) continue;
            initIndexes.add(new Integer(i));
        }
        Iterator it = initIndexes.iterator();
        while (it.hasNext()) {
            int initIndex = (Integer)it.next();
            methods[initIndex] = this.createMetaDataField(cpg, cg, methods[initIndex], factory).getMethod();
        }
        cg.setMethods(methods);
        context.markAsAdvised();
    }

    private void addMetaDataEnhancableInterface(ClassGen cg, ConstantPoolGen cpg) {
        int[] interfaces = cg.getInterfaces();
        String interfaceName = "org.codehaus.aspectwerkz.MetaDataEnhanceable";
        boolean addInterface = true;
        for (int i = 0; i < interfaces.length; ++i) {
            ConstantClass cc = (ConstantClass)cpg.getConstant(interfaces[i]);
            ConstantUtf8 cu = (ConstantUtf8)cpg.getConstant(cc.getNameIndex());
            if (!this.implementsInterface(cu, "org.codehaus.aspectwerkz.MetaDataEnhanceable")) continue;
            addInterface = false;
            break;
        }
        if (addInterface) {
            TransformationUtil.addInterfaceToClass(cg, "org.codehaus.aspectwerkz.MetaDataEnhanceable");
        }
    }

    private void addMapField(ClassGen cg) {
        if (cg.containsField("___AW_meta_data") == null) {
            FieldGen field = new FieldGen(18, (Type)new ObjectType("java.util.Map"), "___AW_meta_data", cg.getConstantPool());
            TransformationUtil.addField(cg, field.getField());
        }
    }

    private void addMetaDataGetterMethod(ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.OBJECT, new Type[]{Type.OBJECT}, new String[]{"arg0"}, "___AW_getMetaData", cg.getClassName(), il, cpg);
        if (cg.containsMethod("___AW_getMetaData", method.getSignature()) != null) {
            return;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_meta_data", (Type)new ObjectType("java.util.Map"), (short)180));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)factory.createInvoke("java.util.Map", "get", (Type)Type.OBJECT, new Type[]{Type.OBJECT}, (short)185));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        method.setMaxStack();
        method.setMaxLocals();
        TransformationUtil.addMethod(cg, method.getMethod());
    }

    private void addMetaDataSetterMethod(ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.OBJECT, Type.OBJECT}, new String[]{"key", "value"}, "___AW_addMetaData", cg.getClassName(), il, cpg);
        if (cg.containsMethod("___AW_addMetaData", method.getSignature()) != null) {
            return;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_meta_data", (Type)new ObjectType("java.util.Map"), (short)180));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2));
        il.append((Instruction)factory.createInvoke("java.util.Map", "put", (Type)Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT}, (short)185));
        il.append((Instruction)InstructionConstants.POP);
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        TransformationUtil.addMethod(cg, method.getMethod());
    }

    private MethodGen createMetaDataField(ConstantPoolGen cp, ClassGen cg, Method init, InstructionFactory factory) {
        MethodGen mg = new MethodGen(init, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        for (int i = 0; i < ihs.length; ++i) {
            InstructionHandle ih = ihs[i];
            if (!(ih.getInstruction() instanceof ReturnInstruction)) continue;
            InstructionHandle ihPost = il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.insert(ih, (Instruction)factory.createNew("java.util.HashMap"));
            il.insert(ih, (Instruction)InstructionConstants.DUP);
            il.insert(ih, (Instruction)factory.createInvoke("java.util.HashMap", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_meta_data", (Type)new ObjectType("java.util.Map"), (short)181));
            il.redirectBranches(ih, ihPost);
        }
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg;
    }

    private boolean implementsInterface(ConstantUtf8 cu, String interfaceName) {
        return cu.getBytes().equals(interfaceName.replace('.', '/'));
    }

    private boolean classFilter(ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (this.m_definition.inExcludePackage(className)) {
            return true;
        }
        return !this.m_definition.inIncludePackage(className);
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }
}

