/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AddReadObjectTransformer
implements AspectWerkzInterfaceTransformerComponent {
    private final Set m_hasBeenTransformed = new HashSet();
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformInterface(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            if (this.classFilter(cg, definition)) {
                return;
            }
            if (this.m_hasBeenTransformed.contains(cg.getClassName())) {
                return;
            }
            this.m_hasBeenTransformed.add(cg.getClassName());
            context.markAsAdvised();
            this.addReadObjectMethod(cg, cpg, factory);
        }
    }

    private void addReadObjectMethod(ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(2, (Type)Type.VOID, new Type[]{new ObjectType("java.io.ObjectInputStream")}, new String[]{"stream"}, "readObject", cg.getClassName(), il, cpg);
        if (cg.containsMethod("readObject", method.getSignature()) != null) {
            return;
        }
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        TransformationUtil.addMethod(cg, method.getMethod());
    }

    private boolean classFilter(ClassGen cg, AspectWerkzDefinition definition) {
        if (cg.isInterface() || cg.getSuperclassName().equals("org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || cg.getSuperclassName().equals("org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || cg.getSuperclassName().equals("org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || cg.getSuperclassName().equals("org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        return !definition.inIncludePackage(className);
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }
}

