/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.io.IOException;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AddSerialVersionUidTransformer
implements AspectWerkzInterfaceTransformerComponent {
    public void transformInterface(Context context, Klass klass) {
        ClassGen cg = klass.getClassGen();
        ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
        if (this.classFilter(classMetaData, cg)) {
            return;
        }
        if (!TransformationUtil.isSerializable(context, cg)) {
            return;
        }
        if (TransformationUtil.hasSerialVersionUid(cg)) {
            return;
        }
        try {
            this.addSerialVersionUidField(context, cg, klass.getInitialClassGen());
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private void addSerialVersionUidField(Context context, ClassGen cg, ClassGen initialCg) {
        FieldGen field = new FieldGen(24, (Type)Type.LONG, "serialVersionUID", cg.getConstantPool());
        long uid = TransformationUtil.calculateSerialVersionUid(context, initialCg);
        field.setInitValue(uid);
        TransformationUtil.addField(cg, field.getField());
    }

    private boolean classFilter(ClassMetaData classMetaData, ClassGen cg) {
        return cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice");
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }
}

