/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public final class AddUuidTransformer
implements AspectWerkzCodeTransformerComponent,
AspectWerkzInterfaceTransformerComponent {
    private final Set m_hasBeenTransformed = new HashSet();
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();
    private static final String ADD_UUID = System.getProperty("aspectwerkz.add.uuid", null);

    public void transformInterface(Context context, Klass klass) {
        if (ADD_UUID == null) {
            return;
        }
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(classMetaData, cg, definition)) {
                return;
            }
            if (this.m_hasBeenTransformed.contains(cg.getClassName())) {
                return;
            }
            this.m_hasBeenTransformed.add(cg.getClassName());
            context.markAsAdvised();
            this.addIdentifiableInterface(cg, cpg);
            this.addUuidField(cg);
            this.addUuidGetterMethod(cg, cpg, factory);
        }
    }

    public void transformCode(Context context, Klass klass) {
        if (ADD_UUID == null) {
            return;
        }
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(classMetaData, cg, definition)) {
                return;
            }
            if (cg.containsField("___AW_uuid") == null) {
                return;
            }
            InstructionFactory factory = new InstructionFactory(cg);
            ConstantPoolGen cpg = cg.getConstantPool();
            Method[] methods = cg.getMethods();
            ArrayList<Integer> initIndexes = new ArrayList<Integer>();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("<init>")) continue;
                initIndexes.add(new Integer(i));
            }
            Iterator it2 = initIndexes.iterator();
            while (it2.hasNext()) {
                int initIndex = (Integer)it2.next();
                methods[initIndex] = this.createUuidField(cpg, cg, methods[initIndex], factory).getMethod();
            }
            cg.setMethods(methods);
            context.markAsAdvised();
        }
    }

    private void addIdentifiableInterface(ClassGen cg, ConstantPoolGen cpg) {
        int[] interfaces = cg.getInterfaces();
        String interfaceName = "org.codehaus.aspectwerkz.Identifiable";
        boolean addInterface = true;
        for (int i = 0; i < interfaces.length; ++i) {
            ConstantClass cc = (ConstantClass)cpg.getConstant(interfaces[i]);
            ConstantUtf8 cu = (ConstantUtf8)cpg.getConstant(cc.getNameIndex());
            if (!this.implementsInterface(cu, "org.codehaus.aspectwerkz.Identifiable")) continue;
            addInterface = false;
            break;
        }
        if (addInterface) {
            TransformationUtil.addInterfaceToClass(cg, "org.codehaus.aspectwerkz.Identifiable");
        }
    }

    private void addUuidField(ClassGen cg) {
        if (cg.containsField("___AW_uuid") == null) {
            FieldGen field = new FieldGen(18, (Type)Type.STRING, "___AW_uuid", cg.getConstantPool());
            TransformationUtil.addField(cg, field.getField());
        }
    }

    private void addUuidGetterMethod(ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.STRING, Type.NO_ARGS, new String[0], "___AW_getUuid", cg.getClassName(), il, cpg);
        if (cg.containsMethod("___AW_getUuid", method.getSignature()) != null) {
            return;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_uuid", (Type)Type.STRING, (short)180));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        method.setMaxStack();
        method.setMaxLocals();
        TransformationUtil.addMethod(cg, method.getMethod());
    }

    private MethodGen createUuidField(ConstantPoolGen cp, ClassGen cg, Method init, InstructionFactory factory) {
        MethodGen mg = new MethodGen(init, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        for (int i = 0; i < ihs.length; ++i) {
            InstructionHandle ih = ihs[i];
            if (!(ih.getInstruction() instanceof ReturnInstruction)) continue;
            InstructionHandle ihPost = il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.insert(ih, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.UuidGenerator", "generate", (Type)Type.STRING, new Type[]{Type.OBJECT}, (short)184));
            il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_uuid", (Type)Type.STRING, (short)181));
            il.redirectBranches(ih, ihPost);
        }
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg;
    }

    private boolean implementsInterface(ConstantUtf8 cu, String interfaceName) {
        return cu.getBytes().equals(interfaceName.replace('.', '/'));
    }

    private boolean classFilter(ClassMetaData classMetaData, ClassGen cg, AspectWerkzDefinition definition) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        return !definition.inIncludePackage(className);
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }
}

