/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AdviseCallerSideMethodTransformer
implements AspectWerkzCodeTransformerComponent {
    private final AspectWerkzDefinition m_definition = (AspectWerkzDefinition)DefinitionLoader.getDefinitionsForTransformation().get(0);

    public void transformCode(Context context, Klass klass) {
        this.m_definition.loadAspects(context.getLoader());
        ClassGen cg = klass.getClassGen();
        ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
        if (this.classFilter(classMetaData, cg)) {
            return;
        }
        Method[] methods = cg.getMethods();
        boolean hasClInitMethod = false;
        int clinitIndex = -1;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<clinit>")) continue;
            clinitIndex = i;
            hasClInitMethod = true;
            break;
        }
        ConstantPoolGen cpg = cg.getConstantPool();
        String className = cg.getClassName();
        InstructionFactory factory = new InstructionFactory(cg);
        HashSet<String> callerSideJoinPoints = new HashSet<String>();
        Method clInitMethod = null;
        HashMap<String, Integer> methodSequences = new HashMap<String, Integer>();
        ArrayList<Method> newMethods = new ArrayList<Method>();
        boolean isClassAdvised = false;
        boolean isMethodChanged = false;
        for (int i = 0; i < methods.length; ++i) {
            MethodGen mg;
            InstructionList il;
            if (this.methodFilterCaller(methods[i]) || (il = (mg = new MethodGen(methods[i], className, cpg)).getInstructionList()) == null) continue;
            InstructionHandle ih = il.getStart();
            isMethodChanged = false;
            while (ih != null) {
                Instruction ins = ih.getInstruction();
                if (ins instanceof INVOKESPECIAL || ins instanceof INVOKESTATIC || ins instanceof INVOKEVIRTUAL) {
                    ClassMetaData calleeSideClassMetaData;
                    InvokeInstruction invokeInstruction = (InvokeInstruction)ins;
                    String calleeMethodName = invokeInstruction.getName(cpg);
                    String calleeClassName = invokeInstruction.getClassName(cpg);
                    String calleeMethodSignature = invokeInstruction.getSignature(cpg);
                    if (!this.m_definition.inIncludePackage(calleeClassName)) {
                        ih = ih.getNext();
                        continue;
                    }
                    if (this.methodFilterCallee(calleeMethodName)) {
                        ih = ih.getNext();
                        continue;
                    }
                    try {
                        JavaClass javaClass = context.getRepository().loadClass(calleeClassName);
                        calleeSideClassMetaData = BcelMetaDataMaker.createClassMetaData(javaClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new WrappedRuntimeException(e);
                    }
                    MethodMetaData calleeSideMethodMetaData = BcelMetaDataMaker.createMethodMetaData(invokeInstruction, cpg);
                    if (this.m_definition.isPickedOutByCallPointcut(calleeSideClassMetaData, calleeSideMethodMetaData)) {
                        Method method = mg.getMethod();
                        String callerMethodName = method.getName();
                        String callerMethodSignature = method.getSignature();
                        ObjectType joinPointType = TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE;
                        if (methodSequences.containsKey(calleeMethodName)) {
                            int sequence = (Integer)methodSequences.get(calleeMethodName);
                            methodSequences.remove(calleeMethodName);
                            methodSequences.put(calleeMethodName, new Integer(++sequence));
                        } else {
                            methodSequences.put(calleeMethodName, new Integer(1));
                        }
                        int methodSequence = (Integer)methodSequences.get(calleeMethodName);
                        isClassAdvised = true;
                        isMethodChanged = true;
                        this.insertPreAdvice(il, ih, cg, calleeMethodName, methodSequence, factory, (Type)joinPointType);
                        this.insertPostAdvice(il, ih.getNext(), cg, calleeMethodName, methodSequence, factory, (Type)joinPointType);
                        StringBuffer key = new StringBuffer();
                        key.append(className);
                        key.append("$_AW_$");
                        key.append(calleeMethodName);
                        key.append("$_AW_$");
                        key.append(methodSequence);
                        if (!callerSideJoinPoints.contains(key.toString())) {
                            callerSideJoinPoints.add(key.toString());
                            this.addStaticJoinPointField(cpg, cg, calleeMethodName, methodSequence, (Type)joinPointType);
                            if (hasClInitMethod) {
                                methods[clinitIndex] = this.createStaticJoinPointField(cpg, cg, methods[clinitIndex], callerMethodName, calleeClassName, calleeMethodName, methodSequence, callerMethodSignature, calleeMethodSignature, factory, (Type)joinPointType, this.m_definition.getUuid());
                            } else {
                                clInitMethod = clInitMethod == null ? this.createClInitMethodWithStaticJoinPointField(cpg, cg, callerMethodName, calleeClassName, calleeMethodName, methodSequence, callerMethodSignature, calleeMethodSignature, factory, (Type)joinPointType, this.m_definition.getUuid()) : this.createStaticJoinPointField(cpg, cg, clInitMethod, callerMethodName, calleeClassName, calleeMethodName, methodSequence, callerMethodSignature, calleeMethodSignature, factory, (Type)joinPointType, this.m_definition.getUuid());
                            }
                        }
                    }
                }
                ih = ih.getNext();
            }
            if (!isMethodChanged) continue;
            mg.setMaxStack();
            methods[i] = mg.getMethod();
        }
        if (isClassAdvised) {
            context.markAsAdvised();
            if (!hasClInitMethod && clInitMethod != null) {
                this.addStaticClassField(cpg, cg);
                clInitMethod = AdviseCallerSideMethodTransformer.createStaticClassField(cpg, cg, clInitMethod, factory);
                newMethods.add(clInitMethod);
            } else {
                this.addStaticClassField(cpg, cg);
                methods[clinitIndex] = AdviseCallerSideMethodTransformer.createStaticClassField(cpg, cg, methods[clinitIndex], factory);
            }
            cg.setMethods(methods);
            Iterator it = newMethods.iterator();
            while (it.hasNext()) {
                Method method = (Method)it.next();
                cg.addMethod(method);
            }
        }
    }

    private void addStaticClassField(ConstantPoolGen cp, ClassGen cg) {
        Field[] fields = cg.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("___AW_clazz")) continue;
            return;
        }
        FieldGen field = new FieldGen(26, (Type)new ObjectType("java.lang.Class"), "___AW_clazz", cp);
        cg.addField(field.getField());
    }

    private void addStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, String methodName, int methodSequence, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseCallerSideMethodTransformer.getJoinPointName(joinPointPrefix, methodName, methodSequence);
        if (cg.containsField(joinPoint.toString()) != null) {
            return;
        }
        FieldGen field = new FieldGen(26, (Type)TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE, joinPoint.toString(), cp);
        cg.addField(field.getField());
    }

    private static Method createStaticClassField(ConstantPoolGen cp, ClassGen cg, Method clInit, InstructionFactory factory) {
        String className = cg.getClassName();
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (CompoundInstruction)new PUSH(cp, cg.getClassName()));
        il.insert(ih, (Instruction)factory.createInvoke("java.lang.Class", "forName", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        il.insert(ih, (Instruction)factory.createFieldAccess(className, "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method createClInitMethodWithStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, String callerMethodName, String calleeClassName, String calleeMethodName, int methodSequence, String callerMethodSignature, String calleeMethodSignature, InstructionFactory factory, Type joinPointType, String uuid) {
        String className = cg.getClassName();
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseCallerSideMethodTransformer.getJoinPointName(joinPointPrefix, calleeMethodName, methodSequence);
        StringBuffer fullCalleeMethodName = new StringBuffer();
        fullCalleeMethodName.append(calleeClassName);
        fullCalleeMethodName.append("#");
        fullCalleeMethodName.append(calleeMethodName);
        InstructionList il = new InstructionList();
        MethodGen clInit = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", className, il, cp);
        il.append((Instruction)factory.createNew("org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cp, uuid));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)178));
        il.append((CompoundInstruction)new PUSH(cp, callerMethodName));
        il.append((CompoundInstruction)new PUSH(cp, callerMethodSignature));
        il.append((CompoundInstruction)new PUSH(cp, fullCalleeMethodName.toString()));
        il.append((CompoundInstruction)new PUSH(cp, calleeMethodSignature));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint", "<init>", (Type)Type.VOID, new Type[]{Type.STRING, new ObjectType("java.lang.Class"), Type.STRING, Type.STRING, Type.STRING, Type.STRING}, (short)183));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE, (short)179));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        clInit.setMaxLocals();
        clInit.setMaxStack();
        return clInit.getMethod();
    }

    private Method createStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, Method clInit, String callerMethodName, String calleeClassName, String calleeMethodName, int methodSequence, String callerMethodSignature, String calleeMethodSignature, InstructionFactory factory, Type joinPointType, String uuid) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseCallerSideMethodTransformer.getJoinPointName(joinPointPrefix, calleeMethodName, methodSequence);
        StringBuffer fullCalleeMethodName = new StringBuffer();
        fullCalleeMethodName.append(calleeClassName);
        fullCalleeMethodName.append("#");
        fullCalleeMethodName.append(calleeMethodName);
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (Instruction)factory.createNew("org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint"));
        il.insert(ih, (Instruction)InstructionConstants.DUP);
        il.insert(ih, (CompoundInstruction)new PUSH(cp, uuid));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)178));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, callerMethodName));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, callerMethodSignature));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, fullCalleeMethodName.toString()));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, calleeMethodSignature));
        il.insert(ih, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint", "<init>", (Type)Type.VOID, new Type[]{Type.STRING, new ObjectType("java.lang.Class"), Type.STRING, Type.STRING, Type.STRING, Type.STRING}, (short)183));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE, (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private void insertPreAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, int methodSequence, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseCallerSideMethodTransformer.getJoinPointName(joinPointPrefix, fieldName, methodSequence);
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)178));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "pre", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    private void insertPostAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, int methodSequence, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseCallerSideMethodTransformer.getJoinPointName(joinPointPrefix, fieldName, methodSequence);
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)178));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "post", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }

    private boolean classFilter(ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (this.m_definition.inExcludePackage(className)) {
            return true;
        }
        if (!this.m_definition.inIncludePackage(className)) {
            return true;
        }
        return !this.m_definition.hasCallPointcut(classMetaData);
    }

    private boolean methodFilterCaller(Method method) {
        return method.isNative() || method.isInterface() || method.getName().equals("___AW_getMetaData") || method.getName().equals("___AW_addMetaData") || method.getName().equals("class$") || method.getName().equals("___AW_getUuid");
    }

    private boolean methodFilterCallee(String methodName) {
        return methodName.equals("<init>") || methodName.equals("<clinit>") || methodName.startsWith("___AW_original_method$_AW_$") || methodName.equals("___AW_getMetaData") || methodName.equals("___AW_addMetaData") || methodName.equals("class$") || methodName.equals("___AW_getUuid");
    }

    private String getJoinPointPrefix(Type joinPointType) {
        if (!joinPointType.equals(TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE)) {
            throw new RuntimeException("call side join point type unknown: " + joinPointType);
        }
        String joinPointPrefix = "___AW_jp$_AW_$caller_side_method$_AW_$";
        return joinPointPrefix;
    }

    private String getJoinPointClass(Type joinPointType) {
        if (!joinPointType.equals(TransformationUtil.CALLER_SIDE_JOIN_POINT_TYPE)) {
            throw new RuntimeException("call side join point type unknown: " + joinPointType);
        }
        String joinPointClass = "org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint";
        return joinPointClass;
    }

    private static StringBuffer getJoinPointName(String joinPointPrefix, String methodName, int methodSequence) {
        StringBuffer joinPoint = new StringBuffer();
        joinPoint.append(joinPointPrefix);
        joinPoint.append(methodName);
        joinPoint.append("$_AW_$");
        joinPoint.append(methodSequence);
        return joinPoint;
    }
}

