/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AdviseMemberFieldTransformer
implements AspectWerkzCodeTransformerComponent {
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformCode(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            Iterator it3;
            JoinPointFieldData data;
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(definition, classMetaData, cg)) {
                return;
            }
            Method[] methods = cg.getMethods();
            ArrayList<Integer> initIndexes = new ArrayList<Integer>();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("<init>")) continue;
                initIndexes.add(new Integer(i));
            }
            ConstantPoolGen cpg = cg.getConstantPool();
            String className = cg.getClassName();
            InstructionFactory factory = new InstructionFactory(cg);
            HashSet<JoinPointFieldData> setFieldJoinPoints = new HashSet<JoinPointFieldData>();
            HashSet<JoinPointFieldData> getFieldJoinPoints = new HashSet<JoinPointFieldData>();
            boolean isClassAdvised = false;
            boolean isMethodAdvised = false;
            for (int i = 0; i < methods.length; ++i) {
                if (this.methodFilter(methods[i])) continue;
                isMethodAdvised = false;
                MethodGen mg = new MethodGen(methods[i], className, cpg);
                if (mg.getMethod().getName().startsWith("___AW_")) continue;
                InstructionList il = mg.getInstructionList();
                FieldInstruction currentGetFieldIns = null;
                for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
                    JoinPointFieldData data2;
                    String fieldClassName;
                    String uuid;
                    FieldMetaData fieldMetaData;
                    ObjectType joinPointType;
                    String signature;
                    String fieldName;
                    FieldInstruction checkMe;
                    Instruction ins = ih.getInstruction();
                    if (ins instanceof GETFIELD && !(checkMe = (FieldInstruction)ins).getFieldName(cpg).startsWith("___AW_jp")) {
                        String methodName;
                        InvokeInstruction invokeIns;
                        currentGetFieldIns = checkMe;
                        Instruction next = ih.getNext().getInstruction();
                        if (next instanceof INVOKEINTERFACE && ((invokeIns = (InvokeInstruction)next).getClassName(cpg).equals("java.util.Collection") || invokeIns.getClassName(cpg).equals("java.util.Enumeration") || invokeIns.getClassName(cpg).equals("java.util.Iterator") || invokeIns.getClassName(cpg).equals("java.util.List") || invokeIns.getClassName(cpg).equals("java.util.Map") || invokeIns.getClassName(cpg).equals("java.util.Set") || invokeIns.getClassName(cpg).equals("java.util.SortedMap") || invokeIns.getClassName(cpg).equals("java.util.SortedSet")) && ((methodName = invokeIns.getName(cpg)).equals("add") || methodName.equals("addAll") || methodName.equals("set") || methodName.equals("remove") || methodName.equals("removeAll") || methodName.equals("retainAll") || methodName.equals("clear") || methodName.equals("put") || methodName.equals("putAll"))) {
                            String fieldClassName2;
                            String fieldName2 = currentGetFieldIns.getName(cpg);
                            String signature2 = currentGetFieldIns.getFieldType(cpg).toString() + " " + fieldName2;
                            ObjectType joinPointType2 = TransformationUtil.MEMBER_FIELD_SET_JOIN_POINT_TYPE;
                            FieldMetaData fieldMetaData2 = BcelMetaDataMaker.createFieldMetaData(currentGetFieldIns, cpg);
                            String uuid2 = this.setFieldFilter(definition, classMetaData, fieldMetaData2);
                            if (uuid2 != null && (fieldClassName2 = currentGetFieldIns.getClassName(cpg)).equals(cg.getClassName())) {
                                isMethodAdvised = true;
                                this.insertPreAdvice(il, ih, cg, fieldName2, factory, (Type)joinPointType2);
                                this.insertPostAdvice(il, ih.getNext().getNext(), cg, fieldName2, factory, (Type)joinPointType2);
                                JoinPointFieldData data3 = new JoinPointFieldData(fieldName2, signature2, (Type)joinPointType2, uuid2);
                                if (!setFieldJoinPoints.contains(data3)) {
                                    setFieldJoinPoints.add(data3);
                                }
                                ih = ih.getNext();
                                ins = ih.getInstruction();
                            }
                        }
                    }
                    if (ins instanceof GETFIELD) {
                        FieldInstruction gfIns = (FieldInstruction)ins;
                        fieldName = gfIns.getName(cpg);
                        signature = gfIns.getFieldType(cpg).toString() + " " + fieldName;
                        joinPointType = TransformationUtil.MEMBER_FIELD_GET_JOIN_POINT_TYPE;
                        fieldMetaData = BcelMetaDataMaker.createFieldMetaData(gfIns, cpg);
                        uuid = this.getFieldFilter(definition, classMetaData, fieldMetaData);
                        if (uuid == null || !(fieldClassName = gfIns.getClassName(cpg)).equals(cg.getClassName())) continue;
                        isMethodAdvised = true;
                        this.insertPreAdvice(il, ih, cg, fieldName, factory, (Type)joinPointType);
                        this.insertPostAdvice(il, ih.getNext(), cg, fieldName, factory, (Type)joinPointType);
                        data2 = new JoinPointFieldData(fieldName, signature, (Type)joinPointType, uuid);
                        if (getFieldJoinPoints.contains(data2)) continue;
                        getFieldJoinPoints.add(data2);
                        continue;
                    }
                    if (!(ins instanceof PUTFIELD)) continue;
                    FieldInstruction pfIns = (FieldInstruction)ins;
                    fieldName = pfIns.getName(cpg);
                    signature = pfIns.getFieldType(cpg).toString() + " " + fieldName;
                    joinPointType = TransformationUtil.MEMBER_FIELD_SET_JOIN_POINT_TYPE;
                    fieldMetaData = BcelMetaDataMaker.createFieldMetaData(pfIns, cpg);
                    uuid = this.setFieldFilter(definition, classMetaData, fieldMetaData);
                    if (uuid == null || !(fieldClassName = pfIns.getClassName(cpg)).equals(cg.getClassName())) continue;
                    isMethodAdvised = true;
                    this.insertPreAdvice(il, ih, cg, fieldName, factory, (Type)joinPointType);
                    this.insertPostAdvice(il, ih.getNext(), cg, fieldName, factory, (Type)joinPointType);
                    data2 = new JoinPointFieldData(fieldName, signature, (Type)joinPointType, uuid);
                    if (setFieldJoinPoints.contains(data2)) continue;
                    setFieldJoinPoints.add(data2);
                }
                if (!isMethodAdvised) continue;
                mg.setMaxStack();
                methods[i] = mg.getMethod();
                isClassAdvised = true;
            }
            Iterator it2 = setFieldJoinPoints.iterator();
            while (it2.hasNext()) {
                data = (JoinPointFieldData)it2.next();
                this.addJoinPointMemberField(cpg, cg, data.getName(), data.getType());
                it3 = initIndexes.iterator();
                while (it3.hasNext()) {
                    int initIndex = (Integer)it3.next();
                    methods[initIndex] = this.createJoinPointMemberField(cpg, cg, methods[initIndex], factory, data.getName(), data.getSignature(), data.getType(), data.getUuid());
                }
            }
            it2 = getFieldJoinPoints.iterator();
            while (it2.hasNext()) {
                data = (JoinPointFieldData)it2.next();
                this.addJoinPointMemberField(cpg, cg, data.getName(), data.getType());
                it3 = initIndexes.iterator();
                while (it3.hasNext()) {
                    int initIndex = (Integer)it3.next();
                    methods[initIndex] = this.createJoinPointMemberField(cpg, cg, methods[initIndex], factory, data.getName(), data.getSignature(), data.getType(), data.getUuid());
                }
            }
            if (!isClassAdvised) continue;
            context.markAsAdvised();
            cg.setMethods(methods);
        }
    }

    private void addJoinPointMemberField(ConstantPoolGen cp, ClassGen cg, String fieldName, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseMemberFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        if (cg.containsField(joinPoint.toString()) != null) {
            return;
        }
        FieldGen field = new FieldGen(18, joinPointType, joinPoint.toString(), cp);
        cg.addField(field.getField());
    }

    private Method createJoinPointMemberField(ConstantPoolGen cp, ClassGen cg, Method init, InstructionFactory factory, String fieldName, String signature, Type joinPointType, String uuid) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        MethodGen mg = new MethodGen(init, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        InstructionHandle ih = ihs[0];
        for (int i = 0; i < ihs.length; ++i) {
            InvokeInstruction invokeInstruction;
            String methodName;
            Instruction instruction = ihs[i].getInstruction();
            if (!(instruction instanceof InvokeInstruction) || !(methodName = (invokeInstruction = (InvokeInstruction)instruction).getMethodName(cp)).equals("<init>")) continue;
            ih = ihs[++i];
            break;
        }
        StringBuffer joinPoint = AdviseMemberFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        InstructionHandle ihPost = il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.insert(ih, (Instruction)factory.createNew(joinPointClass));
        il.insert(ih, (Instruction)InstructionConstants.DUP);
        il.insert(ih, (CompoundInstruction)new PUSH(cp, uuid));
        il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, signature));
        il.insert(ih, (Instruction)factory.createInvoke(joinPointClass, "<init>", (Type)Type.VOID, new Type[]{Type.STRING, Type.OBJECT, Type.STRING}, (short)183));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)181));
        il.redirectBranches(ih, ihPost);
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private void insertPreAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseMemberFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        il.insert(before, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)180));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "pre", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    private void insertPostAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseMemberFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        il.insert(before, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)180));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "post", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }

    private boolean classFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        return !definition.hasSetPointcut(classMetaData) && !definition.hasGetPointcut(classMetaData);
    }

    private boolean methodFilter(Method method) {
        return method.isNative() || method.isAbstract();
    }

    private String setFieldFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (fieldMetaData.getName().startsWith("___AW_")) {
            return null;
        }
        if (definition.hasSetPointcut(classMetaData, fieldMetaData)) {
            return definition.getUuid();
        }
        return null;
    }

    private String getFieldFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (fieldMetaData.getName().startsWith("___AW_")) {
            return null;
        }
        if (definition.hasGetPointcut(classMetaData, fieldMetaData)) {
            return definition.getUuid();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getJoinPointPrefix(Type joinPointType) {
        void var2_2;
        String joinPointPrefix;
        if (joinPointType.equals(TransformationUtil.MEMBER_FIELD_GET_JOIN_POINT_TYPE)) {
            joinPointPrefix = "___AW_jp$_AW_$member_field$_AW_$get$_AW_$";
        } else if (joinPointType.equals(TransformationUtil.MEMBER_FIELD_SET_JOIN_POINT_TYPE)) {
            joinPointPrefix = "___AW_jp$_AW_$member_field$_AW_$set$_AW_$";
        } else {
            throw new RuntimeException("field join point type unknown: " + joinPointType);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getJoinPointClass(Type joinPointType) {
        void var2_2;
        String joinPointClass;
        if (joinPointType.equals(TransformationUtil.MEMBER_FIELD_GET_JOIN_POINT_TYPE)) {
            joinPointClass = "org.codehaus.aspectwerkz.joinpoint.MemberFieldGetJoinPoint";
        } else if (joinPointType.equals(TransformationUtil.MEMBER_FIELD_SET_JOIN_POINT_TYPE)) {
            joinPointClass = "org.codehaus.aspectwerkz.joinpoint.MemberFieldSetJoinPoint";
        } else {
            throw new RuntimeException("field join point type unknown: " + joinPointType);
        }
        return var2_2;
    }

    private static StringBuffer getJoinPointName(String joinPointPrefix, String fieldName) {
        StringBuffer joinPoint = new StringBuffer();
        joinPoint.append(joinPointPrefix);
        joinPoint.append(fieldName);
        return joinPoint;
    }

    private static class JoinPointFieldData {
        private String m_name;
        private String m_signature;
        private Type m_type;
        private String m_uuid;

        public JoinPointFieldData(String name, String signature, Type type, String uuid) {
            this.m_name = name;
            this.m_signature = signature;
            this.m_type = type;
            this.m_uuid = uuid;
        }

        public String getName() {
            return this.m_name;
        }

        public String getSignature() {
            return this.m_signature;
        }

        public Type getType() {
            return this.m_type;
        }

        public String getUuid() {
            return this.m_uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JoinPointFieldData)) {
                return false;
            }
            JoinPointFieldData obj = (JoinPointFieldData)o;
            return JoinPointFieldData.areEqualsOrBothNull(obj.m_name, this.m_name) && JoinPointFieldData.areEqualsOrBothNull(obj.m_uuid, this.m_uuid) && JoinPointFieldData.areEqualsOrBothNull(obj.m_signature, this.m_signature);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + JoinPointFieldData.hashCodeOrZeroIfNull(this.m_name);
            result = 37 * result + JoinPointFieldData.hashCodeOrZeroIfNull(this.m_uuid);
            result = 37 * result + JoinPointFieldData.hashCodeOrZeroIfNull(this.m_signature);
            return result;
        }

        protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
            if (null == o1) {
                return null == o2;
            }
            return o1.equals(o2);
        }

        protected static int hashCodeOrZeroIfNull(Object o) {
            if (null == o) {
                return 19;
            }
            return o.hashCode();
        }
    }
}

