/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.BCELMethodComparator;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AdviseMemberMethodTransformer
implements AspectWerkzCodeTransformerComponent {
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformCode(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(definition, classMetaData, cg)) {
                return;
            }
            InstructionFactory factory = new InstructionFactory(cg);
            ConstantPoolGen cpg = cg.getConstantPool();
            Method[] methods = cg.getMethods();
            ArrayList<Integer> initIndexes = new ArrayList<Integer>();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("<init>")) continue;
                initIndexes.add(new Integer(i));
            }
            ArrayList<Method> methodLookupList = new ArrayList<Method>();
            for (int i = 0; i < methods.length; ++i) {
                MethodMetaData methodMetaData = BcelMetaDataMaker.createMethodMetaData(methods[i]);
                if (this.methodFilter(definition, classMetaData, methodMetaData, methods[i])) continue;
                methodLookupList.add(methods[i]);
            }
            Collections.sort(methodLookupList, BCELMethodComparator.getInstance());
            HashMap<String, Integer> methodSequences = new HashMap<String, Integer>();
            ArrayList<Method> proxyMethods = new ArrayList<Method>();
            boolean isClassAdvised = false;
            for (int i = 0; i < methods.length; ++i) {
                MethodMetaData methodMetaData = BcelMetaDataMaker.createMethodMetaData(methods[i]);
                if (this.methodFilter(definition, classMetaData, methodMetaData, methods[i]) || methods[i].isStatic()) continue;
                isClassAdvised = true;
                MethodGen mg = new MethodGen(methods[i], cg.getClassName(), cpg);
                if (methodSequences.containsKey(methods[i].getName())) {
                    int sequence = (Integer)methodSequences.get(methods[i].getName());
                    methodSequences.remove(methods[i].getName());
                    methodSequences.put(methods[i].getName(), new Integer(++sequence));
                } else {
                    methodSequences.put(methods[i].getName(), new Integer(1));
                }
                int methodLookupId = methodLookupList.indexOf(methods[i]);
                int methodSequence = (Integer)methodSequences.get(methods[i].getName());
                this.addJoinPointField(cpg, cg, mg, methodSequence);
                String controllerClassName = definition.getJoinPointController(classMetaData, methodMetaData);
                Iterator it2 = initIndexes.iterator();
                while (it2.hasNext()) {
                    int initIndex = (Integer)it2.next();
                    methods[initIndex] = this.createJoinPointField(cpg, cg, methods[initIndex], methods[i], factory, methodSequence).getMethod();
                }
                proxyMethods.add(this.createProxyMethod(cpg, cg, mg, factory, methodLookupId, methodSequence, methods[i].getAccessFlags(), definition.getUuid(), controllerClassName));
                methods[i] = this.addPrefixToMethod(mg, methods[i], methodSequence, definition.getUuid());
                mg.setMaxStack();
            }
            if (!isClassAdvised) continue;
            context.markAsAdvised();
            cg.setMethods(methods);
            Iterator it2 = proxyMethods.iterator();
            while (it2.hasNext()) {
                cg.addMethod((Method)it2.next());
            }
        }
    }

    private void addJoinPointField(ConstantPoolGen cp, ClassGen cg, MethodGen mg, int methodSequence) {
        String joinPoint = AdviseMemberMethodTransformer.getJoinPointName(mg.getMethod(), methodSequence);
        if (cg.containsField(joinPoint) != null) {
            return;
        }
        FieldGen field = new FieldGen(18, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), joinPoint, cp);
        cg.addField(field.getField());
    }

    private MethodGen createJoinPointField(ConstantPoolGen cp, ClassGen cg, Method init, Method method, InstructionFactory factory, int methodSequence) {
        MethodGen mg = new MethodGen(init, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        InstructionHandle ih = ihs[0];
        for (int i = 0; i < ihs.length; ++i) {
            Instruction instruction = ihs[i].getInstruction();
            if (!(instruction instanceof ReturnInstruction)) continue;
            ih = ihs[i];
            break;
        }
        String joinPoint = AdviseMemberMethodTransformer.getJoinPointName(method, methodSequence);
        InstructionHandle ihPost = il.insert(ih, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.insert(ih, (Instruction)factory.createNew("org.codehaus.aspectwerkz.util.SerializableThreadLocal"));
        il.insert(ih, (Instruction)InstructionConstants.DUP);
        il.insert(ih, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "<init>", (Type)Type.VOID, new Type[0], (short)183));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)181));
        il.redirectBranches(ih, ihPost);
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg;
    }

    private Method addPrefixToMethod(MethodGen mg, Method method, int methodSequence, String uuid) {
        int accessFlags = mg.getAccessFlags();
        if ((accessFlags & 4) == 0) {
            accessFlags |= 4;
        }
        if ((accessFlags & 2) != 0) {
            accessFlags &= 0xFFFFFFFD;
        }
        if ((accessFlags & 1) != 0) {
            accessFlags &= 0xFFFFFFFE;
        }
        mg.setName(this.getPrefixedMethodName(method, methodSequence, mg.getClassName()));
        mg.setAccessFlags(accessFlags);
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method createProxyMethod(ConstantPoolGen cp, ClassGen cg, MethodGen originalMethod, InstructionFactory factory, int methodId, int methodSequence, int accessFlags, String uuid, String controllerClassName) {
        InstructionList il = new InstructionList();
        String joinPoint = AdviseMemberMethodTransformer.getJoinPointName(originalMethod.getMethod(), methodSequence);
        MethodGen method = new MethodGen(accessFlags, Type.getReturnType((String)originalMethod.getSignature()), Type.getArgumentTypes((String)originalMethod.getSignature()), originalMethod.getArgumentNames(), originalMethod.getName(), cg.getClassName(), il, cp);
        String[] exceptions = originalMethod.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            method.addException(exceptions[i]);
        }
        int indexParam = 1;
        int indexStack = 0;
        int indexJoinPoint = Type.getArgumentTypes((String)originalMethod.getSignature()).length * 2 + 1;
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)180));
        BranchInstruction ifNotNull = InstructionFactory.createBranchInstruction((short)199, null);
        il.append(ifNotNull);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createNew("org.codehaus.aspectwerkz.util.SerializableThreadLocal"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)181));
        BranchInstruction biIfNotNull = null;
        InstructionHandle ihIfNotNull = null;
        ifNotNull.setTarget(il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0)));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)180));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "get", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        biIfNotNull = InstructionFactory.createBranchInstruction((short)199, null);
        il.append(biIfNotNull);
        il.append((Instruction)factory.createNew("org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cp, uuid));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((CompoundInstruction)new PUSH(cp, cg.getClassName()));
        il.append((CompoundInstruction)new PUSH(cp, methodId));
        il.append((CompoundInstruction)new PUSH(cp, controllerClassName));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint", "<init>", (Type)Type.VOID, new Type[]{Type.STRING, Type.OBJECT, Type.STRING, Type.INT, Type.STRING}, (short)183));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)180));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "set", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
        ihIfNotNull = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createCheckCast((ReferenceType)TransformationUtil.MEMBER_METHOD_JOIN_POINT_TYPE));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(indexJoinPoint += 2)));
        biIfNotNull.setTarget(ihIfNotNull);
        if (Type.getArgumentTypes((String)originalMethod.getSignature()).length != 0) {
            il.append((CompoundInstruction)new PUSH(cp, Type.getArgumentTypes((String)originalMethod.getSignature()).length));
            il.append(factory.createNewArray((Type)Type.OBJECT, (short)1));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, indexStack));
            ++indexStack;
            for (int count = 0; count < Type.getArgumentTypes((String)originalMethod.getSignature()).length; ++count) {
                String wrapperClass = null;
                BasicType type = null;
                boolean hasLongOrDouble = false;
                if (Type.getArgumentTypes((String)originalMethod.getSignature())[count] instanceof ObjectType || Type.getArgumentTypes((String)originalMethod.getSignature())[count] instanceof ArrayType) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++indexParam;
                } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count] instanceof ArrayType) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++indexParam;
                } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count] instanceof BasicType) {
                    hasLongOrDouble = false;
                    if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.LONG)) {
                        wrapperClass = "java.lang.Long";
                        type = Type.LONG;
                        hasLongOrDouble = true;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.INT)) {
                        wrapperClass = "java.lang.Integer";
                        type = Type.INT;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.SHORT)) {
                        wrapperClass = "java.lang.Short";
                        type = Type.SHORT;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.DOUBLE)) {
                        wrapperClass = "java.lang.Double";
                        type = Type.DOUBLE;
                        hasLongOrDouble = true;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.FLOAT)) {
                        wrapperClass = "java.lang.Float";
                        type = Type.FLOAT;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.CHAR)) {
                        wrapperClass = "java.lang.Character";
                        type = Type.CHAR;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.BYTE)) {
                        wrapperClass = "java.lang.Byte";
                        type = Type.BYTE;
                    } else if (Type.getArgumentTypes((String)originalMethod.getSignature())[count].equals(Type.BOOLEAN)) {
                        wrapperClass = "java.lang.Boolean";
                        type = Type.BOOLEAN;
                    } else {
                        throw new RuntimeException("unknown parameter type: " + Type.getArgumentTypes((String)originalMethod.getSignature())[count]);
                    }
                    il.append((Instruction)factory.createNew(wrapperClass));
                    il.append((Instruction)InstructionConstants.DUP);
                    il.append((Instruction)InstructionFactory.createLoad((Type)type, (int)indexParam));
                    il.append((Instruction)factory.createInvoke(wrapperClass, "<init>", (Type)Type.VOID, new Type[]{type}, (short)183));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++indexParam;
                }
                if (count == Type.getArgumentTypes((String)originalMethod.getSignature()).length - 1) continue;
                il.append((Instruction)InstructionConstants.DUP);
                il.append((CompoundInstruction)new PUSH(cp, indexStack));
                ++indexStack;
                if (!hasLongOrDouble) continue;
                ++indexParam;
            }
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexParam));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint", "setParameters", (Type)Type.VOID, new Type[]{new ArrayType((Type)Type.OBJECT, 1)}, (short)182));
            ++indexParam;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint", "proceed", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
        if (!Type.getReturnType((String)originalMethod.getSignature()).equals(Type.VOID)) {
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexParam));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
            if (Type.getReturnType((String)originalMethod.getSignature()) instanceof BasicType) {
                if (!Type.getReturnType((String)originalMethod.getSignature()).equals(Type.VOID)) {
                    BranchInstruction ifNullBranch = InstructionFactory.createBranchInstruction((short)199, null);
                    InstructionHandle elseBranch = null;
                    il.append(ifNullBranch);
                    if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.LONG)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0L));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.LONG));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Long")));
                        il.append((Instruction)factory.createInvoke("java.lang.Long", "longValue", (Type)Type.LONG, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.INT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.INT));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Integer")));
                        il.append((Instruction)factory.createInvoke("java.lang.Integer", "intValue", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.SHORT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.SHORT));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Short")));
                        il.append((Instruction)factory.createInvoke("java.lang.Short", "shortValue", (Type)Type.SHORT, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.DOUBLE)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0.0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.DOUBLE));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Double")));
                        il.append((Instruction)factory.createInvoke("java.lang.Double", "doubleValue", (Type)Type.DOUBLE, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.FLOAT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0.0f));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.FLOAT));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Float")));
                        il.append((Instruction)factory.createInvoke("java.lang.Float", "floatValue", (Type)Type.FLOAT, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.CHAR)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.CHAR));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Character")));
                        il.append((Instruction)factory.createInvoke("java.lang.Character", "charValue", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.BYTE)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.BYTE));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Byte")));
                        il.append((Instruction)factory.createInvoke("java.lang.Byte", "byteValue", (Type)Type.BYTE, Type.NO_ARGS, (short)182));
                    } else if (Type.getReturnType((String)originalMethod.getSignature()).equals(Type.BOOLEAN)) {
                        il.append((CompoundInstruction)new PUSH(cp, false));
                        il.append((Instruction)InstructionFactory.createReturn((Type)Type.BOOLEAN));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Boolean")));
                        il.append((Instruction)factory.createInvoke("java.lang.Boolean", "booleanValue", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
                    } else {
                        throw new Error("unknown return type: " + Type.getReturnType((String)originalMethod.getSignature()));
                    }
                    ifNullBranch.setTarget(elseBranch);
                }
            } else {
                il.append(factory.createCast((Type)Type.OBJECT, Type.getReturnType((String)originalMethod.getSignature())));
            }
        }
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.getReturnType((String)originalMethod.getSignature())));
        method.setMaxStack();
        method.setMaxLocals();
        return method.getMethod();
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }

    private boolean classFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        return !definition.hasExecutionPointcut(classMetaData) && !definition.hasThrowsPointcut(classMetaData);
    }

    private boolean methodFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, MethodMetaData methodMetaData, Method method) {
        if (method.isAbstract() || method.isNative() || method.getName().equals("<init>") || method.getName().equals("<clinit>") || method.getName().startsWith("___AW_original_method$_AW_$") || method.getName().equals("___AW_getMetaData") || method.getName().equals("___AW_addMetaData") || method.getName().equals("class$") || method.getName().equals("___AW_getUuid")) {
            return true;
        }
        if (definition.hasExecutionPointcut(classMetaData, methodMetaData)) {
            return false;
        }
        return !definition.hasThrowsPointcut(classMetaData, methodMetaData);
    }

    private static String getJoinPointName(Method method, int methodSequence) {
        StringBuffer joinPoint = new StringBuffer();
        joinPoint.append("___AW_jp$_AW_$member_method$_AW_$");
        joinPoint.append(method.getName());
        joinPoint.append("$_AW_$");
        joinPoint.append(methodSequence);
        return joinPoint.toString();
    }

    private String getPrefixedMethodName(Method method, int methodSequence, String className) {
        StringBuffer methodName = new StringBuffer();
        methodName.append("___AW_original_method$_AW_$");
        methodName.append(method.getName());
        methodName.append("$_AW_$");
        methodName.append(methodSequence);
        methodName.append("$_AW_$");
        methodName.append(className.replace('.', '_'));
        return methodName.toString();
    }
}

