/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AdviseStaticFieldTransformer
implements AspectWerkzCodeTransformerComponent {
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformCode(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(definition, classMetaData, cg)) {
                return;
            }
            Method[] methods = cg.getMethods();
            boolean noClInitMethod = true;
            int clinitIndex = -1;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("<clinit>")) continue;
                clinitIndex = i;
                noClInitMethod = false;
                break;
            }
            ConstantPoolGen cpg = cg.getConstantPool();
            String className = cg.getClassName();
            InstructionFactory factory = new InstructionFactory(cg);
            HashSet<String> setFieldJoinPoints = new HashSet<String>();
            HashSet<String> getFieldJoinPoints = new HashSet<String>();
            Method clInitMethod = null;
            boolean isClassAdvised = false;
            boolean isMethodAdvised = false;
            for (int i = 0; i < methods.length; ++i) {
                if (this.methodFilter(methods[i])) continue;
                isMethodAdvised = false;
                MethodGen mg = new MethodGen(methods[i], className, cpg);
                FieldInstruction currentGetFieldIns = null;
                InstructionList il = mg.getInstructionList();
                for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
                    String fieldClassName;
                    String uuid;
                    FieldMetaData fieldMetaData;
                    String joinPointClass;
                    ObjectType joinPointType;
                    String signature;
                    String fieldName;
                    FieldInstruction checkMe;
                    Instruction ins = ih.getInstruction();
                    if (ins instanceof GETSTATIC && !(checkMe = (FieldInstruction)ins).getFieldName(cpg).startsWith("___AW_jp")) {
                        String methodName;
                        InvokeInstruction invokeIns;
                        currentGetFieldIns = checkMe;
                        Instruction next = ih.getNext().getInstruction();
                        if (next instanceof INVOKEINTERFACE && ((invokeIns = (InvokeInstruction)next).getClassName(cpg).equals("java.util.Collection") || invokeIns.getClassName(cpg).equals("java.util.Enumeration") || invokeIns.getClassName(cpg).equals("java.util.Iterator") || invokeIns.getClassName(cpg).equals("java.util.List") || invokeIns.getClassName(cpg).equals("java.util.Map") || invokeIns.getClassName(cpg).equals("java.util.Set") || invokeIns.getClassName(cpg).equals("java.util.SortedMap") || invokeIns.getClassName(cpg).equals("java.util.SortedSet")) && ((methodName = invokeIns.getName(cpg)).equals("add") || methodName.equals("addAll") || methodName.equals("set") || methodName.equals("remove") || methodName.equals("removeAll") || methodName.equals("retainAll") || methodName.equals("clear") || methodName.equals("put") || methodName.equals("putAll"))) {
                            String fieldClassName2;
                            String fieldName2 = currentGetFieldIns.getName(cpg);
                            String signature2 = currentGetFieldIns.getFieldType(cpg).toString() + " " + fieldName2;
                            ObjectType joinPointType2 = TransformationUtil.STATIC_FIELD_SET_JOIN_POINT_TYPE;
                            String joinPointClass2 = "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint";
                            FieldMetaData fieldMetaData2 = BcelMetaDataMaker.createFieldMetaData(currentGetFieldIns, cpg);
                            String uuid2 = this.setFieldFilter(definition, classMetaData, fieldMetaData2);
                            if (uuid2 != null && (fieldClassName2 = currentGetFieldIns.getClassName(cpg)).equals(cg.getClassName())) {
                                isMethodAdvised = true;
                                this.insertPreAdvice(il, ih, cg, fieldName2, factory, (Type)joinPointType2);
                                this.insertPostAdvice(il, ih.getNext().getNext(), cg, fieldName2, factory, (Type)joinPointType2);
                                if (!setFieldJoinPoints.contains(fieldName2)) {
                                    setFieldJoinPoints.add(fieldName2);
                                    this.addStaticJoinPointField(cpg, cg, fieldName2, (Type)joinPointType2);
                                    if (noClInitMethod && clInitMethod == null) {
                                        clInitMethod = this.createClInitMethodWithStaticJoinPointField(cpg, cg, fieldName2, signature2, factory, (Type)joinPointType2, "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint", uuid2);
                                    } else if (noClInitMethod) {
                                        clInitMethod = this.createStaticJoinPointField(cpg, cg, clInitMethod, fieldName2, signature2, factory, (Type)joinPointType2, "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint", uuid2);
                                    } else {
                                        methods[clinitIndex] = this.createStaticJoinPointField(cpg, cg, methods[clinitIndex], fieldName2, signature2, factory, (Type)joinPointType2, "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint", uuid2);
                                    }
                                }
                                ih = ih.getNext();
                                ins = ih.getInstruction();
                            }
                        }
                    }
                    if (ins instanceof GETSTATIC) {
                        FieldInstruction gfIns = (FieldInstruction)ins;
                        fieldName = gfIns.getName(cpg);
                        signature = gfIns.getFieldType(cpg).toString() + " " + fieldName;
                        joinPointType = TransformationUtil.STATIC_FIELD_GET_JOIN_POINT_TYPE;
                        joinPointClass = "org.codehaus.aspectwerkz.joinpoint.StaticFieldGetJoinPoint";
                        fieldMetaData = BcelMetaDataMaker.createFieldMetaData(gfIns, cpg);
                        uuid = this.getFieldFilter(definition, classMetaData, fieldMetaData);
                        if (uuid == null || !(fieldClassName = gfIns.getClassName(cpg)).equals(cg.getClassName())) continue;
                        isMethodAdvised = true;
                        this.insertPreAdvice(il, ih, cg, fieldName, factory, (Type)joinPointType);
                        this.insertPostAdvice(il, ih.getNext(), cg, fieldName, factory, (Type)joinPointType);
                        if (getFieldJoinPoints.contains(fieldName)) continue;
                        getFieldJoinPoints.add(fieldName);
                        this.addStaticJoinPointField(cpg, cg, fieldName, (Type)joinPointType);
                        if (noClInitMethod && clInitMethod == null) {
                            clInitMethod = this.createClInitMethodWithStaticJoinPointField(cpg, cg, fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                            continue;
                        }
                        if (noClInitMethod) {
                            clInitMethod = this.createStaticJoinPointField(cpg, cg, clInitMethod, fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                            continue;
                        }
                        methods[clinitIndex] = this.createStaticJoinPointField(cpg, cg, methods[clinitIndex], fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                        continue;
                    }
                    if (!(ins instanceof PUTSTATIC)) continue;
                    FieldInstruction pfIns = (FieldInstruction)ins;
                    fieldName = pfIns.getName(cpg);
                    signature = pfIns.getFieldType(cpg).toString() + " " + fieldName;
                    joinPointType = TransformationUtil.STATIC_FIELD_SET_JOIN_POINT_TYPE;
                    joinPointClass = "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint";
                    fieldMetaData = BcelMetaDataMaker.createFieldMetaData(pfIns, cpg);
                    uuid = this.setFieldFilter(definition, classMetaData, fieldMetaData);
                    if (uuid == null || !(fieldClassName = pfIns.getClassName(cpg)).equals(cg.getClassName())) continue;
                    isMethodAdvised = true;
                    this.insertPreAdvice(il, ih, cg, fieldName, factory, (Type)joinPointType);
                    this.insertPostAdvice(il, ih.getNext(), cg, fieldName, factory, (Type)joinPointType);
                    if (setFieldJoinPoints.contains(fieldName)) continue;
                    setFieldJoinPoints.add(fieldName);
                    this.addStaticJoinPointField(cpg, cg, fieldName, (Type)joinPointType);
                    if (noClInitMethod && clInitMethod == null) {
                        clInitMethod = this.createClInitMethodWithStaticJoinPointField(cpg, cg, fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                        continue;
                    }
                    if (noClInitMethod) {
                        clInitMethod = this.createStaticJoinPointField(cpg, cg, clInitMethod, fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                        continue;
                    }
                    methods[clinitIndex] = this.createStaticJoinPointField(cpg, cg, methods[clinitIndex], fieldName, signature, factory, (Type)joinPointType, joinPointClass, uuid);
                }
                if (!isMethodAdvised) continue;
                mg.setMaxStack();
                methods[i] = mg.getMethod();
                isClassAdvised = true;
            }
            if (!isClassAdvised) continue;
            context.markAsAdvised();
            this.addStaticClassField(cpg, cg);
            if (noClInitMethod) {
                clInitMethod = AdviseStaticFieldTransformer.createStaticClassField(cpg, cg, clInitMethod, factory);
            } else {
                methods[clinitIndex] = AdviseStaticFieldTransformer.createStaticClassField(cpg, cg, methods[clinitIndex], factory);
            }
            cg.setMethods(methods);
            if (!noClInitMethod) continue;
            cg.addMethod(clInitMethod);
        }
    }

    private void addStaticClassField(ConstantPoolGen cp, ClassGen cg) {
        Field[] fields = cg.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("___AW_clazz")) continue;
            return;
        }
        FieldGen field = new FieldGen(26, (Type)new ObjectType("java.lang.Class"), "___AW_clazz", cp);
        cg.addField(field.getField());
    }

    private static Method createStaticClassField(ConstantPoolGen cp, ClassGen cg, Method clInit, InstructionFactory factory) {
        String className = cg.getClassName();
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (CompoundInstruction)new PUSH(cp, cg.getClassName()));
        il.insert(ih, (Instruction)factory.createInvoke("java.lang.Class", "forName", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        il.insert(ih, (Instruction)factory.createFieldAccess(className, "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private void addStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, String fieldName, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseStaticFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        if (cg.containsField(joinPoint.toString()) != null) {
            return;
        }
        FieldGen field = new FieldGen(26, joinPointType, joinPoint.toString(), cp);
        cg.addField(field.getField());
    }

    private Method createClInitMethodWithStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, String fieldName, String signature, InstructionFactory factory, Type joinPointType, String joinPointClass, String uuid) {
        String className = cg.getClassName();
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseStaticFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        InstructionList il = new InstructionList();
        MethodGen clInit = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", className, il, cp);
        il.append((Instruction)factory.createNew(joinPointClass));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cp, uuid));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)178));
        il.append((CompoundInstruction)new PUSH(cp, signature));
        il.append((Instruction)factory.createInvoke(joinPointClass, "<init>", (Type)Type.VOID, new Type[]{Type.STRING, new ObjectType("java.lang.Class"), Type.STRING}, (short)183));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)179));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        clInit.setMaxLocals();
        clInit.setMaxStack();
        return clInit.getMethod();
    }

    private Method createStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, Method clInit, String methodName, String signature, InstructionFactory factory, Type joinPointType, String joinPointClass, String uuid) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        StringBuffer joinPoint = AdviseStaticFieldTransformer.getJoinPointName(joinPointPrefix, methodName);
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (Instruction)factory.createNew(joinPointClass));
        il.insert(ih, (Instruction)InstructionConstants.DUP);
        il.insert(ih, (CompoundInstruction)new PUSH(cp, uuid));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)178));
        il.insert(ih, (CompoundInstruction)new PUSH(cp, signature));
        il.insert(ih, (Instruction)factory.createInvoke(joinPointClass, "<init>", (Type)Type.VOID, new Type[]{Type.STRING, new ObjectType("java.lang.Class"), Type.STRING}, (short)183));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private void insertPreAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseStaticFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)178));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "pre", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    private void insertPostAdvice(InstructionList il, InstructionHandle before, ClassGen cg, String fieldName, InstructionFactory factory, Type joinPointType) {
        String joinPointPrefix = this.getJoinPointPrefix(joinPointType);
        String joinPointClass = this.getJoinPointClass(joinPointType);
        StringBuffer joinPoint = AdviseStaticFieldTransformer.getJoinPointName(joinPointPrefix, fieldName);
        il.insert(before, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), joinPointType, (short)178));
        il.insert(before, (Instruction)factory.createInvoke(joinPointClass, "post", (Type)Type.VOID, Type.NO_ARGS, (short)182));
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }

    private boolean classFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        return !definition.hasSetPointcut(classMetaData) && !definition.hasGetPointcut(classMetaData);
    }

    private boolean methodFilter(Method method) {
        return method.isNative() || method.isAbstract();
    }

    private String setFieldFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (fieldMetaData.getName().startsWith("___AW_")) {
            return null;
        }
        if (definition.hasSetPointcut(classMetaData, fieldMetaData)) {
            return definition.getUuid();
        }
        return null;
    }

    private String getFieldFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (fieldMetaData.getName().startsWith("___AW_")) {
            return null;
        }
        if (definition.hasGetPointcut(classMetaData, fieldMetaData)) {
            return definition.getUuid();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getJoinPointPrefix(Type joinPointType) {
        void var2_2;
        String joinPointPrefix;
        if (joinPointType.equals(TransformationUtil.STATIC_FIELD_GET_JOIN_POINT_TYPE)) {
            joinPointPrefix = "___AW_jp$_AW_$static_field$_AW_$get$_AW_$";
        } else if (joinPointType.equals(TransformationUtil.STATIC_FIELD_SET_JOIN_POINT_TYPE)) {
            joinPointPrefix = "___AW_jp$_AW_$static_field$_AW_$set$_AW_$";
        } else {
            throw new RuntimeException("field join point type unknown: " + joinPointType);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getJoinPointClass(Type joinPointType) {
        void var2_2;
        String joinPointClass;
        if (joinPointType.equals(TransformationUtil.STATIC_FIELD_GET_JOIN_POINT_TYPE)) {
            joinPointClass = "org.codehaus.aspectwerkz.joinpoint.StaticFieldGetJoinPoint";
        } else if (joinPointType.equals(TransformationUtil.STATIC_FIELD_SET_JOIN_POINT_TYPE)) {
            joinPointClass = "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint";
        } else {
            throw new RuntimeException("field join point type unknown: " + joinPointType);
        }
        return var2_2;
    }

    private static StringBuffer getJoinPointName(String joinPointPrefix, String fieldName) {
        StringBuffer joinPoint = new StringBuffer();
        joinPoint.append(joinPointPrefix);
        joinPoint.append(fieldName);
        return joinPoint;
    }
}

