/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.metadata.BcelMetaDataMaker;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.BCELMethodComparator;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class AdviseStaticMethodTransformer
implements AspectWerkzCodeTransformerComponent {
    private final List m_definitions = DefinitionLoader.getDefinitionsForTransformation();

    public void transformCode(Context context, Klass klass) {
        Iterator it = this.m_definitions.iterator();
        while (it.hasNext()) {
            Method method;
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.loadAspects(context.getLoader());
            ClassGen cg = klass.getClassGen();
            ClassMetaData classMetaData = BcelMetaDataMaker.createClassMetaData(context.getJavaClass(cg));
            if (this.classFilter(definition, classMetaData, cg)) {
                return;
            }
            InstructionFactory factory = new InstructionFactory(cg);
            ConstantPoolGen cpg = cg.getConstantPool();
            Method[] methods = cg.getMethods();
            boolean noClinitMethod = true;
            int indexClinit = -1;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("<clinit>")) continue;
                indexClinit = i;
                noClinitMethod = false;
                break;
            }
            ArrayList<Method> methodLookupList = new ArrayList<Method>();
            for (int i = 0; i < methods.length; ++i) {
                Method method2 = methods[i];
                MethodMetaData methodMetaData = BcelMetaDataMaker.createMethodMetaData(methods[i]);
                if (this.methodFilter(definition, classMetaData, methodMetaData, method2)) continue;
                methodLookupList.add(methods[i]);
            }
            Collections.sort(methodLookupList, BCELMethodComparator.getInstance());
            HashMap<String, Integer> methodSequences = new HashMap<String, Integer>();
            ArrayList<Method> newMethods = new ArrayList<Method>();
            Method clInitMethod = null;
            boolean isClassAdvised = false;
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                MethodMetaData methodMetaData = BcelMetaDataMaker.createMethodMetaData(method);
                if (this.methodFilter(definition, classMetaData, methodMetaData, method) || !method.isStatic()) continue;
                isClassAdvised = true;
                MethodGen mg = new MethodGen(method, cg.getClassName(), cpg);
                if (methodSequences.containsKey(method.getName())) {
                    int sequence = (Integer)methodSequences.get(methods[i].getName());
                    methodSequences.remove(method.getName());
                    methodSequences.put(method.getName(), new Integer(++sequence));
                } else {
                    methodSequences.put(method.getName(), new Integer(1));
                }
                int methodLookupId = methodLookupList.indexOf(method);
                int methodSequence = (Integer)methodSequences.get(method.getName());
                this.addStaticJoinPointField(cpg, cg, mg, methodSequence);
                String controllerClassName = definition.getJoinPointController(classMetaData, methodMetaData);
                if (noClinitMethod) {
                    clInitMethod = clInitMethod == null ? this.createClInitMethodWithStaticJoinPointField(cpg, cg, method, factory, methodSequence) : this.createStaticJoinPointField(cpg, cg, clInitMethod, method, factory, methodSequence);
                } else {
                    methods[indexClinit] = this.createStaticJoinPointField(cpg, cg, methods[indexClinit], method, factory, methodSequence);
                }
                newMethods.add(this.createProxyMethod(cpg, cg, methodMetaData.getName(), mg, factory, methodLookupId, methodSequence, method.getAccessFlags(), definition.getUuid(), controllerClassName));
                methods[i] = this.addPrefixToMethod(mg, method, methodSequence, definition.getUuid());
                mg.setMaxLocals();
                mg.setMaxStack();
            }
            if (!isClassAdvised) continue;
            context.markAsAdvised();
            if (noClinitMethod && clInitMethod != null) {
                this.addStaticClassField(cpg, cg);
                clInitMethod = this.createStaticClassField(cpg, cg, clInitMethod, factory);
                newMethods.add(clInitMethod);
            } else if (newMethods.size() != 0) {
                this.addStaticClassField(cpg, cg);
                methods[indexClinit] = this.createStaticClassField(cpg, cg, methods[indexClinit], factory);
            }
            cg.setMethods(methods);
            Iterator it2 = newMethods.iterator();
            while (it2.hasNext()) {
                method = (Method)it2.next();
                cg.addMethod(method);
            }
        }
    }

    private void addStaticClassField(ConstantPoolGen cp, ClassGen cg) {
        Field[] fields = cg.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("___AW_clazz")) continue;
            return;
        }
        FieldGen field = new FieldGen(26, (Type)new ObjectType("java.lang.Class"), "___AW_clazz", cp);
        cg.addField(field.getField());
    }

    private void addStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, MethodGen mg, int methodSequence) {
        String joinPoint = this.getJoinPointName(mg.getMethod(), methodSequence);
        if (cg.containsField(joinPoint) != null) {
            return;
        }
        FieldGen field = new FieldGen(26, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), joinPoint, cp);
        cg.addField(field.getField());
    }

    private Method createClInitMethodWithStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, Method method, InstructionFactory factory, int methodSequence) {
        String className = cg.getClassName();
        String joinPoint = this.getJoinPointName(method, methodSequence);
        InstructionList il = new InstructionList();
        MethodGen clInit = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", className, il, cp);
        il.append((Instruction)factory.createNew("org.codehaus.aspectwerkz.util.SerializableThreadLocal"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "<init>", (Type)Type.VOID, new Type[0], (short)183));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)179));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        clInit.setMaxLocals();
        clInit.setMaxStack();
        return clInit.getMethod();
    }

    private Method createStaticClassField(ConstantPoolGen cp, ClassGen cg, Method clInit, InstructionFactory factory) {
        String className = cg.getClassName();
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (CompoundInstruction)new PUSH(cp, cg.getClassName()));
        il.insert(ih, (Instruction)factory.createInvoke("java.lang.Class", "forName", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        il.insert(ih, (Instruction)factory.createFieldAccess(className, "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method createStaticJoinPointField(ConstantPoolGen cp, ClassGen cg, Method clInit, Method method, InstructionFactory factory, int methodSequence) {
        String joinPoint = this.getJoinPointName(method, methodSequence);
        MethodGen mg = new MethodGen(clInit, cg.getClassName(), cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        il.insert(ih, (Instruction)factory.createNew("org.codehaus.aspectwerkz.util.SerializableThreadLocal"));
        il.insert(ih, (Instruction)InstructionConstants.DUP);
        il.insert(ih, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "<init>", (Type)Type.VOID, new Type[0], (short)183));
        il.insert(ih, (Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)179));
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method addPrefixToMethod(MethodGen mg, Method method, int methodSequence, String uuid) {
        int accessFlags = mg.getAccessFlags();
        if ((accessFlags & 4) == 0) {
            accessFlags |= 4;
        }
        if ((accessFlags & 2) != 0) {
            accessFlags &= 0xFFFFFFFD;
        }
        if ((accessFlags & 1) != 0) {
            accessFlags &= 0xFFFFFFFE;
        }
        String prefixedMethodName = AdviseStaticMethodTransformer.getPrefixedMethodName(method, methodSequence, mg.getClassName());
        mg.setName(prefixedMethodName);
        mg.setAccessFlags(accessFlags);
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private Method createProxyMethod(ConstantPoolGen cp, ClassGen cg, String originalMethodName, MethodGen originalMethod, InstructionFactory factory, int methodId, int methodSequence, int accessFlags, String uuid, String controllerClassName) {
        InstructionList il = new InstructionList();
        Type[] parameterTypes = Type.getArgumentTypes((String)originalMethod.getSignature());
        String[] parameterNames = originalMethod.getArgumentNames();
        Type returnType = Type.getReturnType((String)originalMethod.getSignature());
        String joinPoint = this.getJoinPointName(originalMethod.getMethod(), methodSequence);
        MethodGen method = new MethodGen(accessFlags, returnType, parameterTypes, parameterNames, originalMethodName, cg.getClassName(), il, cp);
        String[] exceptions = originalMethod.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            method.addException(exceptions[i]);
        }
        int idxParam = 0;
        int idxStack = 0;
        int indexJoinPoint = parameterTypes.length * 2 + 1;
        BranchInstruction biIfNotNull = null;
        InstructionHandle ihIfNotNull = null;
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint, (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)178));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "get", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        biIfNotNull = InstructionFactory.createBranchInstruction((short)199, null);
        il.append(biIfNotNull);
        il.append((Instruction)factory.createNew("org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cp, uuid));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), "___AW_clazz", (Type)new ObjectType("java.lang.Class"), (short)178));
        il.append((CompoundInstruction)new PUSH(cp, methodId));
        il.append((CompoundInstruction)new PUSH(cp, controllerClassName));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint", "<init>", (Type)Type.VOID, new Type[]{Type.STRING, new ObjectType("java.lang.Class"), Type.INT, Type.STRING}, (short)183));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createFieldAccess(cg.getClassName(), joinPoint.toString(), (Type)new ObjectType("org.codehaus.aspectwerkz.util.SerializableThreadLocal"), (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.util.SerializableThreadLocal", "set", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
        ihIfNotNull = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createCheckCast((ReferenceType)TransformationUtil.STATIC_METHOD_JOIN_POINT_TYPE));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(indexJoinPoint += 2)));
        biIfNotNull.setTarget(ihIfNotNull);
        if (parameterTypes.length != 0) {
            il.append((CompoundInstruction)new PUSH(cp, parameterTypes.length));
            il.append(factory.createNewArray((Type)Type.OBJECT, (short)1));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, idxStack));
            ++idxStack;
            for (int count = 0; count < parameterTypes.length; ++count) {
                String wrapperClass = null;
                BasicType type = null;
                boolean hasLongOrDouble = false;
                if (parameterTypes[count] instanceof ObjectType || parameterTypes[count] instanceof ArrayType) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++idxParam;
                } else if (parameterTypes[count] instanceof BasicType) {
                    hasLongOrDouble = false;
                    if (parameterTypes[count].equals(Type.LONG)) {
                        wrapperClass = "java.lang.Long";
                        type = Type.LONG;
                        hasLongOrDouble = true;
                    } else if (parameterTypes[count].equals(Type.INT)) {
                        wrapperClass = "java.lang.Integer";
                        type = Type.INT;
                    } else if (parameterTypes[count].equals(Type.SHORT)) {
                        wrapperClass = "java.lang.Short";
                        type = Type.SHORT;
                    } else if (parameterTypes[count].equals(Type.DOUBLE)) {
                        wrapperClass = "java.lang.Double";
                        type = Type.DOUBLE;
                        hasLongOrDouble = true;
                    } else if (parameterTypes[count].equals(Type.FLOAT)) {
                        wrapperClass = "java.lang.Float";
                        type = Type.FLOAT;
                    } else if (parameterTypes[count].equals(Type.CHAR)) {
                        wrapperClass = "java.lang.Character";
                        type = Type.CHAR;
                    } else if (parameterTypes[count].equals(Type.BYTE)) {
                        wrapperClass = "java.lang.Byte";
                        type = Type.BYTE;
                    } else if (parameterTypes[count].equals(Type.BOOLEAN)) {
                        wrapperClass = "java.lang.Boolean";
                        type = Type.BOOLEAN;
                    } else {
                        throw new RuntimeException("unknown parameter type: " + parameterTypes[count]);
                    }
                    il.append((Instruction)factory.createNew(wrapperClass));
                    il.append((Instruction)InstructionConstants.DUP);
                    il.append((Instruction)InstructionFactory.createLoad((Type)type, (int)idxParam));
                    il.append((Instruction)factory.createInvoke(wrapperClass, "<init>", (Type)Type.VOID, new Type[]{type}, (short)183));
                    il.append((Instruction)InstructionConstants.AASTORE);
                    ++idxParam;
                }
                if (count == parameterTypes.length - 1) continue;
                il.append((Instruction)InstructionConstants.DUP);
                il.append((CompoundInstruction)new PUSH(cp, idxStack));
                ++idxStack;
                if (!hasLongOrDouble) continue;
                ++idxParam;
            }
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)idxParam));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
            il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint", "setParameters", (Type)Type.VOID, new Type[]{new ArrayType((Type)Type.OBJECT, 1)}, (short)182));
            ++idxParam;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)indexJoinPoint));
        il.append((Instruction)factory.createInvoke("org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint", "proceed", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
        if (!returnType.equals(Type.VOID)) {
            il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)idxParam));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
            if (returnType instanceof BasicType) {
                if (!returnType.equals(Type.VOID)) {
                    BranchInstruction ifNullBranch = InstructionFactory.createBranchInstruction((short)199, null);
                    InstructionHandle elseBranch = null;
                    il.append(ifNullBranch);
                    if (returnType.equals(Type.LONG)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0L));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Long")));
                        il.append((Instruction)factory.createInvoke("java.lang.Long", "longValue", (Type)Type.LONG, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.INT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Integer")));
                        il.append((Instruction)factory.createInvoke("java.lang.Integer", "intValue", (Type)Type.INT, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.SHORT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Short")));
                        il.append((Instruction)factory.createInvoke("java.lang.Short", "shortValue", (Type)Type.SHORT, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.DOUBLE)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0.0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Double")));
                        il.append((Instruction)factory.createInvoke("java.lang.Double", "doubleValue", (Type)Type.DOUBLE, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.FLOAT)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0.0f));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Float")));
                        il.append((Instruction)factory.createInvoke("java.lang.Float", "floatValue", (Type)Type.FLOAT, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.CHAR)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Character")));
                        il.append((Instruction)factory.createInvoke("java.lang.Character", "charValue", (Type)Type.CHAR, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.BYTE)) {
                        il.append((CompoundInstruction)new PUSH(cp, 0));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Byte")));
                        il.append((Instruction)factory.createInvoke("java.lang.Byte", "byteValue", (Type)Type.BYTE, Type.NO_ARGS, (short)182));
                    } else if (returnType.equals(Type.BOOLEAN)) {
                        il.append((CompoundInstruction)new PUSH(cp, false));
                        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
                        elseBranch = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)idxParam));
                        il.append((Instruction)factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Boolean")));
                        il.append((Instruction)factory.createInvoke("java.lang.Boolean", "booleanValue", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
                    } else {
                        throw new RuntimeException("unknown return type: " + returnType);
                    }
                    ifNullBranch.setTarget(elseBranch);
                }
            } else {
                il.append(factory.createCast((Type)Type.OBJECT, returnType));
            }
        }
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        method.setMaxStack();
        method.setMaxLocals();
        return method.getMethod();
    }

    public void sessionStart() {
    }

    public void sessionEnd() {
    }

    public String verboseMessage() {
        return this.getClass().getName();
    }

    private boolean classFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, ClassGen cg) {
        if (cg.isInterface() || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.attribdef.aspect.Aspect") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.AroundAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PreAdvice") || TransformationUtil.hasSuperClass(classMetaData, "org.codehaus.aspectwerkz.xmldef.advice.PostAdvice")) {
            return true;
        }
        String className = cg.getClassName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        return !definition.hasExecutionPointcut(classMetaData) && !definition.hasThrowsPointcut(classMetaData);
    }

    private boolean methodFilter(AspectWerkzDefinition definition, ClassMetaData classMetaData, MethodMetaData methodMetaData, Method method) {
        if (method.isAbstract() || method.isNative() || method.getName().equals("<init>") || method.getName().equals("<clinit>") || method.getName().startsWith("___AW_original_method$_AW_$") || method.getName().equals("___AW_getMetaData") || method.getName().equals("___AW_addMetaData") || method.getName().equals("class$") || method.getName().equals("___AW_getUuid")) {
            return true;
        }
        if (definition.hasExecutionPointcut(classMetaData, methodMetaData)) {
            return false;
        }
        return !definition.hasThrowsPointcut(classMetaData, methodMetaData);
    }

    private String getJoinPointName(Method method, int methodSequence) {
        StringBuffer joinPoint = new StringBuffer();
        joinPoint.append("___AW_jp$_AW_$static_method$_AW_$");
        joinPoint.append(method.getName());
        joinPoint.append("$_AW_$");
        joinPoint.append(methodSequence);
        return joinPoint.toString();
    }

    private static String getPrefixedMethodName(Method method, int methodSequence, String className) {
        StringBuffer methodName = new StringBuffer();
        methodName.append("___AW_original_method$_AW_$");
        methodName.append(method.getName());
        methodName.append("$_AW_$");
        methodName.append(methodSequence);
        methodName.append("$_AW_$");
        methodName.append(className.replace('.', '_'));
        return methodName.toString();
    }
}

