/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;
import org.codehaus.aspectwerkz.regexp.ClassPattern;
import org.codehaus.aspectwerkz.regexp.Pattern;
import org.codehaus.aspectwerkz.transform.AddImplementationTransformer;
import org.codehaus.aspectwerkz.transform.AddInterfaceTransformer;
import org.codehaus.aspectwerkz.transform.AddSerialVersionUidTransformer;
import org.codehaus.aspectwerkz.transform.AdviseCallerSideMethodTransformer;
import org.codehaus.aspectwerkz.transform.AdviseMemberFieldTransformer;
import org.codehaus.aspectwerkz.transform.AdviseMemberMethodTransformer;
import org.codehaus.aspectwerkz.transform.AdviseStaticFieldTransformer;
import org.codehaus.aspectwerkz.transform.AdviseStaticMethodTransformer;
import org.codehaus.aspectwerkz.transform.AspectWerkzCodeTransformerComponent;
import org.codehaus.aspectwerkz.transform.AspectWerkzInterfaceTransformerComponent;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.Klass;

public class AspectWerkzPreProcessor
implements ClassPreProcessor {
    private static final String AW_TRANSFORM_FILTER = "aspectwerkz.transform.filter";
    private static final String AW_TRANSFORM_VERBOSE = "aspectwerkz.transform.verbose";
    private static final String AW_TRANSFORM_DUMP = "aspectwerkz.transform.dump";
    private static final ClassPattern DUMP_PATTERN;
    private static final boolean NOFILTER;
    private static final boolean DUMP_BEFORE;
    private static final boolean DUMP_AFTER;
    private static final boolean VERBOSE;
    private List m_stack;
    private AspectWerkzInterfaceTransformerComponent addSerialVerUidTransformer;
    private boolean m_initialized = false;
    private Map m_metaDataRepository;
    private Map m_definitionRepository;

    public void initialize(Hashtable params) {
        this.m_metaDataRepository = new WeakHashMap();
        this.m_definitionRepository = new WeakHashMap();
        this.addSerialVerUidTransformer = new AddSerialVersionUidTransformer();
        this.m_stack = new ArrayList();
        this.m_stack.add(new AddInterfaceTransformer());
        this.m_stack.add(new AddImplementationTransformer());
        this.m_stack.add(new AdviseMemberFieldTransformer());
        this.m_stack.add(new AdviseStaticFieldTransformer());
        this.m_stack.add(new AdviseCallerSideMethodTransformer());
        this.m_stack.add(new AdviseMemberMethodTransformer());
        this.m_stack.add(new AdviseStaticMethodTransformer());
        this.m_initialized = true;
    }

    public byte[] preProcess(String className, byte[] bytecode, ClassLoader loader) {
        if (!this.m_initialized || className == null || AspectWerkzPreProcessor.filter(className) && !NOFILTER) {
            return bytecode;
        }
        this.buildMixinMetaDataRepository(loader);
        this.loadAndMergeXmlDefinitions(loader);
        if (VERBOSE) {
            AspectWerkzPreProcessor.log(loader + ":" + className + " [" + Thread.currentThread().getName() + "]");
        }
        Klass klass = null;
        try {
            klass = new Klass(className, bytecode);
        }
        catch (Exception e) {
            AspectWerkzPreProcessor.log("failed " + className);
            e.printStackTrace();
            return bytecode;
        }
        if (DUMP_BEFORE && DUMP_PATTERN.matches(className)) {
            try {
                klass.getClassGen().getJavaClass().dump("_dump/before/" + className.replace('.', '/') + ".class");
            }
            catch (Exception e) {
                System.err.println("failed to dump " + className);
                e.printStackTrace();
            }
        }
        Context context = new Context(loader);
        context.setMetaDataRepository(this.m_metaDataRepository);
        Iterator it = this.m_stack.iterator();
        while (it.hasNext()) {
            Object transformer = it.next();
            byte[] bytecodeBeforeLocalTransformation = null;
            if (VERBOSE) {
                bytecodeBeforeLocalTransformation = new byte[klass.getBytecode().length];
                System.arraycopy(klass.getBytecode(), 0, bytecodeBeforeLocalTransformation, 0, klass.getBytecode().length);
            }
            if (transformer instanceof AspectWerkzInterfaceTransformerComponent) {
                AspectWerkzInterfaceTransformerComponent intfTransformer = (AspectWerkzInterfaceTransformerComponent)transformer;
                intfTransformer.sessionStart();
                intfTransformer.transformInterface(context, klass);
                intfTransformer.sessionEnd();
            }
            if (transformer instanceof AspectWerkzCodeTransformerComponent) {
                AspectWerkzCodeTransformerComponent codeTransformer = (AspectWerkzCodeTransformerComponent)transformer;
                codeTransformer.sessionStart();
                codeTransformer.transformCode(context, klass);
                codeTransformer.sessionEnd();
            }
            if (!VERBOSE || Arrays.equals(klass.getBytecode(), bytecodeBeforeLocalTransformation)) continue;
            AspectWerkzPreProcessor.log(className + " <- " + transformer.getClass().getName());
        }
        if (context.isAdvised()) {
            this.addSerialVerUidTransformer.sessionStart();
            this.addSerialVerUidTransformer.transformInterface(context, klass);
            this.addSerialVerUidTransformer.sessionEnd();
        }
        if (DUMP_AFTER && DUMP_PATTERN.matches(className)) {
            try {
                klass.getClassGen().getJavaClass().dump("_dump/" + (DUMP_BEFORE ? "after/" : "") + className.replace('.', '/') + ".class");
            }
            catch (Exception e) {
                System.err.println("failed to dump " + className);
                e.printStackTrace();
            }
        }
        return klass.getBytecode();
    }

    public static void log(String msg) {
        if (VERBOSE) {
            System.out.println(msg);
        }
    }

    private void buildMixinMetaDataRepository(ClassLoader loader) {
        if (this.m_metaDataRepository.containsKey(loader)) {
            return;
        }
        HashSet repository = new HashSet();
        this.m_metaDataRepository.put(loader, repository);
        List definitions = DefinitionLoader.getDefinitionsForTransformation();
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            definition.buildMixinMetaDataRepository(repository, loader);
        }
    }

    private void loadAndMergeXmlDefinitions(ClassLoader loader) {
        if (this.m_definitionRepository.containsKey(loader)) {
            return;
        }
        this.m_definitionRepository.put(loader, null);
        DefinitionLoader.loadAndMergeDefinitions(loader);
    }

    private static boolean filter(String klass) {
        return klass.startsWith("org.codehaus.aspectwerkz.") || klass.startsWith("org.apache.commons.jexl.") || klass.startsWith("gnu.trove.") || klass.startsWith("org.dom4j.") || klass.startsWith("org.xml.sax.") || klass.startsWith("javax.xml.parsers.");
    }

    static {
        String verbose = System.getProperty(AW_TRANSFORM_VERBOSE, null);
        VERBOSE = "yes".equalsIgnoreCase(verbose) || "true".equalsIgnoreCase(verbose);
        String filter = System.getProperty(AW_TRANSFORM_FILTER, null);
        NOFILTER = "no".equalsIgnoreCase(filter) || "false".equalsIgnoreCase(filter);
        String dumpPattern = System.getProperty(AW_TRANSFORM_DUMP, null);
        if (dumpPattern == null) {
            DUMP_BEFORE = false;
            DUMP_AFTER = false;
            DUMP_PATTERN = null;
        } else {
            DUMP_AFTER = true;
            DUMP_BEFORE = dumpPattern.indexOf(",before") > 0;
            DUMP_PATTERN = DUMP_BEFORE ? Pattern.compileClassPattern(dumpPattern.substring(0, dumpPattern.indexOf(44))) : Pattern.compileClassPattern(dumpPattern);
        }
    }
}

