/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class Context {
    private final ClassLoader m_loader;
    private final Repository m_repository;
    private Map m_metaDataRepository;
    private boolean m_advised = false;
    private boolean m_readOnly = false;
    private Map m_metaData = new HashMap();

    public Context(ClassLoader loader) {
        this.m_loader = loader;
        this.m_repository = new ClassLoaderRepository(loader);
    }

    public ClassLoader getLoader() {
        return this.m_loader;
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public Map getMetaDataRepository() {
        return this.m_metaDataRepository;
    }

    public void setMetaDataRepository(Map repository) {
        this.m_metaDataRepository = repository;
    }

    public void markAsAdvised() {
        this.m_advised = true;
    }

    public boolean isAdvised() {
        return this.m_advised;
    }

    public void markAsReadOnly() {
        this.m_readOnly = true;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public Object getMetaData(Object key) {
        return this.m_metaData.get(key);
    }

    public void addMetaData(Object key, Object value) {
        if (this.m_readOnly) {
            throw new IllegalStateException("context is read only");
        }
        this.m_metaData.put(key, value);
    }

    public JavaClass getJavaClass(ClassGen cg) {
        JavaClass jc = cg.getJavaClass();
        jc.setRepository(this.m_repository);
        return jc;
    }

    public JavaClass getSuperClass(ClassGen cg) {
        JavaClass klass = this.getJavaClass(cg);
        try {
            JavaClass superClass = klass.getSuperClass();
            if (superClass == null) {
                return null;
            }
            superClass.setRepository(this.m_repository);
            return superClass;
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
    }
}

