/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.generic.ClassGen;

public class Klass {
    private final String m_name;
    private final ClassGen m_classGen;
    private ClassGen m_initialClassGen;
    private final byte[] m_initialBytecode;

    public Klass(String name, byte[] bytecode) throws IOException, ClassFormatException {
        this.m_name = name;
        this.m_classGen = Klass.fromByte(bytecode);
        this.m_initialBytecode = bytecode;
    }

    public String getName() {
        return this.m_name;
    }

    public ClassGen getClassGen() {
        return this.m_classGen;
    }

    public ClassGen getInitialClassGen() throws IOException {
        if (this.m_initialClassGen == null) {
            this.m_initialClassGen = Klass.fromByte(this.m_initialBytecode);
        }
        return this.m_initialClassGen;
    }

    public byte[] getBytecode() {
        return this.m_classGen.getJavaClass().getBytes();
    }

    public static ClassGen fromByte(byte[] bytecode) throws IOException, ClassFormatException {
        ClassParser parser = new ClassParser((InputStream)new ByteArrayInputStream(bytecode), "<generated>");
        return new ClassGen(parser.parse());
    }
}

