/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.Context;

public final class TransformationUtil {
    public static final String ASPECTWERKZ_PREFIX = "___AW_";
    public static final String DELIMITER = "$_AW_$";
    public static final String CALL_SIDE_DELIMITER = "#";
    public static final String UUID_FIELD = "___AW_uuid";
    public static final String META_DATA_FIELD = "___AW_meta_data";
    public static final String STATIC_CLASS_FIELD = "___AW_clazz";
    public static final String JOIN_POINT_PREFIX = "___AW_jp";
    public static final String ORIGINAL_METHOD_PREFIX = "___AW_original_method$_AW_$";
    public static final String SUPER_CALL_WRAPPER_PREFIX = "___AW_$_AW_$super_call_wrapper$_AW_$";
    public static final String MEMBER_METHOD_JOIN_POINT_PREFIX = "___AW_jp$_AW_$member_method$_AW_$";
    public static final String STATIC_METHOD_JOIN_POINT_PREFIX = "___AW_jp$_AW_$static_method$_AW_$";
    public static final String MEMBER_FIELD_GET_JOIN_POINT_PREFIX = "___AW_jp$_AW_$member_field$_AW_$get$_AW_$";
    public static final String MEMBER_FIELD_SET_JOIN_POINT_PREFIX = "___AW_jp$_AW_$member_field$_AW_$set$_AW_$";
    public static final String STATIC_FIELD_GET_JOIN_POINT_PREFIX = "___AW_jp$_AW_$static_field$_AW_$get$_AW_$";
    public static final String STATIC_FIELD_SET_JOIN_POINT_PREFIX = "___AW_jp$_AW_$static_field$_AW_$set$_AW_$";
    public static final String CALLER_SIDE_JOIN_POINT_PREFIX = "___AW_jp$_AW_$caller_side_method$_AW_$";
    public static final String CONSTRUCTOR_JOIN_POINT_PREFIX = "___AW_jp$_AW_$constructor$_AW_$";
    public static final String FIELD_JOIN_POINT_PRE_EXECUTION_METHOD = "pre";
    public static final String FIELD_JOIN_POINT_POST_EXECUTION_METHOD = "post";
    public static final String CALLER_SIDE_JOIN_POINT_PRE_EXECUTION_METHOD = "pre";
    public static final String CALLER_SIDE_JOIN_POINT_POST_EXECUTION_METHOD = "post";
    public static final String HANDLER_JOIN_POINT_EXECUTION_METHOD = "proceed";
    public static final String GET_JOIN_POINTS_EXECUTION_METHOD = "getJoinPoints";
    public static final String UUID_EXECUTION_METHOD = "generate";
    public static final String GET_UUID_METHOD = "___AW_getUuid";
    public static final String GET_META_DATA_METHOD = "___AW_getMetaData";
    public static final String SET_META_DATA_METHOD = "___AW_addMetaData";
    public static final String CLASS_LOOKUP_METHOD = "class$";
    public static final String SYSTEM_CLASS = "org.codehaus.aspectwerkz.System";
    public static final String SYSTEM_LOADER_CLASS = "org.codehaus.aspectwerkz.SystemLoader";
    public static final String MIXIN_CLASS = "org.codehaus.aspectwerkz.Mixin";
    public static final String THREAD_LOCAL_CLASS = "org.codehaus.aspectwerkz.util.SerializableThreadLocal";
    public static final String WEAK_REFERENCE_CLASS = "java.lang.ref.WeakReference";
    public static final String MEMBER_METHOD_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint";
    public static final String STATIC_METHOD_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint";
    public static final String MEMBER_FIELD_GET_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.MemberFieldGetJoinPoint";
    public static final String MEMBER_FIELD_SET_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.MemberFieldSetJoinPoint";
    public static final String STATIC_FIELD_GET_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.StaticFieldGetJoinPoint";
    public static final String STATIC_FIELD_SET_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint";
    public static final String CALLER_SIDE_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint";
    public static final String CONSTRUCTOR_JOIN_POINT_CLASS = "org.codehaus.aspectwerkz.joinpoint.ConstructorJoinPoint";
    public static final String IDENTIFIABLE_INTERFACE = "org.codehaus.aspectwerkz.Identifiable";
    public static final String META_DATA_INTERFACE = "org.codehaus.aspectwerkz.MetaDataEnhanceable";
    public static final String UUID_CLASS = "org.codehaus.aspectwerkz.util.UuidGenerator";
    public static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";
    public static final String RETRIEVE_SYSTEM_METHOD = "getSystem";
    public static final String RETRIEVE_MIXIN_METHOD = "getMixin";
    public static final String INVOKE_MIXIN_METHOD = "___AW_invokeMixin";
    public static final ObjectType MEMBER_METHOD_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.MemberMethodJoinPoint");
    public static final ObjectType STATIC_METHOD_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.StaticMethodJoinPoint");
    public static final ObjectType MEMBER_FIELD_GET_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.MemberFieldGetJoinPoint");
    public static final ObjectType MEMBER_FIELD_SET_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.MemberFieldSetJoinPoint");
    public static final ObjectType STATIC_FIELD_GET_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.StaticFieldGetJoinPoint");
    public static final ObjectType STATIC_FIELD_SET_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.StaticFieldSetJoinPoint");
    public static final ObjectType CALLER_SIDE_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.CallerSideJoinPoint");
    public static final ObjectType CONSTRUCTOR_JOIN_POINT_TYPE = new ObjectType("org.codehaus.aspectwerkz.joinpoint.ConstructorJoinPoint");
    public static final ObjectType WEAK_REFERENCE_TYPE = new ObjectType("java.lang.ref.WeakReference");

    public static int getModifiersAsInt(String[] modifiers) {
        int accessFlags = 0;
        for (int i = 0; i < modifiers.length; ++i) {
            if (modifiers[i].equals("abstract")) {
                accessFlags |= 0x400;
                continue;
            }
            if (modifiers[i].equals("final")) {
                accessFlags |= 0x10;
                continue;
            }
            if (modifiers[i].equals("interface")) {
                accessFlags |= 0x200;
                continue;
            }
            if (modifiers[i].equals("native")) {
                accessFlags |= 0x100;
                continue;
            }
            if (modifiers[i].equals("private")) {
                accessFlags |= 2;
                continue;
            }
            if (modifiers[i].equals("protected")) {
                accessFlags |= 4;
                continue;
            }
            if (modifiers[i].equals("public")) {
                accessFlags |= 1;
                continue;
            }
            if (modifiers[i].equals("static")) {
                accessFlags |= 8;
                continue;
            }
            if (modifiers[i].equals("strict")) {
                accessFlags |= 0x800;
                continue;
            }
            if (modifiers[i].equals("super")) {
                accessFlags |= 0x20;
                continue;
            }
            if (modifiers[i].equals("synchronized")) {
                accessFlags |= 0x20;
                continue;
            }
            if (modifiers[i].equals("transient")) {
                accessFlags |= 0x80;
                continue;
            }
            if (!modifiers[i].equals("volatile")) continue;
            accessFlags |= 0x40;
        }
        return accessFlags;
    }

    public static Type getBcelType(String type) {
        BasicType bcelReturnType;
        if (type == null) {
            return Type.NULL;
        }
        if (type.equals("void")) {
            bcelReturnType = Type.VOID;
        } else if (type.equals("int")) {
            bcelReturnType = Type.INT;
        } else if (type.equals("long")) {
            bcelReturnType = Type.LONG;
        } else if (type.equals("short")) {
            bcelReturnType = Type.SHORT;
        } else if (type.equals("double")) {
            bcelReturnType = Type.DOUBLE;
        } else if (type.equals("float")) {
            bcelReturnType = Type.FLOAT;
        } else if (type.equals("char")) {
            bcelReturnType = Type.CHAR;
        } else if (type.equals("boolean")) {
            bcelReturnType = Type.BOOLEAN;
        } else if (type.equals("byte")) {
            bcelReturnType = Type.BYTE;
        } else if (type.endsWith("[]")) {
            int index = type.indexOf(91);
            int dimensions = type.length() - index >> 1;
            bcelReturnType = new ArrayType(type.substring(0, index), dimensions);
        } else {
            bcelReturnType = new ObjectType(type);
        }
        return bcelReturnType;
    }

    /*
     * WARNING - void declaration
     */
    public static Class convertBcelTypeToClass(Type bcelType) {
        void var2_2;
        Class<?> klass;
        String type = bcelType.toString();
        if (type.equals("void")) {
            klass = null;
        } else if (type.equals("long")) {
            klass = Long.TYPE;
        } else if (type.equals("int")) {
            klass = Integer.TYPE;
        } else if (type.equals("short")) {
            klass = Short.TYPE;
        } else if (type.equals("double")) {
            klass = Double.TYPE;
        } else if (type.equals("float")) {
            klass = Float.TYPE;
        } else if (type.equals("boolean")) {
            klass = Boolean.TYPE;
        } else if (type.equals("byte")) {
            klass = Byte.TYPE;
        } else if (type.equals("char")) {
            klass = Character.TYPE;
        } else {
            if (type.endsWith("[]")) {
                int index = type.indexOf(91);
                int dimension = type.length() - index >> 1;
                try {
                    klass = Array.newInstance(ContextClassLoader.loadClass(type.substring(0, index)), new int[dimension]).getClass();
                }
                catch (ClassNotFoundException e) {
                    throw new WrappedRuntimeException(e);
                }
            }
            try {
                klass = ContextClassLoader.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return var2_2;
    }

    public static long calculateSerialVersionUid(Context context, ClassGen cg) {
        try {
            Field[] fields;
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            JavaClass klass = context.getJavaClass(cg);
            Method[] methods = klass.getMethods();
            String className = klass.getClassName();
            out.writeUTF(className);
            int classMods = klass.getModifiers() & 0x611;
            if ((classMods & 0x200) != 0) {
                classMods = methods.length > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
            }
            out.writeInt(classMods);
            JavaClass[] interfaces = klass.getInterfaces();
            if (interfaces != null) {
                Object[] interfaceNames = new String[interfaces.length];
                for (i = 0; i < interfaces.length; ++i) {
                    interfaceNames[i] = interfaces[i].getClassName();
                }
                Arrays.sort(interfaceNames);
                for (i = 0; i < interfaces.length; ++i) {
                    out.writeUTF((String)interfaceNames[i]);
                }
            }
            if ((fields = klass.getFields()) != null) {
                Arrays.sort(fields, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Field field1 = (Field)o1;
                        Field field2 = (Field)o2;
                        return field1.getName().compareTo(field2.getName());
                    }
                });
                for (i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int mods = field.getModifiers();
                    if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                    out.writeUTF(field.getName());
                    out.writeInt(mods);
                    out.writeUTF(field.getSignature());
                }
            }
            ArrayList<Method> constructorList = new ArrayList<Method>();
            ArrayList<Method> regularMethodList = new ArrayList<Method>();
            if (methods != null) {
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    Method method = methods[i2];
                    if (method.getName().equals("<clinit>")) {
                        out.writeUTF("<clinit>");
                        out.writeInt(8);
                        out.writeUTF("()V");
                        continue;
                    }
                    if (method.getName().equals("<init>")) {
                        constructorList.add(method);
                        continue;
                    }
                    regularMethodList.add(method);
                }
            }
            Object[] constructors = constructorList.toArray();
            Arrays.sort(constructors, new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        Method c1 = (Method)o1;
                        Method c2 = (Method)o2;
                        return c1.getSignature().compareTo(c2.getSignature());
                    }
                    catch (Exception e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
            });
            for (int i3 = 0; i3 < constructors.length; ++i3) {
                Method constructor = (Method)constructors[i3];
                int mods = constructor.getModifiers();
                if ((mods & 2) != 0) continue;
                out.writeUTF("<init>");
                out.writeInt(mods);
                out.writeUTF(constructor.getSignature().replace('/', '.'));
            }
            Object[] regularMethods = regularMethodList.toArray();
            Arrays.sort(regularMethods, new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        Method m1 = (Method)o1;
                        Method m2 = (Method)o2;
                        int value = m1.getName().compareTo(m2.getName());
                        if (value == 0) {
                            value = m1.getSignature().compareTo(m2.getSignature());
                        }
                        return value;
                    }
                    catch (Exception e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
            });
            for (int i4 = 0; i4 < regularMethods.length; ++i4) {
                Method method = (Method)regularMethods[i4];
                int mods = method.getModifiers();
                if ((mods & 2) != 0) continue;
                out.writeUTF(method.getName());
                out.writeInt(mods);
                out.writeUTF(method.getSignature().replace('/', '.'));
            }
            out.flush();
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] digested = digest.digest(bout.toByteArray());
            long hash = 0L;
            for (int i5 = Math.min(digested.length, 8) - 1; i5 >= 0; --i5) {
                hash = hash << 8 | (long)(digested[i5] & 0xFF);
            }
            return hash;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static boolean isSerializable(Context context, ClassGen cg) {
        boolean isSerializable = false;
        try {
            JavaClass[] allInterfaces = context.getJavaClass(cg).getAllInterfaces();
            for (int i = 0; i < allInterfaces.length; ++i) {
                JavaClass anInterface = allInterfaces[i];
                if (!anInterface.getClassName().equals("java.io.Serializable")) continue;
                isSerializable = true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
        return isSerializable;
    }

    public static boolean hasSerialVersionUid(ClassGen cg) {
        boolean hasSerialVerUid = false;
        Field[] fields = cg.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().equals(SERIAL_VERSION_UID_FIELD)) continue;
            hasSerialVerUid = true;
            break;
        }
        return hasSerialVerUid;
    }

    public static void addInterfaceToClass(ClassGen cg, String interf) {
        AspectWerkzPreProcessor.log("adding interface to " + cg.getClassName() + ": " + interf);
        if (!Arrays.asList(cg.getInterfaceNames()).contains(interf)) {
            cg.addInterface(interf);
        }
    }

    public static void addMethod(ClassGen cg, Method method) {
        AspectWerkzPreProcessor.log("adding method to " + cg.getClassName() + ": " + method.toString());
        if (cg.containsMethod(method.getName(), method.getSignature()) == null) {
            cg.addMethod(method);
        }
    }

    public static void addField(ClassGen cg, Field field) {
        AspectWerkzPreProcessor.log("adding field to " + cg.getClassName() + ": " + field.toString());
        if (!cg.containsField(field)) {
            cg.addField(field);
        }
    }

    public static List createSortedMethodList(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class to sort method on can not be null");
        }
        java.lang.reflect.Method[] methods = klass.getMethods();
        ArrayList<java.lang.reflect.Method> methodList = new ArrayList<java.lang.reflect.Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            java.lang.reflect.Method method = methods[i];
            if (method.getName().equals("equals") || method.getName().equals("hashCode") || method.getName().equals("getClass") || method.getName().equals("toString") || method.getName().equals("wait") || method.getName().equals("notify") || method.getName().equals("notifyAll") || method.getName().startsWith(CLASS_LOOKUP_METHOD) || method.getName().startsWith(GET_UUID_METHOD) || method.getName().startsWith(GET_META_DATA_METHOD) || method.getName().startsWith(SET_META_DATA_METHOD) || method.getName().startsWith(ORIGINAL_METHOD_PREFIX) || method.getName().startsWith(ASPECTWERKZ_PREFIX)) continue;
            methodList.add(method);
        }
        Collections.sort(methodList, MethodComparator.getInstance(0));
        return methodList;
    }

    public static boolean hasSuperClass(ClassMetaData classMetaData, String className) {
        if (classMetaData == null || className == null) {
            return false;
        }
        if (classMetaData.getName().equals(null)) {
            return true;
        }
        if (className.equals(classMetaData.getName())) {
            return true;
        }
        return TransformationUtil.hasSuperClass(classMetaData.getSuperClass(), className);
    }
}

