/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class UuidGenerator {
    private static SecureRandom s_seeder = null;
    private static String s_midValue = null;
    private static boolean s_initialized = false;

    public static String generate(Object obj) {
        if (!s_initialized) {
            UuidGenerator.initialize(obj);
        }
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = s_seeder.nextInt();
        return UuidGenerator.hexFormat(timeLow, 8) + s_midValue + UuidGenerator.hexFormat(node, 8);
    }

    private static synchronized void initialize(Object obj) {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            String hexInetAddress = UuidGenerator.hexFormat(UuidGenerator.getInt(bytes), 8);
            String thisHashCode = UuidGenerator.hexFormat(System.identityHashCode(obj), 8);
            s_midValue = hexInetAddress + thisHashCode;
            s_seeder = new SecureRandom();
            s_seeder.nextInt();
        }
        catch (UnknownHostException e) {
            throw new Error("can not initialize the UuidGenerator generator");
        }
        s_initialized = true;
    }

    private static int getInt(byte[] abyte) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = abyte[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return UuidGenerator.padHex(s, j) + s;
    }

    private static String padHex(String str, int i) {
        StringBuffer buf = new StringBuffer();
        if (str.length() < i) {
            for (int j = 0; j < i - str.length(); ++j) {
                buf.append('0');
            }
        }
        return buf.toString();
    }

    private UuidGenerator() {
    }
}

