/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.AspectMetaData;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.Mixin;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.connectivity.Invoker;
import org.codehaus.aspectwerkz.connectivity.RemoteProxy;
import org.codehaus.aspectwerkz.connectivity.RemoteProxyServer;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.ClassNameMethodMetaDataTuple;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.regexp.CallerSidePattern;
import org.codehaus.aspectwerkz.regexp.CompiledPatternTuple;
import org.codehaus.aspectwerkz.util.SequencedHashMap;
import org.codehaus.aspectwerkz.util.Util;
import org.codehaus.aspectwerkz.xmldef.advice.AbstractAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.Advice;
import org.codehaus.aspectwerkz.xmldef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.xmldef.definition.StartupManager;
import org.codehaus.aspectwerkz.xmldef.introduction.Introduction;

public final class XmlDefSystem
implements System {
    private final Map m_aspects = new SequencedHashMap();
    private final Map m_executionPointcutCache = new WeakHashMap();
    private final Map m_getPointcutCache = new WeakHashMap();
    private final Map m_setPointcutCache = new WeakHashMap();
    private final Map m_throwsPointcutCache = new WeakHashMap();
    private final Map m_callPointcutCache = new WeakHashMap();
    private final Map m_cflowPointcutCache = new WeakHashMap();
    private final Map m_methods = new HashMap();
    private Advice[] m_advices = new Advice[0];
    private final Map m_adviceIndexes = new HashMap();
    private Introduction[] m_introductions = new Introduction[0];
    private boolean m_initialized = false;
    private final String m_uuid;
    private AspectWerkzDefinitionImpl m_definition;
    private final ThreadLocal m_controlFlowLog = new ThreadLocal();
    private RemoteProxyServer m_remoteProxyServer = null;

    public XmlDefSystem(String uuid, AspectWerkzDefinition definition) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        this.m_uuid = uuid;
        this.m_definition = (AspectWerkzDefinitionImpl)definition;
        if (System.START_REMOTE_PROXY_SERVER) {
            this.startRemoteProxyServer();
        }
    }

    public synchronized void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        StartupManager.initializeSystem(this.m_uuid, this.m_definition);
    }

    public boolean isAttribDef() {
        return false;
    }

    public boolean isXmlDef() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AspectMetaData aspect) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect can not be null");
        }
        if (aspect.getName() == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        Map map = this.m_aspects;
        synchronized (map) {
            this.m_aspects.put(aspect.getName(), aspect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, Advice advice) {
        if (name == null) {
            throw new IllegalArgumentException("advice name can not be null");
        }
        if (advice == null) {
            throw new IllegalArgumentException("advice can not be null");
        }
        Map map = this.m_adviceIndexes;
        synchronized (map) {
            Advice[] adviceArray = this.m_advices;
            synchronized (this.m_advices) {
                int index = this.m_advices.length + 1;
                this.m_adviceIndexes.put(name, new IndexTuple(index, -1));
                Advice[] tmp = new Advice[this.m_advices.length + 1];
                java.lang.System.arraycopy(this.m_advices, 0, tmp, 0, this.m_advices.length);
                tmp[this.m_advices.length] = advice;
                this.m_advices = new Advice[this.m_advices.length + 1];
                java.lang.System.arraycopy(tmp, 0, this.m_advices, 0, tmp.length);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, Introduction introduction) {
        if (name == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        if (introduction == null) {
            throw new IllegalArgumentException("introduction can not be null");
        }
        Introduction[] introductionArray = this.m_introductions;
        synchronized (this.m_introductions) {
            int nrOfIntroductions = this.m_definition.getIntroductionIndexes().size();
            if (this.m_introductions.length == 0) {
                this.m_introductions = new Introduction[nrOfIntroductions];
            }
            int index = this.m_definition.getIntroductionIndex(name) - 1;
            this.m_introductions[index] = introduction;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void enteringControlFlow(ClassNameMethodMetaDataTuple metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("classname:methodMetaData tuple can not be null");
        }
        HashSet<ClassNameMethodMetaDataTuple> cflowSet = (HashSet<ClassNameMethodMetaDataTuple>)this.m_controlFlowLog.get();
        if (cflowSet == null) {
            cflowSet = new HashSet<ClassNameMethodMetaDataTuple>();
        }
        cflowSet.add(metaData);
        this.m_controlFlowLog.set(cflowSet);
    }

    public void exitingControlFlow(ClassNameMethodMetaDataTuple metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("classname:methodMetaData tuple can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null) {
            return;
        }
        cflowSet.remove(metaData);
        this.m_controlFlowLog.set(cflowSet);
    }

    public boolean isInControlFlowOf(CompiledPatternTuple patternTuple) {
        if (patternTuple == null) {
            throw new IllegalArgumentException("class:method pattern tuple can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null || cflowSet.isEmpty()) {
            return false;
        }
        Iterator it = cflowSet.iterator();
        while (it.hasNext()) {
            ClassNameMethodMetaDataTuple tuple = (ClassNameMethodMetaDataTuple)it.next();
            CallerSidePattern callerSidePattern = (CallerSidePattern)patternTuple.getPattern();
            if (!callerSidePattern.matches(tuple.getClassName(), tuple.getMethodMetaData())) continue;
            return true;
        }
        return false;
    }

    public boolean isInControlFlowOf(Expression cflowExpression) {
        if (cflowExpression == null) {
            throw new IllegalArgumentException("cflowExpression can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null || cflowSet.isEmpty()) {
            return false;
        }
        Iterator it = cflowSet.iterator();
        while (it.hasNext()) {
            ClassNameMethodMetaDataTuple tuple = (ClassNameMethodMetaDataTuple)it.next();
            if (!cflowExpression.match(tuple.getClassMetaData(), tuple.getMethodMetaData())) continue;
            return true;
        }
        return false;
    }

    public void createAdvice(String name, String className, String deploymentModel, ClassLoader loader) {
        if (name == null) {
            throw new IllegalArgumentException("advice name can not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException("deployment model can not be null");
        }
        AbstractAdvice prototype = null;
        Class<?> adviceClass = null;
        try {
            adviceClass = loader == null ? ContextClassLoader.loadClass(className) : loader.loadClass(className);
            prototype = (AbstractAdvice)adviceClass.newInstance();
        }
        catch (Exception e) {
            StringBuffer cause = new StringBuffer();
            cause.append("could not deploy new prototype with name ");
            cause.append(name);
            cause.append(" and class ");
            cause.append(className);
            cause.append(" due to: ");
            cause.append(e);
            throw new RuntimeException(cause.toString());
        }
        prototype.setDeploymentModel(DeploymentModel.getDeploymentModelAsInt(deploymentModel));
        prototype.setName(name);
        prototype.setAdviceClass(prototype.getClass());
        prototype.setContainer(StartupManager.createAdviceContainer(prototype));
        this.register(name, prototype);
    }

    public AspectMetaData getAspectMetaData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (this.m_aspects.containsKey(name)) {
            return (AspectMetaData)this.m_aspects.get(name);
        }
        this.initialize();
        if (this.m_aspects.containsKey(name)) {
            return (AspectMetaData)this.m_aspects.get(name);
        }
        throw new DefinitionException("aspect " + name + " is not properly defined");
    }

    public Collection getAspectsMetaData() {
        this.initialize();
        return this.m_aspects.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExecutionPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_executionPointcutCache.containsKey(hashKey)) {
            return (List)this.m_executionPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            List executionPointcuts = aspect.getExecutionPointcuts(classMetaData, methodMetaData);
            pointcuts.addAll(executionPointcuts);
        }
        Map map = this.m_executionPointcutCache;
        synchronized (map) {
            this.m_executionPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), fieldMetaData);
        if (this.m_getPointcutCache.containsKey(hashKey)) {
            return (List)this.m_getPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getGetPointcuts(classMetaData, fieldMetaData));
        }
        Map map = this.m_getPointcutCache;
        synchronized (map) {
            this.m_getPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), fieldMetaData);
        if (this.m_setPointcutCache.containsKey(hashKey)) {
            return (List)this.m_setPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getSetPointcuts(classMetaData, fieldMetaData));
        }
        Map map = this.m_setPointcutCache;
        synchronized (map) {
            this.m_setPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getThrowsPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_throwsPointcutCache.containsKey(hashKey)) {
            return (List)this.m_throwsPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getThrowsPointcuts(classMetaData, methodMetaData));
        }
        Map map = this.m_throwsPointcutCache;
        synchronized (map) {
            this.m_throwsPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCallPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_callPointcutCache.containsKey(hashKey)) {
            return (List)this.m_callPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getCallPointcuts(classMetaData, methodMetaData));
        }
        Map map = this.m_callPointcutCache;
        synchronized (map) {
            this.m_callPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCFlowExpressions(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_cflowPointcutCache.containsKey(hashKey)) {
            return (List)this.m_cflowPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspects.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getCFlowExpressions(classMetaData, methodMetaData));
        }
        Map map = this.m_cflowPointcutCache;
        synchronized (map) {
            this.m_cflowPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    public IndexTuple getAdviceIndexFor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("advice name can not be null");
        }
        return (IndexTuple)this.m_adviceIndexes.get(name);
    }

    public Advice getAdvice(IndexTuple index) {
        Advice advice;
        try {
            advice = this.m_advices[index.getAspectIndex() - 1];
        }
        catch (Throwable e) {
            this.initialize();
            try {
                advice = this.m_advices[index.getAspectIndex() - 1];
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                throw new DefinitionException("no advice with index " + index);
            }
        }
        return advice;
    }

    public Advice getAdvice(String name) {
        Advice advice;
        try {
            advice = this.m_advices[((IndexTuple)this.m_adviceIndexes.get(name)).getAspectIndex() - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                advice = this.m_advices[((IndexTuple)this.m_adviceIndexes.get(name)).getAspectIndex() - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("advice " + name + " is not properly defined");
            }
        }
        return advice;
    }

    public Introduction[] getIntroductions() {
        return this.m_introductions;
    }

    public int getIntroductionIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        int index = this.m_definition.getIntroductionIndex(name);
        if (index == 0) {
            throw new DefinitionException("introduction " + name + " is not properly defined");
        }
        return index;
    }

    public Mixin getMixin(int index) {
        Introduction introduction;
        try {
            introduction = this.m_introductions[index - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                introduction = this.m_introductions[index - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("no introduction with index " + index);
            }
        }
        return introduction;
    }

    public Mixin getMixin(String name) {
        Introduction introduction;
        if (name == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        try {
            introduction = this.m_introductions[this.m_definition.getIntroductionIndex(name) - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                introduction = this.m_introductions[this.m_definition.getIntroductionIndex(name) - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("no introduction with name " + name);
            }
        }
        return introduction;
    }

    public boolean hasAspect(String name) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        this.initialize();
        return this.m_aspects.containsKey(name);
    }

    public Method getMethod(Class klass, int index) {
        Method method;
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("method index can not be less than 0");
        }
        try {
            if (!this.m_methods.containsKey(klass)) {
                this.createMethodRepository(klass);
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        try {
            method = ((Method[])this.m_methods.get(klass))[index];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                method = ((Method[])this.m_methods.get(klass))[index];
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMethodRepository(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        ArrayList methods = new ArrayList();
        this.collectMethods(klass, methods);
        Collections.sort(methods, MethodComparator.getInstance(1));
        Method[] sortedMethods = new Method[methods.size()];
        for (int i = 0; i < sortedMethods.length; ++i) {
            sortedMethods[i] = (Method)methods.get(i);
        }
        Map map = this.m_methods;
        synchronized (map) {
            this.m_methods.put(klass, sortedMethods);
        }
    }

    private void collectMethods(Class klass, List methods) {
        Method[] declaredMethods = klass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!declaredMethods[i].getName().startsWith("___AW_original_method$_AW_$")) continue;
            methods.add(declaredMethods[i]);
        }
    }

    private void startRemoteProxyServer() {
        Invoker invoker = this.getInvoker();
        this.m_remoteProxyServer = new RemoteProxyServer(ContextClassLoader.getLoader(), invoker);
        this.m_remoteProxyServer.start();
    }

    private Invoker getInvoker() {
        Invoker invoker = null;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(java.lang.System.getProperty("aspectwerkz.resource.bundle")));
            String className = properties.getProperty("remote.server.invoker.classname");
            invoker = (Invoker)ContextClassLoader.getLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            invoker = this.getDefaultInvoker();
        }
        return invoker;
    }

    private Invoker getDefaultInvoker() {
        return new Invoker(){

            public Object invoke(String handle, String methodName, Class[] paramTypes, Object[] args, Object context) {
                Object result = null;
                try {
                    Object instance = RemoteProxy.getWrappedInstance(handle);
                    Method method = instance.getClass().getMethod(methodName, paramTypes);
                    result = method.invoke(instance, args);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
                return result;
            }
        };
    }
}

