/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.advice;

import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.xmldef.advice.Advice;
import org.codehaus.aspectwerkz.xmldef.advice.AdviceContainer;
import org.codehaus.aspectwerkz.xmldef.definition.StartupManager;

public abstract class AbstractAdvice
implements Advice {
    protected String m_name;
    protected int m_deploymentModel = 0;
    protected transient AdviceContainer m_container;
    protected Class m_adviceClass;
    protected ContainerType m_memoryType;
    protected Map m_parameters = new HashMap();
    private String m_uuid;
    private System m_system;

    public static Advice newInstance(AbstractAdvice prototype) {
        try {
            AbstractAdvice clone = (AbstractAdvice)prototype.m_adviceClass.newInstance();
            clone.m_uuid = prototype.m_uuid;
            clone.m_name = prototype.m_name;
            clone.m_adviceClass = prototype.m_adviceClass;
            clone.m_container = prototype.m_container;
            clone.m_deploymentModel = prototype.m_deploymentModel;
            clone.m_parameters = prototype.m_parameters;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("could not clone advice called " + prototype.getName());
        }
    }

    public System getSystem() {
        if (this.m_system == null) {
            this.m_system = SystemLoader.getSystem(this.m_uuid);
            this.m_system.initialize();
        }
        return this.m_system;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDeploymentModel(int deploymentModel) {
        this.m_deploymentModel = deploymentModel;
    }

    public int getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void setContainer(AdviceContainer container) {
        this.m_container = container;
    }

    public AdviceContainer getContainer() {
        return this.m_container;
    }

    public void setAdviceClass(Class adviceClass) {
        this.m_adviceClass = adviceClass;
    }

    public Class getAdviceClass() {
        return this.m_adviceClass;
    }

    public ContainerType getMemoryType() {
        return this.m_container.getContainerType();
    }

    public void setParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public String getParameter(String name) {
        if (!this.m_parameters.containsKey(name)) {
            throw new DefinitionException("parameter to advice not specified: " + name);
        }
        return (String)this.m_parameters.get(name);
    }

    public void setParameters(Map parameters) {
        this.m_parameters = parameters;
    }

    public Map getParameters() {
        return this.m_parameters;
    }

    public Object getPerJvmAdvice(JoinPoint joinPoint) {
        return this.m_container.getPerJvmAdvice(joinPoint);
    }

    protected Object getPerClassAdvice(JoinPoint joinPoint) {
        return this.m_container.getPerClassAdvice(joinPoint);
    }

    protected Object getPerInstanceAdvice(JoinPoint joinPoint) {
        return this.m_container.getPerInstanceAdvice(joinPoint);
    }

    protected Object getPerThreadAdvice() {
        return this.m_container.getPerThreadAdvice();
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_name = (String)fields.get("m_name", null);
        this.m_adviceClass = (Class)fields.get("m_adviceClass", null);
        this.m_parameters = (Map)fields.get("m_parameters", null);
        this.m_memoryType = (ContainerType)fields.get("m_memoryType", ContainerType.TRANSIENT);
        this.m_deploymentModel = fields.get("m_deploymentModel", 0);
        this.m_container = StartupManager.createAdviceContainer(this);
    }
}

