/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.advice;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.xmldef.advice.AbstractAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.AdviceContainer;

public class DefaultAdviceContainerStrategy
implements AdviceContainer {
    protected Object m_perJvm;
    protected final Map m_perClass = new HashMap();
    protected final Map m_perInstance = new WeakHashMap();
    protected final Map m_perThread = new WeakHashMap();
    protected final AbstractAdvice m_prototype;

    public DefaultAdviceContainerStrategy(AbstractAdvice prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException("advice prototype can not be null");
        }
        this.m_prototype = prototype;
    }

    public Object getPerJvmAdvice(JoinPoint joinPoint) {
        if (this.m_perJvm == null) {
            try {
                this.m_perJvm = AbstractAdvice.newInstance(this.m_prototype);
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return this.m_perJvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerClassAdvice(JoinPoint joinPoint) {
        Class callingClass = joinPoint.getTargetClass();
        if (!this.m_perClass.containsKey(callingClass)) {
            Map map = this.m_perClass;
            synchronized (map) {
                try {
                    this.m_perClass.put(callingClass, AbstractAdvice.newInstance(this.m_prototype));
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return this.m_perClass.get(callingClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAdvice(JoinPoint joinPoint) {
        Object callingInstance = joinPoint.getTargetInstance();
        if (callingInstance == null) {
            return this.getPerClassAdvice(joinPoint);
        }
        if (!this.m_perInstance.containsKey(callingInstance)) {
            Map map = this.m_perInstance;
            synchronized (map) {
                try {
                    this.m_perInstance.put(callingInstance, AbstractAdvice.newInstance(this.m_prototype));
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return this.m_perInstance.get(callingInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerThreadAdvice() {
        Thread currentThread = Thread.currentThread();
        if (!this.m_perThread.containsKey(currentThread)) {
            Map map = this.m_perThread;
            synchronized (map) {
                try {
                    this.m_perThread.put(currentThread, AbstractAdvice.newInstance(this.m_prototype));
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return this.m_perThread.get(currentThread);
    }

    public ContainerType getContainerType() {
        return ContainerType.TRANSIENT;
    }
}

