/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.definition;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.ReflectionMetaDataMaker;
import org.codehaus.aspectwerkz.util.SequencedHashMap;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPostAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPreAdvice;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceStackDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.BindAdviceRule;
import org.codehaus.aspectwerkz.xmldef.definition.BindIntroductionRule;
import org.codehaus.aspectwerkz.xmldef.definition.ControllerDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.IntroductionDefinition;

public class AspectWerkzDefinitionImpl
implements AspectWerkzDefinition {
    private final TObjectIntHashMap m_introductionIndexes = new TObjectIntHashMap();
    private final Set m_aspectsToUse = new HashSet();
    private final Map m_introductionMap = new SequencedHashMap();
    private final Map m_adviceMap = new HashMap();
    private final Map m_aspectMap = new SequencedHashMap();
    private final Map m_abstractAdviceMap = new HashMap();
    private final Map m_adviceStackMap = new HashMap();
    private String m_uuid = "default";
    private final Set m_includePackages = new HashSet();
    private final Set m_excludePackages = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectWerkzDefinitionImpl() {
        AspectDefinition systemAspect = new AspectDefinition();
        systemAspect.setName("org/codehaus/aspectwerkz/system");
        this.addAdvice(CFlowPreAdvice.getDefinition());
        this.addAdvice(CFlowPostAdvice.getDefinition());
        Map map = this.m_aspectMap;
        synchronized (map) {
            this.m_aspectMap.put("org/codehaus/aspectwerkz/system", systemAspect);
        }
    }

    public boolean isAttribDef() {
        return false;
    }

    public boolean isXmlDef() {
        return true;
    }

    public void setUuid(String uuid) {
        this.m_uuid = uuid;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public Set getIncludePackages() {
        return this.m_includePackages;
    }

    public Set getExcludePackages() {
        return this.m_excludePackages;
    }

    public Collection getAbstractAspectDefinitions() {
        return this.m_abstractAdviceMap.values();
    }

    public Collection getAspectDefinitions() {
        return this.m_aspectMap.values();
    }

    public Collection getIntroductionDefinitions() {
        return this.m_introductionMap.values();
    }

    public Collection getAdviceDefinitions() {
        return this.m_adviceMap.values();
    }

    public AdviceStackDefinition getAdviceStackDefinition(String adviceStackName) {
        return (AdviceStackDefinition)this.m_adviceStackMap.get(adviceStackName);
    }

    public AspectDefinition getAbstractAspectDefinition(String name) {
        return (AspectDefinition)this.m_abstractAdviceMap.get(name);
    }

    public AspectDefinition getAspectDefinition(String name) {
        return (AspectDefinition)this.m_aspectMap.get(name);
    }

    public String[] getAspectTargetClassNames() {
        String[] classNames = new String[this.m_aspectMap.keySet().size()];
        int i = 0;
        Iterator it = this.m_aspectMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            classNames[i++] = key;
        }
        return classNames;
    }

    public AdviceDefinition getAdviceDefinition(String name) {
        Iterator it = this.m_adviceMap.values().iterator();
        while (it.hasNext()) {
            AdviceDefinition adviceDefinition = (AdviceDefinition)it.next();
            if (!adviceDefinition.getName().equals(name)) continue;
            return adviceDefinition;
        }
        return null;
    }

    public String getAdviceNameByAttribute(String attribute) {
        if (attribute == null) {
            return null;
        }
        Iterator it = this.m_adviceMap.values().iterator();
        while (it.hasNext()) {
            AdviceDefinition adviceDefinition = (AdviceDefinition)it.next();
            if (!adviceDefinition.getAttribute().equals(attribute)) continue;
            return adviceDefinition.getName();
        }
        return null;
    }

    public String getIntroductionNameByAttribute(String attribute) {
        if (attribute == null) {
            return null;
        }
        Iterator it = this.m_introductionMap.values().iterator();
        while (it.hasNext()) {
            IntroductionDefinition introductionDefinition = (IntroductionDefinition)it.next();
            if (!introductionDefinition.getAttribute().equals(attribute)) continue;
            return introductionDefinition.getName();
        }
        return null;
    }

    public String getIntroductionInterfaceName(String introductionName) {
        if (introductionName == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        if (!this.m_introductionMap.containsKey(introductionName)) {
            return null;
        }
        return ((IntroductionDefinition)this.m_introductionMap.get(introductionName)).getInterface();
    }

    public String getIntroductionImplName(String introductionName) {
        if (introductionName == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        if (!this.m_introductionMap.containsKey(introductionName)) {
            return null;
        }
        return ((IntroductionDefinition)this.m_introductionMap.get(introductionName)).getImplementation();
    }

    public IntroductionDefinition getIntroductionDefinition(String introductionName) {
        if (introductionName == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        return (IntroductionDefinition)this.m_introductionMap.get(introductionName);
    }

    public int getIntroductionIndex(String introductionName) {
        if (introductionName == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        return this.m_introductionIndexes.get((Object)introductionName);
    }

    public TObjectIntHashMap getIntroductionIndexes() {
        return this.m_introductionIndexes;
    }

    public String getJoinPointController(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            Collection controllerDefs = aspectDef.getControllerDefs();
            Iterator it2 = controllerDefs.iterator();
            while (it2.hasNext()) {
                ControllerDefinition controllerDef = (ControllerDefinition)it2.next();
                if (!controllerDef.getExpression().match(classMetaData, methodMetaData)) continue;
                return controllerDef.getClassName();
            }
        }
        return null;
    }

    public Set getAspectsToUse() {
        return this.m_aspectsToUse;
    }

    public void addAspectToUse(String className) {
        this.m_aspectsToUse.add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludePackage(String includePackage) {
        Set set = this.m_includePackages;
        synchronized (set) {
            this.m_includePackages.add(includePackage + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludePackage(String excludePackage) {
        Set set = this.m_excludePackages;
        synchronized (set) {
            this.m_excludePackages.add(excludePackage + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAbstractAspect(AspectDefinition aspect) {
        Map map = this.m_abstractAdviceMap;
        synchronized (map) {
            this.m_abstractAdviceMap.put(aspect.getName(), aspect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspect(AspectDefinition aspect) {
        Map map = this.m_aspectMap;
        synchronized (map) {
            this.m_aspectMap.put(aspect.getName(), aspect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdviceStack(AdviceStackDefinition adviceStackDef) {
        Map map = this.m_adviceStackMap;
        synchronized (map) {
            this.m_adviceStackMap.put(adviceStackDef.getName(), adviceStackDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdvice(AdviceDefinition advice) {
        Map map = this.m_adviceMap;
        synchronized (map) {
            this.m_adviceMap.put(advice.getName(), advice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntroduction(IntroductionDefinition introduction) {
        if (this.m_introductionIndexes.containsKey((Object)introduction.getName())) {
            return;
        }
        Map map = this.m_introductionMap;
        synchronized (map) {
            TObjectIntHashMap tObjectIntHashMap = this.m_introductionIndexes;
            synchronized (tObjectIntHashMap) {
                int index = this.m_introductionMap.values().size() + 1;
                this.m_introductionIndexes.put((Object)introduction.getName(), index);
                this.m_introductionMap.put(introduction.getName(), introduction);
            }
        }
    }

    public boolean hasAdvice(String name) {
        return this.m_adviceMap.containsKey(name);
    }

    public boolean hasIntroduction(String name) {
        return this.m_introductionMap.containsKey(name);
    }

    public boolean inIncludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (this.m_includePackages.isEmpty()) {
            return true;
        }
        Iterator it = this.m_includePackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean inExcludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        Iterator it = this.m_excludePackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntroductions(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it1 = this.m_aspectMap.values().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it1.next();
            List bindAdviceRules = aspectDef.getBindIntroductionRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindIntroductionRule rule = (BindIntroductionRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.CLASS) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasExecutionPointcut(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.EXECUTION) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasExecutionPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.EXECUTION) || !expression.match(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGetPointcut(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.GET) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGetPointcut(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.GET) || !expression.match(classMetaData, fieldMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSetPointcut(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.SET) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSetPointcut(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.SET) || !expression.match(classMetaData, fieldMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasThrowsPointcut(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.THROWS) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasThrowsPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.THROWS) || !expression.match(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCallPointcut(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (expression.getType().equals(PointcutType.CALL) && expression.match(classMetaData)) {
                    return true;
                }
                if (!expression.matchInOrNotIn(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPickedOutByCallPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            if (aspectDef.isAbstract()) continue;
            List bindAdviceRules = aspectDef.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)it2.next();
                Expression expression = rule.getExpression();
                if (expression.getType().equals(PointcutType.CALL) && expression.match(classMetaData, methodMetaData)) {
                    return true;
                }
                if (!expression.matchInOrNotIn(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public List getIntroductionNames(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        ArrayList introductionNames = new ArrayList();
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            List bindIntroductionRules = aspectDef.getBindIntroductionRules();
            Iterator it2 = bindIntroductionRules.iterator();
            while (it2.hasNext()) {
                BindIntroductionRule rule = (BindIntroductionRule)it2.next();
                Expression expression = rule.getExpression();
                if (!expression.getType().equals(PointcutType.CLASS) || !expression.match(classMetaData)) continue;
                introductionNames.addAll(rule.getIntroductionRefs());
            }
        }
        return introductionNames;
    }

    public void buildMixinMetaDataRepository(Set repository, ClassLoader loader) {
        Iterator it = this.getIntroductionDefinitions().iterator();
        while (it.hasNext()) {
            String className = ((IntroductionDefinition)it.next()).getImplementation();
            if (className == null) continue;
            try {
                Class<?> mixin = loader.loadClass(className);
                ClassMetaData metaData = ReflectionMetaDataMaker.createClassMetaData(mixin);
                repository.add(metaData);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public void loadAspects(ClassLoader loader) {
    }
}

