/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.definition;

import com.karneim.util.collection.regex.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.BindAdviceRule;
import org.codehaus.aspectwerkz.xmldef.definition.BindIntroductionRule;
import org.codehaus.aspectwerkz.xmldef.definition.IntroductionDefinition;

public class DefinitionValidator {
    private List m_errors = new ArrayList();
    private Set m_aspectNames = new HashSet();
    private Set m_introductionNames = new HashSet();
    private Set m_adviceNames = new HashSet();
    private Set m_attributes = new HashSet();
    private final AspectWerkzDefinition m_definition;
    private static final Pattern VALIDE_PATTERN = new Pattern("[A-Za-z0-9_$]+");

    public DefinitionValidator(AspectWerkzDefinition definition) {
        this.m_definition = definition;
    }

    public void validate() {
        Collection introductionDefs = this.m_definition.getIntroductionDefinitions();
        Collection adviceDefs = this.m_definition.getAdviceDefinitions();
        Collection aspectDefs = this.m_definition.getAspectDefinitions();
        this.validateSyntax(this.m_definition.getUuid(), "uuid");
        this.validateIntroductions(introductionDefs);
        this.validateAdvices(adviceDefs);
        this.validateAspects(aspectDefs);
    }

    private void validateAspects(Collection aspectDefs) {
        Iterator i = aspectDefs.iterator();
        while (i.hasNext()) {
            AspectDefinition def = (AspectDefinition)i.next();
            List bindAdviceRules = def.getBindAdviceRules();
            Iterator i1 = bindAdviceRules.iterator();
            while (i1.hasNext()) {
                BindAdviceRule rule = (BindAdviceRule)i1.next();
                this.checkUndefinedAdvices(rule.getAdviceRefs());
            }
            List bindIntroductionRules = def.getBindIntroductionRules();
            Iterator i2 = bindIntroductionRules.iterator();
            while (i2.hasNext()) {
                BindIntroductionRule rule = (BindIntroductionRule)i2.next();
                this.checkUndefinedIntroductions(rule.getIntroductionRefs());
            }
            Collection pointcutDefs = def.getPointcutDefs();
            this.validatePointcuts(pointcutDefs);
            this.checkAspectName(def.getName());
        }
    }

    private void checkUndefinedIntroductions(List refs) {
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            String ref = (String)i.next();
            if (this.m_definition.hasIntroduction(ref)) continue;
            this.addErrorMessage("Introduction '" + ref + "' not defined");
        }
    }

    private void checkUndefinedAdvices(List refs) {
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            String ref = (String)i.next();
            if (this.m_definition.hasAdvice(ref)) continue;
            this.addErrorMessage("Advice '" + ref + "' not defined");
        }
    }

    private void validatePointcuts(Collection pointcutDefs) {
        Iterator i = pointcutDefs.iterator();
        while (i.hasNext()) {
            PointcutDefinition def = (PointcutDefinition)i.next();
            this.validateSyntax(def.getName(), "pointcut");
        }
    }

    private void validateAdvices(Collection adviceDefs) {
        Iterator i = adviceDefs.iterator();
        while (i.hasNext()) {
            AdviceDefinition def = (AdviceDefinition)i.next();
            String adviceClass = def.getAdviceClassName();
            try {
                Class.forName(adviceClass);
            }
            catch (ClassNotFoundException e) {
                this.addErrorMessage("Advice class not found: " + adviceClass + "(exception: " + e + ")");
            }
            catch (NoClassDefFoundError e) {
                this.addErrorMessage("Advice class not found: " + adviceClass + "(exception: " + e + ")");
            }
            this.checkAdviceName(def.getName());
            this.checkDuplicateAttribute(def.getAttribute());
        }
    }

    private void validateIntroductions(Collection introductionDefs) {
        Iterator i = introductionDefs.iterator();
        while (i.hasNext()) {
            IntroductionDefinition def = (IntroductionDefinition)i.next();
            String interf = def.getInterface();
            try {
                Class.forName(interf);
            }
            catch (ClassNotFoundException e) {
                this.addErrorMessage("Introduction interface not found: " + interf);
            }
            String impl = def.getImplementation();
            if (impl != null) {
                try {
                    Class.forName(impl);
                }
                catch (ClassNotFoundException e) {
                    this.addErrorMessage("Introduction implementation not found: " + impl);
                }
            }
            this.checkIntroductionName(def.getName());
            this.checkDuplicateAttribute(def.getAttribute());
        }
    }

    private void checkDuplicateAttribute(String attribute) {
        if (attribute != null && !"".equals(attribute) && !this.m_attributes.add(attribute)) {
            this.addErrorMessage("Duplicate attribute definition: " + attribute);
        }
    }

    private void checkAspectName(String name) {
        if (!this.m_aspectNames.add(name)) {
            this.addErrorMessage("Duplicate aspect name definition: " + name);
        }
    }

    private void checkAdviceName(String name) {
        if (!this.m_adviceNames.add(name)) {
            this.addErrorMessage("Duplicate advice name definition: " + name);
        }
    }

    private void checkIntroductionName(String name) {
        if (!this.m_introductionNames.add(name)) {
            this.addErrorMessage("Duplicate introduction name definition: " + name);
        }
    }

    private void addErrorMessage(String errorMessage) {
        this.m_errors.add(errorMessage);
    }

    public List getErrorMessages() {
        return this.m_errors;
    }

    private void validateSyntax(String s, String errorMsg) {
        if (!VALIDE_PATTERN.contains(s)) {
            this.m_errors.add("Invalid syntax for " + errorMsg + ": " + s);
        }
    }
}

