/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.definition;

import java.util.Iterator;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.PatternFactory;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceStackDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.xmldef.definition.BindAdviceRule;
import org.codehaus.aspectwerkz.xmldef.definition.BindIntroductionRule;
import org.codehaus.aspectwerkz.xmldef.definition.IntroductionDefinition;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class DocumentParser {
    public static final String METHOD = "method";
    public static final String GET_FIELD = "getfield";
    public static final String SET_FIELD = "setfield";
    public static final String THROWS = "throws";
    public static final String CALLER_SIDE = "callerside";
    public static final String CFLOW = "cflow";
    public static final String CLASS = "class";

    public static AspectWerkzDefinition parseSystemElement(Element systemElement, String basePackage) {
        String uuid = systemElement.attributeValue("id");
        if (uuid == null || uuid.equals("")) {
            uuid = "default";
        }
        return DocumentParser.parseElements(systemElement, basePackage, uuid);
    }

    public static AspectWerkzDefinition parseElements(Element systemElement, String basePackage, String uuid) {
        AspectWerkzDefinitionImpl definition = new AspectWerkzDefinitionImpl();
        definition.setUuid(uuid);
        org.codehaus.aspectwerkz.definition.DocumentParser.parseIncludePackageElements(systemElement, definition, basePackage);
        org.codehaus.aspectwerkz.definition.DocumentParser.parseExcludePackageElements(systemElement, definition, basePackage);
        boolean hasDef = false;
        if (DocumentParser.parseIntroductionElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (DocumentParser.parseAdviceElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (DocumentParser.parseAdviceStackElements(systemElement, definition)) {
            hasDef = true;
        }
        if (DocumentParser.parseAspectElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (DocumentParser.parsePackageElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (hasDef) {
            return definition;
        }
        return null;
    }

    private static boolean parsePackageElements(Element systemElement, AspectWerkzDefinitionImpl definition, String basePackage) {
        boolean hasDef = false;
        Iterator it1 = systemElement.elementIterator("package");
        while (it1.hasNext()) {
            String packageName;
            Element packageElement = (Element)it1.next();
            if (DocumentParser.parseIntroductionElements(packageElement, definition, packageName = basePackage + DocumentParser.getPackage(packageElement))) {
                hasDef = true;
            }
            if (DocumentParser.parseAdviceElements(packageElement, definition, packageName)) {
                hasDef = true;
            }
            if (DocumentParser.parseAdviceStackElements(packageElement, definition)) {
                hasDef = true;
            }
            if (!DocumentParser.parseAspectElements(packageElement, definition, packageName)) continue;
            hasDef = true;
        }
        return hasDef;
    }

    private static boolean parseIntroductionElements(Element root, AspectWerkzDefinitionImpl definition, String packageName) {
        boolean hasDef = false;
        Iterator it1 = root.elementIterator("introduction-def");
        while (it1.hasNext()) {
            IntroductionDefinition introDef = new IntroductionDefinition();
            Element introduction = (Element)it1.next();
            Iterator it2 = introduction.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equals("name")) {
                    introDef.setName(value);
                    continue;
                }
                if (name.equals("interface")) {
                    introDef.setInterface(packageName + value);
                    continue;
                }
                if (name.equals("implementation")) {
                    introDef.setImplementation(packageName + value);
                    continue;
                }
                if (name.equals("deployment-model")) {
                    introDef.setDeploymentModel(value);
                    continue;
                }
                if (!name.equals("attribute")) continue;
                introDef.setAttribute(value);
            }
            definition.addIntroduction(introDef);
            hasDef = true;
        }
        return hasDef;
    }

    private static boolean parseAdviceElements(Element root, AspectWerkzDefinitionImpl definition, String packageName) {
        boolean hasDef = false;
        Iterator it1 = root.elementIterator("advice-def");
        while (it1.hasNext()) {
            AdviceDefinition adviceDef = new AdviceDefinition();
            Element advice = (Element)it1.next();
            Iterator it2 = advice.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equals("name")) {
                    adviceDef.setName(value);
                    continue;
                }
                if (name.equals(CLASS)) {
                    adviceDef.setAdviceClassName(packageName + value);
                    continue;
                }
                if (name.equals("deployment-model")) {
                    adviceDef.setDeploymentModel(value);
                    continue;
                }
                if (!name.equals("attribute")) continue;
                adviceDef.setAttribute(value);
            }
            it2 = advice.elementIterator();
            while (it2.hasNext()) {
                Element nestedAdviceElement = (Element)it2.next();
                if (!nestedAdviceElement.getName().trim().equals("param")) continue;
                adviceDef.addParameter(nestedAdviceElement.attributeValue("name"), nestedAdviceElement.attributeValue("value"));
            }
            definition.addAdvice(adviceDef);
            hasDef = true;
        }
        return hasDef;
    }

    private static boolean parseAspectElements(Element root, AspectWerkzDefinitionImpl definition, String packageName) {
        String value;
        String name;
        Attribute attribute;
        Iterator it2;
        Element aspect;
        AspectDefinition aspectDef;
        String value2;
        String name2;
        Attribute attribute2;
        Iterator it22;
        String aspectName;
        Element aspect2;
        Iterator it1 = root.elementIterator("aspect");
        while (it1.hasNext()) {
            aspect2 = (Element)it1.next();
            aspectName = null;
            it22 = aspect2.attributeIterator();
            while (it22.hasNext()) {
                attribute2 = (Attribute)it22.next();
                name2 = attribute2.getName().trim();
                value2 = attribute2.getValue().trim();
                if (name2.equals("name")) {
                    aspectName = value2;
                    continue;
                }
                if (!name2.equals("extends")) continue;
                aspectName = value2;
                break;
            }
            DocumentParser.registerPointcuts(aspect2, aspectName, packageName);
        }
        it1 = root.elementIterator("abstract-aspect");
        while (it1.hasNext()) {
            aspect2 = (Element)it1.next();
            aspectName = null;
            it22 = aspect2.attributeIterator();
            while (it22.hasNext()) {
                attribute2 = (Attribute)it22.next();
                name2 = attribute2.getName().trim();
                value2 = attribute2.getValue().trim();
                if (!name2.equals("name")) continue;
                aspectName = value2;
                break;
            }
            DocumentParser.registerPointcuts(aspect2, aspectName, packageName);
        }
        boolean hasDef = false;
        Iterator it12 = root.elementIterator("aspect");
        while (it12.hasNext()) {
            aspectDef = new AspectDefinition();
            aspect = (Element)it12.next();
            it2 = aspect.attributeIterator();
            while (it2.hasNext()) {
                attribute = (Attribute)it2.next();
                name = attribute.getName().trim();
                value = attribute.getValue().trim();
                if (name.equals("name")) {
                    aspectDef.setName(value);
                    continue;
                }
                if (!name.equals("extends")) continue;
                aspectDef.setExtends(value);
            }
            DocumentParser.parsePointcutElements(aspect, aspectDef, packageName);
            DocumentParser.parseControllerElements(aspect, aspectDef);
            DocumentParser.parseBindIntroductionElements(aspect, aspectDef, packageName);
            DocumentParser.parseBindAdviceElements(aspect, aspectDef, packageName);
            definition.addAspect(aspectDef);
            hasDef = true;
        }
        it12 = root.elementIterator("abstract-aspect");
        while (it12.hasNext()) {
            aspectDef = new AspectDefinition();
            aspectDef.setAbstract(true);
            aspect = (Element)it12.next();
            it2 = aspect.attributeIterator();
            while (it2.hasNext()) {
                attribute = (Attribute)it2.next();
                name = attribute.getName().trim();
                value = attribute.getValue().trim();
                if (!name.equals("name")) continue;
                aspectDef.setName(value);
            }
            DocumentParser.parsePointcutElements(aspect, aspectDef, packageName);
            DocumentParser.parseControllerElements(aspect, aspectDef);
            DocumentParser.parseBindIntroductionElements(aspect, aspectDef, packageName);
            DocumentParser.parseBindAdviceElements(aspect, aspectDef, packageName);
            definition.addAbstractAspect(aspectDef);
            hasDef = true;
        }
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            aspectDef = (AspectDefinition)it.next();
            DocumentParser.handleAbstractAspectDependencies(aspectDef, definition);
        }
        return hasDef;
    }

    private static void handleAbstractAspectDependencies(AspectDefinition aspectDef, AspectWerkzDefinitionImpl definition) {
        String extendsRef = aspectDef.getExtends();
        if (extendsRef != null) {
            AspectDefinition abstractAspect = definition.getAbstractAspectDefinition(extendsRef);
            if (abstractAspect == null) {
                throw new DefinitionException("abstract aspect [" + aspectDef.getExtends() + "] is not defined");
            }
            Iterator it = abstractAspect.getPointcutDefs().iterator();
            while (it.hasNext()) {
                PointcutDefinition pointcutDef = (PointcutDefinition)it.next();
                aspectDef.addPointcutDef(pointcutDef);
            }
            it = abstractAspect.getBindAdviceRules().iterator();
            while (it.hasNext()) {
                BindAdviceRule bindAdviceRule = (BindAdviceRule)it.next();
                aspectDef.addBindAdviceRule(bindAdviceRule);
            }
            it = abstractAspect.getBindIntroductionRules().iterator();
            while (it.hasNext()) {
                BindIntroductionRule bindIntroductionRule = (BindIntroductionRule)it.next();
                aspectDef.addBindIntroductionRule(bindIntroductionRule);
            }
        }
    }

    private static void registerPointcuts(Element aspect, String aspectName, String packageName) {
        Iterator it2 = aspect.elementIterator();
        while (it2.hasNext()) {
            Element nestedAdviceElement = (Element)it2.next();
            if (!nestedAdviceElement.getName().trim().equals("pointcut-def")) continue;
            String pointcutName = null;
            String expression = null;
            PointcutType pointcutType = null;
            try {
                Iterator it3 = nestedAdviceElement.attributeIterator();
                while (it3.hasNext()) {
                    Attribute attribute = (Attribute)it3.next();
                    String name = attribute.getName().trim();
                    String value = attribute.getValue().trim();
                    if (name.equals("name")) {
                        pointcutName = value;
                        continue;
                    }
                    if (!name.equals("type")) continue;
                    if (value.equalsIgnoreCase(METHOD)) {
                        pointcutType = PointcutType.EXECUTION;
                        expression = PatternFactory.createMethodPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (value.equalsIgnoreCase(CFLOW)) {
                        pointcutType = PointcutType.CFLOW;
                        expression = PatternFactory.createCallPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (value.equalsIgnoreCase(SET_FIELD)) {
                        pointcutType = PointcutType.SET;
                        expression = PatternFactory.createMethodPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (value.equalsIgnoreCase(GET_FIELD)) {
                        pointcutType = PointcutType.GET;
                        expression = PatternFactory.createFieldPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (value.equalsIgnoreCase(THROWS)) {
                        pointcutType = PointcutType.THROWS;
                        expression = PatternFactory.createThrowsPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (value.equalsIgnoreCase(CALLER_SIDE)) {
                        pointcutType = PointcutType.CALL;
                        expression = PatternFactory.createCallPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                        continue;
                    }
                    if (!value.equalsIgnoreCase(CLASS)) continue;
                    pointcutType = PointcutType.CLASS;
                    expression = PatternFactory.createClassPattern(nestedAdviceElement.attributeValue("pattern"), packageName);
                }
                ExpressionNamespace space = ExpressionNamespace.getExpressionNamespace(aspectName);
                space.registerExpression(expression, packageName, pointcutName, pointcutType);
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void parsePointcutElements(Element aspect, AspectDefinition aspectDef, String packageName) {
        Iterator it2 = aspect.elementIterator();
        while (it2.hasNext()) {
            Element nestedAdviceElement = (Element)it2.next();
            if (!nestedAdviceElement.getName().trim().equals("pointcut-def")) continue;
            try {
                PointcutDefinition pointcutDef = new PointcutDefinition();
                Iterator it3 = nestedAdviceElement.attributeIterator();
                while (it3.hasNext()) {
                    Attribute attribute = (Attribute)it3.next();
                    String name = attribute.getName().trim();
                    String value = attribute.getValue().trim();
                    if (name.equals("name")) {
                        pointcutDef.setName(value);
                        continue;
                    }
                    if (name.equals("type")) {
                        PointcutType type = null;
                        String expression = nestedAdviceElement.attributeValue("pattern");
                        if (expression == null || expression.length() == 0) {
                            expression = nestedAdviceElement.attributeValue("expression");
                        }
                        if (value.equalsIgnoreCase(METHOD)) {
                            type = PointcutType.EXECUTION;
                            pointcutDef.setExpression(PatternFactory.createMethodPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(CFLOW)) {
                            type = PointcutType.CFLOW;
                            pointcutDef.setExpression(PatternFactory.createMethodPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(SET_FIELD)) {
                            type = PointcutType.SET;
                            pointcutDef.setExpression(PatternFactory.createFieldPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(GET_FIELD)) {
                            type = PointcutType.GET;
                            pointcutDef.setExpression(PatternFactory.createFieldPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(THROWS)) {
                            type = PointcutType.THROWS;
                            pointcutDef.setExpression(PatternFactory.createThrowsPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(CALLER_SIDE)) {
                            type = PointcutType.CALL;
                            pointcutDef.setExpression(PatternFactory.createCallPattern(expression, packageName));
                        } else if (value.equalsIgnoreCase(CLASS)) {
                            type = PointcutType.CLASS;
                            pointcutDef.setExpression(PatternFactory.createClassPattern(expression, packageName));
                        }
                        pointcutDef.setType(type);
                        continue;
                    }
                    if (!name.equals("non-reentrant")) continue;
                    pointcutDef.setNonReentrant(value);
                }
                aspectDef.addPointcutDef(pointcutDef);
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void parseControllerElements(Element aspect, AspectDefinition aspectDef) {
    }

    private static void parseBindIntroductionElements(Element aspect, AspectDefinition aspectDef, String packageName) {
        Iterator it2 = aspect.elementIterator();
        while (it2.hasNext()) {
            Element nestedAdviceElement = (Element)it2.next();
            if (!nestedAdviceElement.getName().trim().equals("bind-introduction")) continue;
            try {
                BindIntroductionRule bindIntroductionRule = new BindIntroductionRule();
                Iterator it3 = nestedAdviceElement.attributeIterator();
                while (it3.hasNext()) {
                    Attribute attribute = (Attribute)it3.next();
                    String name = attribute.getName().trim();
                    String value = attribute.getValue().trim();
                    if (name.equals(CLASS)) {
                        bindIntroductionRule.setExpression(ExpressionNamespace.getExpressionNamespace(aspectDef.getName()).createExpression(packageName + value, PointcutType.CLASS));
                        continue;
                    }
                    if (!name.equals("introduction-ref")) continue;
                    bindIntroductionRule.addIntroductionRef(value);
                }
                DocumentParser.parseIntroductionWeavingRuleNestedElements(nestedAdviceElement, bindIntroductionRule);
                aspectDef.addBindIntroductionRule(bindIntroductionRule);
            }
            catch (Exception e) {
                throw new DefinitionException("introduction definition in aspect " + aspectDef.getName() + " is not well-formed: " + e.toString());
            }
        }
    }

    private static void parseBindAdviceElements(Element aspect, AspectDefinition aspectDef, String packageName) {
        Iterator it2 = aspect.elementIterator();
        while (it2.hasNext()) {
            Element nestedAdviceElement = (Element)it2.next();
            if (!nestedAdviceElement.getName().trim().equals("bind-advice")) continue;
            try {
                BindAdviceRule bindAdviceRule = new BindAdviceRule();
                String pointcutExpression = "";
                Iterator it3 = nestedAdviceElement.attributeIterator();
                while (it3.hasNext()) {
                    Attribute attribute = (Attribute)it3.next();
                    String name = attribute.getName().trim();
                    String value = attribute.getValue().trim();
                    if (name.equals(CFLOW)) {
                        pointcutExpression = pointcutExpression + " IN (" + value + ")";
                        continue;
                    }
                    if (name.equals("pointcut") || name.equals("expression")) {
                        pointcutExpression = value + pointcutExpression;
                        continue;
                    }
                    if (!name.equals("advice-ref")) continue;
                    bindAdviceRule.addAdviceRef(value);
                }
                ExpressionNamespace space = ExpressionNamespace.getExpressionNamespace(aspectDef.getName());
                bindAdviceRule.setExpression(space.createExpression(pointcutExpression));
                DocumentParser.parseAdviceWeavingRuleNestedElements(nestedAdviceElement, bindAdviceRule);
                aspectDef.addBindAdviceRule(bindAdviceRule);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DefinitionException("advice definition in aspect " + aspectDef.getName() + " is not well-formed: " + e.toString());
            }
        }
    }

    private static void parseIntroductionWeavingRuleNestedElements(Element introductionElement, BindIntroductionRule introWeavingRule) {
        Iterator it = introductionElement.elementIterator();
        while (it.hasNext()) {
            Element nestedElement = (Element)it.next();
            if (!nestedElement.getName().trim().equals("introduction-ref")) continue;
            introWeavingRule.addIntroductionRef(nestedElement.attributeValue("name"));
        }
    }

    private static void parseAdviceWeavingRuleNestedElements(Element adviceElement, BindAdviceRule adviceWeavingRule) {
        Iterator it = adviceElement.elementIterator();
        while (it.hasNext()) {
            Element nestedElement = (Element)it.next();
            if (nestedElement.getName().trim().equals("advice-ref")) {
                adviceWeavingRule.addAdviceRef(nestedElement.attributeValue("name"));
                continue;
            }
            if (!nestedElement.getName().trim().equals("advices-ref")) continue;
            adviceWeavingRule.addAdviceStackRef(nestedElement.attributeValue("name"));
        }
    }

    private static boolean parseAdviceStackElements(Element root, AspectWerkzDefinitionImpl definition) {
        boolean hasDef = false;
        Iterator it1 = root.elementIterator("advices-def");
        while (it1.hasNext()) {
            AdviceStackDefinition adviceStackDef = new AdviceStackDefinition();
            Element adviceStack = (Element)it1.next();
            Iterator it2 = adviceStack.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (!name.equals("name")) continue;
                adviceStackDef.setName(value);
            }
            it2 = adviceStack.elementIterator();
            while (it2.hasNext()) {
                Element nestedElement = (Element)it2.next();
                if (!nestedElement.getName().trim().equals("advice-ref")) continue;
                adviceStackDef.addAdvice(nestedElement.attributeValue("name"));
            }
            definition.addAdviceStack(adviceStackDef);
            hasDef = true;
        }
        return hasDef;
    }

    private static String getPackage(Element packageElement) {
        String packageName = "";
        Iterator it2 = packageElement.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            if (!attribute.getName().trim().equals("name")) continue;
            packageName = attribute.getValue().trim();
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 1);
                break;
            }
            if (packageName.endsWith(".")) break;
            packageName = packageName + ".";
            break;
        }
        return packageName;
    }
}

