/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.AspectMetaData;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.ExpressionExpression;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.pointcut.CallPointcut;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.pointcut.GetPointcut;
import org.codehaus.aspectwerkz.pointcut.SetPointcut;
import org.codehaus.aspectwerkz.pointcut.ThrowsPointcut;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;
import org.codehaus.aspectwerkz.xmldef.advice.AbstractAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.AdviceContainer;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPostAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.CFlowPreAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.PostAdvice;
import org.codehaus.aspectwerkz.xmldef.advice.PreAdvice;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AdviceStackDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.xmldef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.xmldef.definition.BindAdviceRule;
import org.codehaus.aspectwerkz.xmldef.definition.BindIntroductionRule;
import org.codehaus.aspectwerkz.xmldef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.xmldef.introduction.Introduction;
import org.codehaus.aspectwerkz.xmldef.introduction.IntroductionContainer;

public class StartupManager {
    public static final String ASPECTWERKZ_HOME = System.getProperty("aspectwerkz.home", ".");
    public static final String DEFINITION_FILE = System.getProperty("aspectwerkz.definition.file", null);
    public static final String DEFINITION_CLASS_NAME = System.getProperty("aspectwerkz.definition.class", null);
    public static final String DEFAULT_DEFINITION_FILE = "aspectwerkz.xml";
    public static final String DEFAULT_INTRODUCTION_CONTAINER = "org.codehaus.aspectwerkz.xmldef.introduction.DefaultIntroductionContainerStrategy";
    public static final String DEFAULT_ADVICE_CONTAINER = "org.codehaus.aspectwerkz.xmldef.advice.DefaultAdviceContainerStrategy";
    public static final String INTRODUCTION_CONTAINER_IMPLEMENTATION_CLASS = System.getProperty("aspectwerkz.introduction.container.impl", "org.codehaus.aspectwerkz.xmldef.introduction.DefaultIntroductionContainerStrategy");
    public static final String ADVICE_CONTAINER_IMPLEMENTATION_CLASS = System.getProperty("aspectwerkz.advice.container.impl", "org.codehaus.aspectwerkz.xmldef.advice.DefaultAdviceContainerStrategy");
    private static boolean s_initialized = false;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice;

    public static void initializeSystem(String uuid, AspectWerkzDefinition definition) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        if (s_initialized) {
            return;
        }
        s_initialized = true;
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        StartupManager.createAspects(uuid, def);
        StartupManager.registerIntroductions(uuid, def);
        StartupManager.registerAdvices(uuid, def);
        StartupManager.registerPointcuts(uuid, def);
        StartupManager.addIntroductionReferencesToAspects(uuid, def);
    }

    public static IntroductionContainer createIntroductionContainer(Class implClass) {
        if (implClass == null) {
            return null;
        }
        try {
            Class klass = ContextClassLoader.loadClass(INTRODUCTION_CONTAINER_IMPLEMENTATION_CLASS);
            Constructor constructor = klass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = StartupManager.class$("java.lang.Class")) : class$java$lang$Class);
            return (IntroductionContainer)constructor.newInstance(implClass);
        }
        catch (Exception e) {
            StringBuffer cause = new StringBuffer();
            cause.append("could not create introduction container using specified class <");
            cause.append(INTRODUCTION_CONTAINER_IMPLEMENTATION_CLASS);
            cause.append(">: ");
            cause.append(e.getMessage());
            throw new RuntimeException(cause.toString());
        }
    }

    public static AdviceContainer createAdviceContainer(AbstractAdvice prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException("advice prototype can not be null");
        }
        try {
            Class klass = ContextClassLoader.loadClass(ADVICE_CONTAINER_IMPLEMENTATION_CLASS);
            Constructor constructor = klass.getConstructor(class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice == null ? (class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice = StartupManager.class$("org.codehaus.aspectwerkz.xmldef.advice.AbstractAdvice")) : class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice);
            return (AdviceContainer)constructor.newInstance(prototype);
        }
        catch (Exception e) {
            StringBuffer cause = new StringBuffer();
            cause.append("could not create advice container using specified class <");
            cause.append(ADVICE_CONTAINER_IMPLEMENTATION_CLASS);
            cause.append(">: ");
            cause.append(e.getMessage());
            throw new RuntimeException(cause.toString());
        }
    }

    private static void createAspects(String uuid, AspectWerkzDefinitionImpl definition) {
        try {
            Iterator it = definition.getAspectDefinitions().iterator();
            while (it.hasNext()) {
                AspectDefinition aspectDefinition = (AspectDefinition)it.next();
                ((XmlDefSystem)SystemLoader.getSystem(uuid)).register(new AspectMetaData(uuid, aspectDefinition.getName()));
            }
        }
        catch (NullPointerException e) {
            throw new DefinitionException("aspects not properly defined");
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void registerIntroductions(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getIntroductionDefinitions().iterator();
        while (it1.hasNext()) {
            StartupManager.registerIntroduction(uuid, (IntroductionDefinition)it1.next());
        }
    }

    private static void registerIntroduction(String uuid, IntroductionDefinition introDef) {
        String implClassName = introDef.getImplementation();
        String intfClassName = introDef.getInterface();
        try {
            Class implClass = null;
            if (implClassName != null) {
                try {
                    implClass = ContextClassLoader.loadClass(implClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(implClassName + " could not be found on classpath");
                }
            }
            Introduction newIntroduction = new Introduction(introDef.getName(), intfClassName, implClass, DeploymentModel.getDeploymentModelAsInt(introDef.getDeploymentModel()));
            IntroductionContainer container = StartupManager.createIntroductionContainer(implClass);
            if (container != null) {
                newIntroduction.setContainer(container);
            }
            ((XmlDefSystem)SystemLoader.getSystem(uuid)).register(introDef.getName(), newIntroduction);
        }
        catch (NullPointerException e) {
            throw new DefinitionException("introduction definitions not properly defined");
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void addIntroductionReferencesToAspects(String uuid, AspectWerkzDefinitionImpl definition) {
        try {
            Iterator it1 = definition.getAspectDefinitions().iterator();
            while (it1.hasNext()) {
                AspectDefinition aspectDef = (AspectDefinition)it1.next();
                List weavingRules = aspectDef.getBindIntroductionRules();
                Iterator it2 = weavingRules.iterator();
                while (it2.hasNext()) {
                    BindIntroductionRule weavingRule = (BindIntroductionRule)it2.next();
                    List introductionRefs = weavingRule.getIntroductionRefs();
                    Iterator it3 = introductionRefs.iterator();
                    while (it3.hasNext()) {
                        IntroductionDefinition def = definition.getIntroductionDefinition((String)it3.next());
                        SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName()).addIntroduction(def.getName());
                    }
                }
            }
        }
        catch (NullPointerException e) {
            throw new DefinitionException("introduction definitions not properly defined");
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void registerAdvices(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAdviceDefinitions().iterator();
        while (it.hasNext()) {
            StartupManager.registerAdvice(uuid, (AdviceDefinition)it.next());
        }
    }

    private static void registerAdvice(String uuid, AdviceDefinition def) {
        String adviceClassName = def.getAdviceClassName();
        String name = def.getName();
        try {
            Class adviceClass = ContextClassLoader.loadClass(adviceClassName);
            AbstractAdvice newAdvice = (AbstractAdvice)adviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            int deploymentModel = def.getDeploymentModel() == null || def.getDeploymentModel().equals("") ? 0 : DeploymentModel.getDeploymentModelAsInt(def.getDeploymentModel());
            Field field = (class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice == null ? (class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice = StartupManager.class$("org.codehaus.aspectwerkz.xmldef.advice.AbstractAdvice")) : class$org$codehaus$aspectwerkz$xmldef$advice$AbstractAdvice).getDeclaredField("m_uuid");
            field.setAccessible(true);
            field.set(newAdvice, uuid);
            newAdvice.setName(def.getName());
            newAdvice.setAdviceClass(adviceClass);
            newAdvice.setDeploymentModel(deploymentModel);
            Iterator it2 = def.getParameters().entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                newAdvice.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
            newAdvice.setContainer(StartupManager.createAdviceContainer(newAdvice));
            ((XmlDefSystem)SystemLoader.getSystem(uuid)).register(name, newAdvice);
        }
        catch (ClassNotFoundException e) {
            throw new DefinitionException(adviceClassName + " could not be found in classpath");
        }
        catch (NoSuchMethodException e) {
            throw new DefinitionException(adviceClassName + " must define a constructor that takes an integer as an argument");
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (NullPointerException e) {
            throw new DefinitionException("advice definitions not properly defined");
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void registerPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        StartupManager.registerCFlowPointcuts(uuid, definition);
        StartupManager.registerExecutionPointcuts(uuid, definition);
        StartupManager.registerCallPointcuts(uuid, definition);
        StartupManager.registerSetPointcuts(uuid, definition);
        StartupManager.registerGetPointcuts(uuid, definition);
        StartupManager.registerThrowsPointcuts(uuid, definition);
    }

    private static void registerExecutionPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            try {
                List bindAdviceRules = aspectDefinition.getBindAdviceRules();
                Iterator it2 = bindAdviceRules.iterator();
                while (it2.hasNext()) {
                    BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                    Expression expression = bindAdviceRule.getExpression();
                    if (!expression.getType().equals(PointcutType.EXECUTION)) continue;
                    ExecutionPointcut pointcut = new ExecutionPointcut(uuid, expression);
                    List adviceRefs = bindAdviceRule.getAdviceRefs();
                    Iterator it3 = adviceRefs.iterator();
                    while (it3.hasNext()) {
                        pointcut.addAdvice((String)it3.next());
                    }
                    List adviceStackRefs = bindAdviceRule.getAdviceStackRefs();
                    Iterator it32 = adviceStackRefs.iterator();
                    while (it32.hasNext()) {
                        AdviceStackDefinition adviceStackDefinition = definition.getAdviceStackDefinition((String)it32.next());
                        List advices = adviceStackDefinition.getAdviceRefs();
                        Iterator it4 = advices.iterator();
                        while (it4.hasNext()) {
                            pointcut.addAdvice((String)it4.next());
                        }
                    }
                    aspect.addExecutionPointcut(pointcut);
                }
            }
            catch (NullPointerException e) {
                throw new DefinitionException("execution pointcuts in aspect <" + aspect.getName() + "> are not properly defined");
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void registerCallPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            try {
                List bindAdviceRules = aspectDefinition.getBindAdviceRules();
                Iterator it2 = bindAdviceRules.iterator();
                while (it2.hasNext()) {
                    BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                    Expression expression = bindAdviceRule.getExpression();
                    if (!expression.getType().equals(PointcutType.CALL)) continue;
                    CallPointcut pointcut = new CallPointcut(uuid, expression);
                    List adviceRefs = bindAdviceRule.getAdviceRefs();
                    Iterator it3 = adviceRefs.iterator();
                    while (it3.hasNext()) {
                        String adviceRef = (String)it3.next();
                        if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                            pointcut.addBeforeAdvice(adviceRef);
                            continue;
                        }
                        if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                        pointcut.addAfterAdvice(adviceRef);
                    }
                    List adviceStackRefs = bindAdviceRule.getAdviceStackRefs();
                    Iterator it32 = adviceStackRefs.iterator();
                    while (it32.hasNext()) {
                        AdviceStackDefinition adviceStackDefinition = definition.getAdviceStackDefinition((String)it32.next());
                        adviceRefs = adviceStackDefinition.getAdviceRefs();
                        Iterator it4 = adviceRefs.iterator();
                        while (it4.hasNext()) {
                            String adviceRef = (String)it4.next();
                            if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                                pointcut.addBeforeAdvice(adviceRef);
                                continue;
                            }
                            if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                            pointcut.addAfterAdvice(adviceRef);
                        }
                    }
                    aspect.addCallPointcut(pointcut);
                }
            }
            catch (NullPointerException e) {
                throw new DefinitionException("call pointcuts in aspect <" + aspect.getName() + "> are not properly defined");
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void registerSetPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            try {
                List bindAdviceRules = aspectDefinition.getBindAdviceRules();
                Iterator it2 = bindAdviceRules.iterator();
                while (it2.hasNext()) {
                    BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                    Expression expression = bindAdviceRule.getExpression();
                    if (!expression.getType().equals(PointcutType.SET)) continue;
                    SetPointcut pointcut = new SetPointcut(uuid, expression);
                    List adviceRefs = bindAdviceRule.getAdviceRefs();
                    Iterator it3 = adviceRefs.iterator();
                    while (it3.hasNext()) {
                        String adviceRef = (String)it3.next();
                        if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                            pointcut.addBeforeAdvice(adviceRef);
                            continue;
                        }
                        if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                        pointcut.addAfterAdvice(adviceRef);
                    }
                    List adviceStackRefs = bindAdviceRule.getAdviceStackRefs();
                    Iterator it32 = adviceStackRefs.iterator();
                    while (it32.hasNext()) {
                        AdviceStackDefinition adviceStackDefinition = definition.getAdviceStackDefinition((String)it32.next());
                        adviceRefs = adviceStackDefinition.getAdviceRefs();
                        Iterator it4 = adviceRefs.iterator();
                        while (it4.hasNext()) {
                            String adviceRef = (String)it4.next();
                            if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                                pointcut.addBeforeAdvice(adviceRef);
                                continue;
                            }
                            if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                            pointcut.addAfterAdvice(adviceRef);
                        }
                    }
                    aspect.addSetPointcut(pointcut);
                }
            }
            catch (NullPointerException e) {
                throw new DefinitionException("set pointcuts in aspect <" + aspect.getName() + "> are not properly defined");
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void registerGetPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            try {
                List bindAdviceRules = aspectDefinition.getBindAdviceRules();
                Iterator it2 = bindAdviceRules.iterator();
                while (it2.hasNext()) {
                    BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                    Expression expression = bindAdviceRule.getExpression();
                    if (!expression.getType().equals(PointcutType.GET)) continue;
                    GetPointcut pointcut = new GetPointcut(uuid, expression);
                    List adviceRefs = bindAdviceRule.getAdviceRefs();
                    Iterator it3 = adviceRefs.iterator();
                    while (it3.hasNext()) {
                        String adviceRef = (String)it3.next();
                        if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                            pointcut.addBeforeAdvice(adviceRef);
                            continue;
                        }
                        if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                        pointcut.addAfterAdvice(adviceRef);
                    }
                    List adviceStackRefs = bindAdviceRule.getAdviceStackRefs();
                    Iterator it32 = adviceStackRefs.iterator();
                    while (it32.hasNext()) {
                        AdviceStackDefinition adviceStackDefinition = definition.getAdviceStackDefinition((String)it32.next());
                        adviceRefs = adviceStackDefinition.getAdviceRefs();
                        Iterator it4 = adviceRefs.iterator();
                        while (it4.hasNext()) {
                            String adviceRef = (String)it4.next();
                            if (((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PreAdvice) {
                                pointcut.addBeforeAdvice(adviceRef);
                                continue;
                            }
                            if (!(((XmlDefSystem)SystemLoader.getSystem(uuid)).getAdvice(adviceRef) instanceof PostAdvice)) continue;
                            pointcut.addAfterAdvice(adviceRef);
                        }
                    }
                    aspect.addGetPointcut(pointcut);
                }
            }
            catch (NullPointerException e) {
                throw new DefinitionException("get pointcuts in aspect <" + aspect.getName() + "> are not properly defined");
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void registerThrowsPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            try {
                List bindAdviceRules = aspectDefinition.getBindAdviceRules();
                Iterator it2 = bindAdviceRules.iterator();
                while (it2.hasNext()) {
                    BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                    Expression expression = bindAdviceRule.getExpression();
                    if (!expression.getType().equals(PointcutType.THROWS)) continue;
                    ThrowsPointcut pointcut = new ThrowsPointcut(uuid, expression);
                    List adviceRefs = bindAdviceRule.getAdviceRefs();
                    Iterator it3 = adviceRefs.iterator();
                    while (it3.hasNext()) {
                        String asdf = (String)it3.next();
                        pointcut.addAdvice(asdf);
                    }
                    List adviceStackRefs = bindAdviceRule.getAdviceStackRefs();
                    Iterator it32 = adviceStackRefs.iterator();
                    while (it32.hasNext()) {
                        AdviceStackDefinition adviceStackDefinition = definition.getAdviceStackDefinition((String)it32.next());
                        List advices = adviceStackDefinition.getAdviceRefs();
                        Iterator it4 = advices.iterator();
                        while (it4.hasNext()) {
                            pointcut.addAdvice((String)it4.next());
                        }
                    }
                    aspect.addThrowsPointcut(pointcut);
                }
            }
            catch (NullPointerException e) {
                throw new DefinitionException("throws pointcuts in aspect <" + aspect.getName() + "> are not properly defined");
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    private static void registerCFlowPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDefinition = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDefinition.getName());
            List bindAdviceRules = aspectDefinition.getBindAdviceRules();
            Iterator it2 = bindAdviceRules.iterator();
            while (it2.hasNext()) {
                BindAdviceRule bindAdviceRule = (BindAdviceRule)it2.next();
                Expression expression = bindAdviceRule.getExpression();
                Iterator it3 = expression.getCflowExpressions().entrySet().iterator();
                while (it3.hasNext()) {
                    AdviceDefinition adviceDef;
                    Map.Entry entry = it3.next();
                    Expression value = (Expression)entry.getValue();
                    if (value instanceof ExpressionExpression) {
                        new Exception("todo").printStackTrace();
                        continue;
                    }
                    PointcutDefinition cflowPointcutDef = aspectDefinition.getPointcutDef(value.getName());
                    CallPointcut pointcut = new CallPointcut(uuid, value);
                    if (!SystemLoader.getSystem(uuid).hasAspect("org$codehaus$aspectwerkz$advice$CFlowPreAdvice")) {
                        adviceDef = CFlowPreAdvice.getDefinition();
                        definition.addAdvice(adviceDef);
                        StartupManager.registerAdvice(uuid, adviceDef);
                    }
                    if (!SystemLoader.getSystem(uuid).hasAspect("org$codehaus$aspectwerkz$advice$CFlowPostAdvice")) {
                        adviceDef = CFlowPostAdvice.getDefinition();
                        definition.addAdvice(adviceDef);
                        StartupManager.registerAdvice(uuid, adviceDef);
                    }
                    pointcut.addPointcutDef(cflowPointcutDef);
                    pointcut.addBeforeAdvice("org$codehaus$aspectwerkz$advice$CFlowPreAdvice");
                    pointcut.addAfterAdvice("org$codehaus$aspectwerkz$advice$CFlowPostAdvice");
                    aspect.addCallPointcut(pointcut);
                    aspect.addMethodToCflowExpressionMap(expression, value);
                }
            }
        }
    }

    private StartupManager() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

