/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.introduction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.xmldef.introduction.IntroductionContainer;

public class DefaultIntroductionContainerStrategy
implements IntroductionContainer {
    protected Object m_perJvm;
    protected Map m_perClass = new HashMap();
    protected Map m_perInstance = new WeakHashMap();
    protected Map m_perThread = new WeakHashMap();
    protected Class m_implClass;
    protected Method[] m_methods = new Method[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultIntroductionContainerStrategy(Class implClass) {
        if (implClass == null) {
            return;
        }
        this.m_implClass = implClass;
        Method[] methodArray = this.m_methods;
        synchronized (this.m_methods) {
            int i;
            Method[] declaredMethods = this.m_implClass.getDeclaredMethods();
            ArrayList<Method> toSort = new ArrayList<Method>();
            for (i = 0; i < declaredMethods.length; ++i) {
                if (declaredMethods[i].getName().startsWith("class$") || declaredMethods[i].getName().startsWith("___AW_getUuid") || declaredMethods[i].getName().startsWith("___AW_getMetaData") || declaredMethods[i].getName().startsWith("___AW_addMetaData") || declaredMethods[i].getName().startsWith("___AW_original_method$_AW_$")) continue;
                toSort.add(declaredMethods[i]);
            }
            Collections.sort(toSort, MethodComparator.getInstance(0));
            this.m_methods = new Method[toSort.size()];
            for (i = 0; i < this.m_methods.length; ++i) {
                Method method = (Method)toSort.get(i);
                method.setAccessible(true);
                this.m_methods[i] = method;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Object invokePerJvm(int methodIndex, Object[] parameters) {
        Object result = null;
        try {
            if (this.m_perJvm == null) {
                this.m_perJvm = this.m_implClass.newInstance();
            }
            result = this.m_methods[methodIndex].invoke(this.m_perJvm, parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokePerClass(Object callingObject, int methodIndex, Object[] parameters) {
        Class<?> callingClass = callingObject.getClass();
        Object result = null;
        try {
            if (!this.m_perClass.containsKey(callingClass)) {
                Map map = this.m_perClass;
                synchronized (map) {
                    this.m_perClass.put(callingClass, this.m_implClass.newInstance());
                }
            }
            result = this.m_methods[methodIndex].invoke(this.m_perClass.get(callingClass), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokePerInstance(Object callingObject, int methodIndex, Object[] parameters) {
        Object result = null;
        try {
            if (!this.m_perInstance.containsKey(callingObject)) {
                Map map = this.m_perInstance;
                synchronized (map) {
                    this.m_perInstance.put(callingObject, this.m_implClass.newInstance());
                }
            }
            result = this.m_methods[methodIndex].invoke(this.m_perInstance.get(callingObject), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokePerThread(int methodIndex, Object[] parameters) {
        Object result;
        try {
            Thread currentThread = Thread.currentThread();
            if (!this.m_perThread.containsKey(currentThread)) {
                Map map = this.m_perThread;
                synchronized (map) {
                    this.m_perThread.put(currentThread, this.m_implClass.newInstance());
                }
            }
            result = this.m_methods[methodIndex].invoke(this.m_perThread.get(currentThread), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapImplementation(Class implClass) {
        if (implClass == null) {
            throw new IllegalArgumentException("implementation class can not be null");
        }
        DefaultIntroductionContainerStrategy defaultIntroductionContainerStrategy = this;
        synchronized (defaultIntroductionContainerStrategy) {
            try {
                this.m_implClass = implClass;
                this.m_methods = this.m_implClass.getDeclaredMethods();
                for (int i = 0; i < this.m_methods.length; ++i) {
                    this.m_methods[i].setAccessible(true);
                }
                this.m_perJvm = null;
                this.m_perClass = new HashMap(this.m_perClass.size());
                this.m_perInstance = new WeakHashMap(this.m_perClass.size());
                this.m_perThread = new WeakHashMap(this.m_perClass.size());
            }
            catch (Exception e) {
                new WrappedRuntimeException(e);
            }
        }
    }

    public ContainerType getContainerType() {
        return ContainerType.TRANSIENT;
    }

    public Method getMethod(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("method index can not be less than 0");
        }
        return this.m_methods[index];
    }

    public Method[] getMethods() {
        return this.m_methods;
    }
}

