/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.introduction;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.Mixin;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.xmldef.introduction.IntroductionContainer;

public class Introduction
implements Serializable,
Mixin {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected String m_name;
    protected final String m_interface;
    protected String m_implementation;
    protected final int m_deploymentModel;
    protected Class m_implClass;
    protected transient IntroductionContainer m_container;

    public Introduction(String name, String anInterface) {
        this(name, anInterface, null, 0);
    }

    public Introduction(String name, String intf, Class implClass, int deploymentModel) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (intf == null) {
            throw new IllegalArgumentException("interface can not be null");
        }
        this.m_name = name;
        this.m_interface = intf;
        this.m_implClass = implClass;
        this.m_deploymentModel = deploymentModel;
        if (implClass != null) {
            this.m_implementation = implClass.getName();
            this.checkIfInterfaceImplementationMatches();
        }
    }

    public Object ___AW_invokeMixin(int methodIndex, Object callingObject) {
        return this.___AW_invokeMixin(methodIndex, EMPTY_OBJECT_ARRAY, callingObject);
    }

    public Object ___AW_invokeMixin(int methodIndex, Object[] parameters, Object callingObject) {
        try {
            Object result = null;
            switch (this.m_deploymentModel) {
                case 0: {
                    result = this.invokePerJvm(methodIndex, parameters);
                    break;
                }
                case 1: {
                    result = this.invokePerClass(callingObject, methodIndex, parameters);
                    break;
                }
                case 2: {
                    result = this.invokePerInstance(callingObject, methodIndex, parameters);
                    break;
                }
                case 3: {
                    result = this.invokePerThread(methodIndex, parameters);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid deployment model: " + this.m_deploymentModel);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public String ___AW_getImplementationClassName() {
        return this.m_implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ___AW_swapImplementation(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        Class clazz = this.m_implClass;
        synchronized (clazz) {
            try {
                this.m_implementation = className;
                this.m_implClass = ContextClassLoader.loadClass(className);
                Class<?>[] interfaces = this.m_implClass.getInterfaces();
                boolean implementsInterface = false;
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].getName().equals(this.m_interface)) continue;
                    implementsInterface = true;
                }
                if (!implementsInterface) {
                    throw new DefinitionException("introduced implementation " + this.m_implementation + " has to implement introduced interface " + this.m_interface);
                }
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        this.m_container.swapImplementation(this.m_implClass);
    }

    public String ___AW_getName() {
        return this.m_name;
    }

    public int ___AW_getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public Method getMethod(int index) {
        return this.m_container.getMethod(index);
    }

    public Method[] getMethods() {
        return this.m_container.getMethods();
    }

    public void setContainer(IntroductionContainer container) {
        this.m_container = container;
    }

    public IntroductionContainer getContainer() {
        return this.m_container;
    }

    public ContainerType getContainerType() {
        return this.m_container.getContainerType();
    }

    private Object invokePerJvm(int methodIndex, Object[] parameters) {
        return this.m_container.invokePerJvm(methodIndex, parameters);
    }

    private Object invokePerClass(Object callingObject, int methodIndex, Object[] parameters) {
        return this.m_container.invokePerClass(callingObject, methodIndex, parameters);
    }

    private Object invokePerInstance(Object callingObject, int methodIndex, Object[] parameters) {
        return this.m_container.invokePerInstance(callingObject, methodIndex, parameters);
    }

    private Object invokePerThread(int methodIndex, Object[] parameters) {
        return this.m_container.invokePerThread(methodIndex, parameters);
    }

    private void checkIfInterfaceImplementationMatches() {
        if (!this.findInterface(this.m_implClass, this.m_interface)) {
            throw new DefinitionException("introduced implementation " + this.m_implementation + " has to implement introduced interface " + this.m_interface);
        }
    }

    private boolean findInterface(Class root, String requiredInterface) {
        Class<?>[] interfaces = root.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> implemented = interfaces[i];
            if (!implemented.getName().equals(requiredInterface) && !this.findInterface(implemented, requiredInterface)) continue;
            return true;
        }
        return false;
    }
}

