/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.xmldef.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AddImplementationTransformer;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.xmldef.definition.AspectWerkzDefinitionImpl;

public class IntroductionTransformer {
    public static void addInterfaceIntroductions(AspectWerkzDefinition definition, ClassGen cg, ConstantPoolGen cpg, Context context) {
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        int[] interfaces = cg.getInterfaces();
        boolean isClassAdvised = false;
        ClassMetaData classMetaData = new ClassMetaData();
        classMetaData.setName(cg.getClassName());
        Iterator it2 = def.getIntroductionNames(classMetaData).iterator();
        while (it2.hasNext()) {
            String introductionName = (String)it2.next();
            String interfaceName = def.getIntroductionInterfaceName(introductionName);
            boolean addInterface = true;
            for (int l = 0; l < interfaces.length; ++l) {
                ConstantClass cc = (ConstantClass)cpg.getConstant(interfaces[l]);
                ConstantUtf8 cu = (ConstantUtf8)cpg.getConstant(cc.getNameIndex());
                if (!IntroductionTransformer.implementsInterface(cu, interfaceName)) continue;
                addInterface = false;
                break;
            }
            if (!addInterface) continue;
            if (interfaceName == null || interfaceName.equals("")) {
                throw new DefinitionException("trying to weave null interface to " + cg.getClassName() + ": definition file is not consistentadd");
            }
            TransformationUtil.addInterfaceToClass(cg, interfaceName);
            isClassAdvised = true;
        }
        if (isClassAdvised) {
            context.markAsAdvised();
        }
    }

    public static void addMethodIntroductions(AspectWerkzDefinition definition, Context context, ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory, AddImplementationTransformer transformer) {
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        boolean isClassAdvised = false;
        ClassMetaData metaData = new ClassMetaData();
        metaData.setName(cg.getClassName());
        Iterator it = def.getIntroductionNames(metaData).iterator();
        while (it.hasNext()) {
            Iterator<Object> it2;
            String introductionName = (String)it.next();
            String introductionImplName = def.getIntroductionImplName(introductionName);
            if (introductionImplName == null) continue;
            int introductionIndex = 0;
            List methodMetaDataList = Collections.synchronizedList(new ArrayList());
            try {
                introductionIndex = def.getIntroductionIndex(introductionName);
                boolean match = false;
                Map metaDataRepository = context.getMetaDataRepository();
                it2 = metaDataRepository.values().iterator();
                block3: while (it2.hasNext() && !match) {
                    Set metaDataSet = (Set)it2.next();
                    Iterator it3 = metaDataSet.iterator();
                    while (it3.hasNext()) {
                        ClassMetaData classMetaData = (ClassMetaData)it3.next();
                        if (!classMetaData.getName().equals(introductionImplName)) continue;
                        methodMetaDataList = classMetaData.getMethods();
                        match = true;
                        continue block3;
                    }
                }
                if (methodMetaDataList == null) {
                    throw new RuntimeException("no meta-data for introduction " + introductionImplName + " could be found in repository");
                }
            }
            catch (Exception e) {
                throw new DefinitionException("trying to weave introduction with null or empty string as name to class " + cg.getClassName() + ": definition file is not consistent");
            }
            if (methodMetaDataList == null) continue;
            ArrayList<MethodMetaData> methodMetaDataListFiltered = new ArrayList<MethodMetaData>();
            Iterator it22 = methodMetaDataList.iterator();
            while (it22.hasNext()) {
                MethodMetaData methodMetaData = (MethodMetaData)it22.next();
                if (methodMetaData.getName().equals("equals") || methodMetaData.getName().equals("hashCode") || methodMetaData.getName().equals("getClass") || methodMetaData.getName().equals("toString") || methodMetaData.getName().equals("wait") || methodMetaData.getName().equals("notify") || methodMetaData.getName().equals("notifyAll") || methodMetaData.getName().equals("___AW_getUuid") || methodMetaData.getName().equals("___AW_getUuid") || methodMetaData.getName().equals("___AW_getMetaData") || methodMetaData.getName().equals("___AW_addMetaData") || methodMetaData.getName().equals("class$") || methodMetaData.getName().startsWith("___AW_original_method$_AW_$")) continue;
                methodMetaDataListFiltered.add(methodMetaData);
            }
            Collections.sort(methodMetaDataListFiltered, MethodComparator.getInstance(2));
            int methodIndex = -1;
            it2 = methodMetaDataListFiltered.iterator();
            while (it2.hasNext()) {
                MethodMetaData methodMetaData = (MethodMetaData)it2.next();
                if (methodMetaData.getReturnType() == null || methodMetaData.getName().equals("<init>")) continue;
                transformer.createProxyMethod(cg, cpg, factory, methodMetaData, introductionIndex, ++methodIndex, def.getUuid());
                isClassAdvised = true;
            }
        }
        if (isClassAdvised) {
            context.markAsAdvised();
        }
    }

    private static boolean implementsInterface(ConstantUtf8 cu, String interfaceName) {
        return cu.getBytes().equals(interfaceName.replace('.', '/'));
    }
}

