/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;
import org.codehaus.aspectwerkz.hook.ClassLoaderPreProcessor;

public class ClassLoaderPreProcessorImpl
implements ClassLoaderPreProcessor {
    public byte[] preProcess(byte[] b) {
        try {
            ClassGen cg = new ClassGen(new ClassParser((InputStream)new ByteArrayInputStream(b), "<generated>").parse());
            String className = cg.getClassName();
            Method[] methods = cg.getMethods();
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            for (int i = 0; i < methods.length; ++i) {
                MethodGen mg = new MethodGen(methods[i], className, cpg);
                InstructionList il = mg.getInstructionList();
                if (il == null) continue;
                for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
                    int index;
                    Instruction ins = ih.getInstruction();
                    if (!(ins instanceof INVOKESPECIAL) && !(ins instanceof INVOKESTATIC) && !(ins instanceof INVOKEVIRTUAL)) continue;
                    InvokeInstruction invokeInst = (InvokeInstruction)ins;
                    String callerSideMethodClassName = invokeInst.getClassName(cpg);
                    String callerSideMethodName = invokeInst.getMethodName(cpg);
                    if (!"java.lang.ClassLoader".equals(callerSideMethodClassName) || !"defineClass0".equals(callerSideMethodName)) continue;
                    Type[] args = invokeInst.getArgumentTypes(cpg);
                    ClassLoaderPreProcessorImpl.assertSupported(args);
                    InstructionHandle ihc = null;
                    if (args.length > 5) {
                        ihc = il.append(ih.getPrev(), (Instruction)InstructionFactory.createStore((Type)args[args.length - 1], (int)(2100 + args.length - 1)));
                        for (index = args.length - 2; index >= 5; --index) {
                            ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)args[index], (int)(2100 + index)));
                        }
                        ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)2016));
                    } else {
                        ihc = il.append(ih.getPrev(), (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)2016));
                    }
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)2015));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)2014));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)2013));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)2012));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2012));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2013));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)2014));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)2015));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2016));
                    ihc = il.append(ihc, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper", "defineClass0Pre", (Type)new ArrayType((Type)Type.BYTE, 1), new Type[]{new ObjectType("java.lang.ClassLoader"), Type.STRING, new ArrayType((Type)Type.BYTE, 1), Type.INT, Type.INT, new ObjectType("java.security.ProtectionDomain")}, (short)184));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)3018));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2012));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)3018));
                    ihc = il.append(ihc, (CompoundInstruction)new PUSH(cpg, 0));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)3018));
                    ihc = il.append(ihc, InstructionConstants.ARRAYLENGTH);
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)2016));
                    if (args.length > 5) {
                        for (index = 5; index < args.length; ++index) {
                            ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)args[index], (int)(2100 + index)));
                        }
                    }
                    ihc = il.append(ihc.getNext(), (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)3020));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)3020));
                }
                mg.setInstructionList(il);
                mg.setMaxLocals();
                mg.setMaxStack();
                methods[i] = mg.getMethod();
            }
            cg.setMethods(methods);
            return cg.getJavaClass().getBytes();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return b;
        }
    }

    public byte[] preProcessCOPY(byte[] b) {
        try {
            ClassGen cg = new ClassGen(new ClassParser((InputStream)new ByteArrayInputStream(b), "<generated>").parse());
            String className = cg.getClassName();
            Method[] methods = cg.getMethods();
            ConstantPoolGen cpg = cg.getConstantPool();
            InstructionFactory factory = new InstructionFactory(cg);
            for (int i = 0; i < methods.length; ++i) {
                MethodGen mg = new MethodGen(methods[i], className, cpg);
                InstructionList il = mg.getInstructionList();
                if (il == null) continue;
                for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
                    Instruction ins = ih.getInstruction();
                    if (!(ins instanceof INVOKESPECIAL) && !(ins instanceof INVOKESTATIC) && !(ins instanceof INVOKEVIRTUAL)) continue;
                    InvokeInstruction invokeInst = (InvokeInstruction)ins;
                    String callerSideMethodClassName = invokeInst.getClassName(cpg);
                    String callerSideMethodName = invokeInst.getMethodName(cpg);
                    if (!"java.lang.ClassLoader".equals(callerSideMethodClassName) || !"defineClass0".equals(callerSideMethodName)) continue;
                    Type[] args = invokeInst.getArgumentTypes(cpg);
                    ClassLoaderPreProcessorImpl.assertSupported(args);
                    System.out.println(invokeInst.consumeStack(cpg));
                    System.out.println(invokeInst.produceStack(cpg));
                    System.out.println(invokeInst.getIndex());
                    InstructionHandle ihc = null;
                    ihc = il.insert(ih, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)16));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)15));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.INT, (int)14));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)13));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)12));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)11));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)12));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)13));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)14));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)15));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)16));
                    ihc = il.append(ihc, (Instruction)factory.createInvoke("org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper", "defineClass0Pre", (Type)new ArrayType((Type)Type.BYTE, 1), new Type[]{new ObjectType("java.lang.ClassLoader"), Type.STRING, new ArrayType((Type)Type.BYTE, 1), Type.INT, Type.INT, new ObjectType("java.security.ProtectionDomain")}, (short)184));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)20));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)11));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)12));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)20));
                    ihc = il.append(ihc, (CompoundInstruction)new PUSH(cpg, 0));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)20));
                    ihc = il.append(ihc, InstructionConstants.ARRAYLENGTH);
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)16));
                    ihc = il.append(ihc.getNext(), (Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)21));
                    ihc = il.append(ihc, (Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)21));
                }
                mg.setInstructionList(il);
                mg.setMaxLocals();
                mg.setMaxStack();
                methods[i] = mg.getMethod();
            }
            cg.setMethods(methods);
            return cg.getJavaClass().getBytes();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return b;
        }
    }

    private static void assertSupported(Type[] args) {
        if (!(args.length >= 5 && args[0].getSignature().equals("Ljava/lang/String;") && args[1].getSignature().equals("[B") && args[2].getSignature().equals("I") && args[3].getSignature().equals("I") && args[4].getSignature().equals("Ljava/security/ProtectionDomain;"))) {
            StringBuffer sign = new StringBuffer("(");
            for (int i = 0; i < args.length; ++i) {
                sign.append(args[i].toString());
                if (i >= args.length - 1) continue;
                sign.append(", ");
            }
            sign.append(")");
            throw new Error("non standard JDK, native call not supported " + sign.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoaderPreProcessorImpl me = new ClassLoaderPreProcessorImpl();
        InputStream is = ClassLoader.getSystemClassLoader().getParent().getResourceAsStream("java/lang/ClassLoader.class");
        byte[] out = me.preProcess(ClassLoaderPatcher.inputStreamToByteArray(is));
        is.close();
        FileOutputStream os = new FileOutputStream("_boot/java/lang/ClassLoader.class");
        ((OutputStream)os).write(out);
        ((OutputStream)os).close();
    }
}

