/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;

public class StdoutPreProcessor
implements ClassPreProcessor {
    private static Map classloaders;
    private static final long stepms = 15000L;
    private static transient long lastPrinted;

    private void log(String s) {
        System.out.println(Thread.currentThread().getName() + ": StdoutPreProcessor: " + s);
    }

    public void initialize(Hashtable hashtable) {
        this.log("initialize");
        this.log("loaded by " + this.getClass().getClassLoader());
        classloaders = Collections.synchronizedMap(new WeakHashMap());
        this.registerClassLoader(this.getClass().getClassLoader(), this.getClass().getName());
    }

    public byte[] preProcess(String klass, byte[] abyte, ClassLoader caller) {
        klass = klass.replace('.', '/') + ".class";
        URL u = caller.getResource(klass);
        this.log("> " + klass + " [" + (u == null ? "?" : u.toString()) + "] [" + caller + "]");
        this.registerClassLoader(caller, klass);
        this.registerSearchPath(caller, klass);
        if (System.currentTimeMillis() > lastPrinted + 15000L) {
            lastPrinted = System.currentTimeMillis();
            this.log("*******************************");
            this.log("size=" + classloaders.size());
            this.dumpHierarchy(null, "");
            this.log("*******************************");
        }
        return abyte;
    }

    private void registerClassLoader(ClassLoader loader, String firstClassLoaded) {
        if (loader != null && !classloaders.containsKey(loader)) {
            this.registerClassLoader(loader.getParent(), loader.getClass().getName());
            this.registerSearchPath(loader.getParent(), loader.getClass().getName());
            URL u = null;
            try {
                Enumeration<URL> ue = loader.getResources("META-INF/MANIFEST.MF");
                if (ue.hasMoreElements()) {
                    this.log("--- in scope for " + loader);
                }
                while (ue.hasMoreElements()) {
                    this.log("--- " + ((Object)ue.nextElement()).toString());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.log("****" + loader + " [" + (u == null ? "?" : u.toString()) + "] [" + firstClassLoaded + ']');
            classloaders.put(loader, new ArrayList());
        }
    }

    private void dumpHierarchy(ClassLoader parent, String depth) {
        ArrayList cl = new ArrayList(classloaders.keySet());
        ClassLoader current = null;
        Iterator i = cl.iterator();
        while (i.hasNext()) {
            current = (ClassLoader)i.next();
            if (current.getParent() != parent) continue;
            this.log(depth + current + '[' + classloaders.get(current));
            List path = (List)classloaders.get(current);
            for (ClassLoader currentParent = current.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
                Iterator us = path.iterator();
                while (us.hasNext()) {
                    URL u = (URL)us.next();
                    if (!((List)classloaders.get(currentParent)).contains(u)) continue;
                    this.log("!!!! duplicate detected for " + u + " in " + current);
                }
            }
            this.dumpHierarchy(current, depth + "  ");
        }
    }

    private void registerSearchPath(ClassLoader loader, String klass) {
        if (loader == null) {
            return;
        }
        String klassFile = klass.replace('.', '/') + ".class";
        URL uKlass = loader.getResource(klassFile);
        if (uKlass == null) {
            return;
        }
        URL uRoot = null;
        int i = uKlass.toString().indexOf(33);
        if (i > 0) {
            try {
                uRoot = new File(uKlass.toString().substring(4, i)).getCanonicalFile().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }
        i = uKlass.toString().indexOf(klassFile);
        try {
            uRoot = new File(uKlass.toString().substring(0, i)).getCanonicalFile().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
            if (!((List)classloaders.get(parent)).contains(uRoot)) continue;
            return;
        }
        List path = (List)classloaders.get(loader);
        if (!path.contains(uRoot)) {
            this.log("adding path " + uRoot + " to " + loader);
            path.add(uRoot);
        }
    }

    public static void main(String[] args) throws Exception {
        URL u = new URL("jar:file:/C:/bea/user_projects/domains/mydomain/myserver/.wlnotdelete/gallery/gallery-rar.jar!/");
        URL u2 = new URL("jar:file:/C:/bea/user_projects/domains/mydomain/./myserver/.wlnotdelete/gallery/gallery-rar.jar!/");
        if (u.sameFile(u2)) {
            System.out.println("same");
        } else {
            System.out.println("differ");
        }
    }

    static {
        lastPrinted = 0L;
    }
}

