/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.extension;

import java.util.List;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.persistence.PersistenceManager;
import org.codehaus.aspectwerkz.extension.persistence.PersistenceManagerException;
import org.codehaus.aspectwerkz.extension.service.ServiceManager;
import org.codehaus.aspectwerkz.extension.service.ServiceType;

public class Registry {
    private static Registry s_soleInstance = new Registry();
    private PersistenceManager m_persistenceManager = (PersistenceManager)ServiceManager.getService(ServiceType.PERSISTENCE_MANAGER);

    public static Object findPersistentObjectByIndex(Class klass, Object index) {
        Object obj = null;
        try {
            obj = Registry.getInstance().m_persistenceManager.retrieve(klass, index);
        }
        catch (PersistenceManagerException e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
        return obj;
    }

    public static List findPersistentObjectsWithinRange(Class klass, Object startIndex, Object endIndex) {
        List objects = null;
        try {
            objects = Registry.getInstance().m_persistenceManager.retrieveAllInRange(klass, startIndex, endIndex);
        }
        catch (PersistenceManagerException e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
        return objects;
    }

    public static void removePersistentObject(Object object) {
        try {
            Registry.getInstance().m_persistenceManager.remove(object);
        }
        catch (PersistenceManagerException e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    private static Registry getInstance() {
        return s_soleInstance;
    }

    private Registry() {
    }
}

