/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.extension.objectfactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.objectfactory.ObjectFactory;

public class DefaultObjectFactory
implements ObjectFactory {
    private Class m_class = null;
    private Constructor m_constructor = null;
    private Object[] m_parameters = null;

    public DefaultObjectFactory(String classname) throws ClassNotFoundException {
        if (classname == null) {
            throw new IllegalArgumentException("classname can not be null");
        }
        this.m_class = ContextClassLoader.loadClass((String)classname);
    }

    public DefaultObjectFactory(String classname, ClassLoader loader) throws ClassNotFoundException {
        if (classname == null || loader == null) {
            throw new IllegalArgumentException("classname or class loader can not be null");
        }
        this.m_class = loader.loadClass(classname);
    }

    public DefaultObjectFactory(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        this.m_class = klass;
    }

    public DefaultObjectFactory(Class klass, Class[] parameterTypes, Object[] parameters) throws NoSuchMethodException {
        if (klass == null || parameterTypes == null || parameters == null) {
            throw new IllegalArgumentException("class, parameter types or parameters can not be null");
        }
        this.m_class = klass;
        this.m_constructor = this.m_class.getConstructor(parameterTypes);
        this.m_parameters = parameters;
    }

    public DefaultObjectFactory(Constructor constructor, Object[] parameters) {
        if (constructor == null || parameters == null) {
            throw new IllegalArgumentException("constructor or parameters can not be null");
        }
        this.m_constructor = constructor;
        this.m_parameters = parameters;
        this.m_class = this.m_constructor.getDeclaringClass();
    }

    public Object newInstance() {
        try {
            if (this.m_parameters == null) {
                return this.runDefaultConstructor();
            }
            return this.runConstructorWithParameters();
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    public Class getCreatedClass() {
        return this.m_class;
    }

    private Object runDefaultConstructor() throws InstantiationException, IllegalAccessException {
        return this.m_class.newInstance();
    }

    private Object runConstructorWithParameters() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.m_constructor.newInstance(this.m_parameters);
    }
}

