/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.extension.persistence.jisp;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.BTreeObjectIterator;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.definition.Definition;
import org.codehaus.aspectwerkz.extension.objectfactory.DefaultObjectFactory;
import org.codehaus.aspectwerkz.extension.persistence.AbstractPersistenceManager;
import org.codehaus.aspectwerkz.extension.persistence.Index;
import org.codehaus.aspectwerkz.extension.persistence.Persistable;
import org.codehaus.aspectwerkz.extension.persistence.PersistenceManager;
import org.codehaus.aspectwerkz.extension.persistence.definition.IndexDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.IndexRefDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceManagerDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistentObjectDefinition;

public class JispPersistenceManager
extends AbstractPersistenceManager
implements Serializable {
    public static final boolean CREATE = true;
    public static final boolean LOAD = false;
    public static final int INDEX_ORDER = 23;
    protected static final PersistenceManager s_soleInstance = new JispPersistenceManager();
    protected IndexedObjectDatabase m_database;
    protected ReadWriteLock m_readWriteLock = new WriterPreferenceReadWriteLock();
    protected Map m_indexes = new HashMap();
    protected Map m_jispIndexes = new HashMap();
    protected Map m_jispIndexTypes = new HashMap();
    protected List m_indexDefinitions = new ArrayList();
    protected String m_databaseName;
    protected String m_databaseUrl = null;
    protected String m_databaseDir = null;
    protected String m_indexDir = null;
    protected boolean m_createNewDbOnStartup = false;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;

    public static PersistenceManager getInstance() {
        return s_soleInstance;
    }

    public synchronized void initialize(ClassLoader loader, Definition definition) {
        if (this.m_initialized) {
            return;
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        this.m_loader = loader;
        this.m_definition = (PersistenceDefinition)definition;
        PersistenceManagerDefinition persistenceManagerDef = null;
        Iterator it = this.m_definition.getPersistenceManagers().iterator();
        while (it.hasNext()) {
            PersistenceManagerDefinition def = (PersistenceManagerDefinition)it.next();
            if (!def.getClassName().equals(this.getClass().getName())) continue;
            persistenceManagerDef = def;
            break;
        }
        if (persistenceManagerDef == null) {
            throw new RuntimeException("no definition specified for persistence manager: " + this.getClass().getName());
        }
        this.m_indexDefinitions = this.getIndexes(persistenceManagerDef);
        if (this.m_indexDefinitions.size() == 0) {
            throw new RuntimeException("no indexes specified for persistence manager");
        }
        Properties properties = persistenceManagerDef.getProperties();
        this.m_databaseDir = properties.getProperty("databaseDir");
        this.m_databaseName = properties.getProperty("databaseName");
        this.m_indexDir = properties.getProperty("indexDir");
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_databaseDir);
        buf.append(File.separator);
        buf.append(this.m_databaseName);
        this.m_databaseUrl = buf.toString();
        File db = new File(this.m_databaseUrl);
        if (this.m_createNewDbOnStartup || !db.exists()) {
            JispPersistenceManager.createDatabaseDir(this.m_databaseDir);
            this.createDatabase(db, this.m_indexDefinitions);
        } else {
            this.loadDatabase(this.m_indexDefinitions);
        }
        this.loadDomainObjectConfigurations(this.m_definition);
        this.m_indexes = Collections.unmodifiableMap(this.m_indexes);
        this.m_jispIndexes = Collections.unmodifiableMap(this.m_jispIndexes);
        this.m_jispIndexTypes = Collections.unmodifiableMap(this.m_jispIndexTypes);
        this.m_initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object obj) {
        if (this.notInitialized()) {
            throw new IllegalStateException("persistence manager is not initialized");
        }
        if (obj == null) {
            throw new IllegalArgumentException("object to store can not be null");
        }
        if (!(obj instanceof Persistable)) {
            throw new IllegalArgumentException("object to store does not implement Persistable");
        }
        Class<?> klass = obj.getClass();
        List keys = (List)this.m_indexes.get(klass.getName());
        KeyObject[] keyArray = new KeyObject[this.m_indexDefinitions.size()];
        int i = 0;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            try {
                Index index = (Index)it.next();
                Method method = index.getMethod();
                Class indexFieldType = index.getFieldType();
                Class indexType = (Class)this.m_jispIndexTypes.get(index.getIndexName());
                Object indexFieldValue = method.invoke(obj, new Object[0]);
                DefaultObjectFactory factory = new DefaultObjectFactory(indexType, new Class[]{indexFieldType}, new Object[]{indexFieldValue});
                keyArray[i] = (KeyObject)factory.newInstance();
            }
            catch (Exception e) {
                throw new WrappedRuntimeException((Throwable)e);
            }
            ++i;
        }
        while (i < this.m_indexDefinitions.size()) {
            keyArray[i] = keyArray[0].makeNullKey();
            ++i;
        }
        try {
            this.m_readWriteLock.writeLock().acquire();
            try {
                this.m_database.write(keyArray, (Serializable)((Persistable)obj));
            }
            finally {
                this.m_readWriteLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            this.notifyAll();
            Thread.currentThread().interrupt();
            throw new WrappedRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieve(Class klass, Object key) {
        if (this.notInitialized()) {
            throw new IllegalStateException("persistence manager is not initialized");
        }
        if (klass == null || key == null) {
            throw new IllegalArgumentException("class or index can not be null");
        }
        List indexes = (List)this.m_indexes.get(klass.getName());
        String indexName = null;
        Iterator it = indexes.iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.getFieldType() != key.getClass()) continue;
            indexName = index.getIndexName();
        }
        if (indexName == null) {
            throw new RuntimeException("no such index for class specified");
        }
        ObjectIndex index = (ObjectIndex)this.m_jispIndexes.get(indexName);
        Class indexType = (Class)this.m_jispIndexTypes.get(indexName);
        Object obj = null;
        try {
            DefaultObjectFactory factory = new DefaultObjectFactory(indexType, new Class[]{key.getClass()}, new Object[]{key});
            this.m_readWriteLock.readLock().acquire();
            try {
                obj = this.m_database.read((KeyObject)factory.newInstance(), index, this.m_loader);
            }
            finally {
                this.m_readWriteLock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            this.notifyAll();
            Thread.currentThread().interrupt();
            throw new WrappedRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveAllInRange(Class klass, Object from, Object to) {
        if (this.notInitialized()) {
            throw new IllegalStateException("persistence manager is not initialized");
        }
        if (!(from instanceof Comparable) || !(to instanceof Comparable)) {
            throw new RuntimeException("from A to index must implement the Comparable interface");
        }
        if (!from.getClass().equals(to.getClass())) {
            throw new RuntimeException("from A to index must be of the same type");
        }
        ArrayList<Object> col = new ArrayList<Object>();
        List keys = (List)this.m_indexes.get(klass.getName());
        String indexNameFrom = null;
        String indexNameTo = null;
        Method keyMethodTo = null;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.getFieldType() == from.getClass()) {
                indexNameFrom = index.getIndexName();
            }
            if (index.getFieldType() != to.getClass()) continue;
            indexNameTo = index.getIndexName();
            keyMethodTo = index.getMethod();
        }
        if (indexNameFrom == null || indexNameTo == null) {
            throw new RuntimeException("no such index for class specified");
        }
        ObjectIndex indexFrom = (ObjectIndex)this.m_jispIndexes.get(indexNameFrom);
        ObjectIndex indexTo = (ObjectIndex)this.m_jispIndexes.get(indexNameTo);
        Class indexTypeFrom = (Class)this.m_jispIndexTypes.get(indexNameFrom);
        Class indexTypeTo = (Class)this.m_jispIndexTypes.get(indexNameTo);
        if (!(indexFrom instanceof BTreeIndex) || !(indexTo instanceof BTreeIndex)) {
            throw new RuntimeException("from A to index must both be of type BTreeIndex");
        }
        if (!indexTypeFrom.equals(indexTypeTo)) {
            throw new RuntimeException("from A to index must be of the same index type");
        }
        try {
            DefaultObjectFactory fromFactory = new DefaultObjectFactory(indexTypeFrom, new Class[]{from.getClass()}, new Object[]{from});
            this.m_readWriteLock.readLock().acquire();
            try {
                Object item;
                BTreeObjectIterator iterator = this.m_database.createIterator((BTreeIndex)indexFrom);
                if (!iterator.moveTo((KeyObject)fromFactory.newInstance())) {
                    throw new RuntimeException("record " + from + " does not exist");
                }
                while ((item = iterator.getObject()) != null) {
                    col.add(item);
                    Object keyFieldValue = keyMethodTo.invoke(item, new Object[0]);
                    if (((Comparable)keyFieldValue).compareTo(to) == 0) {
                    } else if (iterator.moveNext()) continue;
                    break;
                }
            }
            finally {
                this.m_readWriteLock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            this.notifyAll();
            Thread.currentThread().interrupt();
            throw new WrappedRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object obj) {
        if (this.notInitialized()) {
            throw new IllegalStateException("persistence manager is not initialized");
        }
        if (obj == null) {
            throw new IllegalArgumentException("object to remove can not be null");
        }
        if (!(obj instanceof Persistable)) {
            throw new IllegalArgumentException("object to remove does not implement Persistable");
        }
        Class<?> klass = obj.getClass();
        List keys = this.getKeysForPersistentObject(klass);
        KeyObject[] keyArray = new KeyObject[keys.size()];
        int i = 0;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            try {
                Index index = (Index)it.next();
                Method method = index.getMethod();
                Class indexFieldType = index.getFieldType();
                Class indexType = (Class)this.m_jispIndexTypes.get(index.getIndexName());
                Object indexFieldValue = method.invoke(obj, new Object[0]);
                DefaultObjectFactory factory = new DefaultObjectFactory(indexType, new Class[]{indexFieldType}, new Object[]{indexFieldValue});
                keyArray[i] = (KeyObject)factory.newInstance();
            }
            catch (Exception e) {
                throw new WrappedRuntimeException((Throwable)e);
            }
            ++i;
        }
        try {
            this.m_readWriteLock.writeLock().acquire();
            try {
                this.m_database.remove(keyArray);
            }
            finally {
                this.m_readWriteLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            this.notifyAll();
            Thread.currentThread().interrupt();
            throw new WrappedRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    protected List getIndexes(PersistenceManagerDefinition persistenceManagerDef) {
        ArrayList<IndexDefinition> btreeIndexes = new ArrayList<IndexDefinition>();
        List indexRefDefinitions = persistenceManagerDef.getIndexRefs();
        Iterator it = indexRefDefinitions.iterator();
        while (it.hasNext()) {
            String indexName = ((IndexRefDefinition)it.next()).getName();
            List indexDefinitions = this.m_definition.getIndexes();
            Iterator it2 = indexDefinitions.iterator();
            while (it2.hasNext()) {
                IndexDefinition indexDefinition = (IndexDefinition)it2.next();
                if (!indexDefinition.getName().equals(indexName)) continue;
                btreeIndexes.add(indexDefinition);
            }
        }
        return btreeIndexes;
    }

    protected void loadDomainObjectConfigurations(PersistenceDefinition def) {
        if (def == null) {
            throw new IllegalArgumentException("persistence definition can not be null");
        }
        List persistentObjectDefs = def.getPersistentObjects();
        Iterator it1 = persistentObjectDefs.iterator();
        while (it1.hasNext()) {
            PersistentObjectDefinition persistentObjectDef = (PersistentObjectDefinition)it1.next();
            List indexRefs = persistentObjectDef.getIndexRefs();
            String persistentObjectTypeName = persistentObjectDef.getClassName();
            if (indexRefs.size() == 0) {
                throw new RuntimeException("no indexes specified for persistent object: " + persistentObjectTypeName);
            }
            Class<?> persistentObjectType = null;
            try {
                persistentObjectType = this.m_loader.loadClass(persistentObjectTypeName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            this.m_indexes.put(persistentObjectTypeName, new ArrayList());
            Iterator it2 = indexRefs.iterator();
            while (it2.hasNext()) {
                IndexRefDefinition index = (IndexRefDefinition)it2.next();
                String indexName = index.getName();
                String indexMethodName = index.getMethod();
                try {
                    Method method = persistentObjectType.getDeclaredMethod(indexMethodName, new Class[0]);
                    Class indexFieldType = method.getReturnType();
                    if (indexFieldType.getName().equals(Long.TYPE.getName())) {
                        indexFieldType = class$java$lang$Long == null ? JispPersistenceManager.class$("java.lang.Long") : class$java$lang$Long;
                    } else if (indexFieldType.getName().equals(Integer.TYPE.getName())) {
                        indexFieldType = class$java$lang$Integer == null ? JispPersistenceManager.class$("java.lang.Integer") : class$java$lang$Integer;
                    } else if (indexFieldType.getName().equals(Double.TYPE.getName())) {
                        indexFieldType = class$java$lang$Double == null ? JispPersistenceManager.class$("java.lang.Double") : class$java$lang$Double;
                    } else if (indexFieldType.getName().equals(Float.TYPE.getName())) {
                        indexFieldType = class$java$lang$Float == null ? JispPersistenceManager.class$("java.lang.Float") : class$java$lang$Float;
                    } else if (indexFieldType.getName().equals(Short.TYPE.getName())) {
                        indexFieldType = class$java$lang$Short == null ? JispPersistenceManager.class$("java.lang.Short") : class$java$lang$Short;
                    } else if (indexFieldType.getName().equals(Boolean.TYPE.getName())) {
                        throw new RuntimeException("index field can not be boolean");
                    }
                    ((List)this.m_indexes.get(persistentObjectTypeName)).add(new Index(method, indexFieldType, indexName));
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException((Throwable)e);
                }
            }
        }
    }

    protected void createDatabase(File db, List btreeIndexes) {
        if (db == null || btreeIndexes == null) {
            throw new IllegalArgumentException("db or index definition can not be null");
        }
        try {
            if (db.exists()) {
                db.delete();
            }
            this.m_database = new IndexedObjectDatabase(this.m_databaseUrl, true, this.m_loader);
            List indexes = this.createBtreeIndexes(btreeIndexes);
            Iterator it = indexes.iterator();
            while (it.hasNext()) {
                this.m_database.attachIndex((ObjectIndex)((BTreeIndex)it.next()));
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    protected void loadDatabase(List btreeIndexes) {
        if (btreeIndexes == null) {
            throw new IllegalArgumentException("index definition can not be null");
        }
        try {
            this.m_database = new IndexedObjectDatabase(this.m_databaseUrl, false, this.m_loader);
            List indexes = this.loadBtreeIndexes(btreeIndexes);
            Iterator it = indexes.iterator();
            while (it.hasNext()) {
                this.m_database.attachIndex((ObjectIndex)((BTreeIndex)it.next()));
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    protected List createBtreeIndexes(List btreeIndexes) throws ClassNotFoundException, IOException {
        if (btreeIndexes == null) {
            throw new IllegalArgumentException("index configurations can not be null");
        }
        ArrayList<BTreeIndex> indexes = new ArrayList<BTreeIndex>();
        Iterator it = btreeIndexes.iterator();
        while (it.hasNext()) {
            IndexDefinition indexDef = (IndexDefinition)it.next();
            String jispIndexType = JispPersistenceManager.getJispIndexType(indexDef.getType());
            DefaultObjectFactory factory = new DefaultObjectFactory(jispIndexType);
            StringBuffer indexFile = new StringBuffer();
            indexFile.append(this.m_indexDir);
            indexFile.append(File.separator);
            indexFile.append(indexDef.getName());
            File killit = new File(indexFile.toString());
            if (killit.exists()) {
                killit.delete();
            }
            BTreeIndex index = new BTreeIndex(indexFile.toString(), 23, (KeyObject)factory.newInstance(), false, this.m_loader);
            indexes.add(index);
            this.m_jispIndexes.put(indexDef.getName(), index);
            Class<?> indexType = this.m_loader.loadClass(JispPersistenceManager.getJispIndexType(indexDef.getType()));
            this.m_jispIndexTypes.put(indexDef.getName(), indexType);
        }
        return indexes;
    }

    protected List loadBtreeIndexes(List btreeIndexes) throws ClassNotFoundException, IOException {
        if (btreeIndexes == null) {
            throw new IllegalArgumentException("index configurations can not be null");
        }
        ArrayList<BTreeIndex> indexes = new ArrayList<BTreeIndex>();
        Iterator it = btreeIndexes.iterator();
        while (it.hasNext()) {
            IndexDefinition indexDef = (IndexDefinition)it.next();
            StringBuffer indexFile = new StringBuffer();
            indexFile.append(this.m_databaseDir);
            indexFile.append(File.separator);
            indexFile.append(indexDef.getName());
            BTreeIndex index = new BTreeIndex(indexFile.toString(), this.m_loader);
            indexes.add(index);
            this.m_jispIndexes.put(indexDef.getName(), index);
            Class<?> indexType = this.m_loader.loadClass(JispPersistenceManager.getJispIndexType(indexDef.getType()));
            this.m_jispIndexTypes.put(indexDef.getName(), indexType);
        }
        return indexes;
    }

    /*
     * WARNING - void declaration
     */
    protected static String getJispIndexType(String type) {
        void var1_1;
        String indexType;
        if (type.equals("java.lang.String")) {
            indexType = "com.coyotegulch.jisp.StringKey32";
        } else if (type.equals("java.lang.Long")) {
            indexType = "org.codehaus.aspectwerkz.extension.persistence.jisp.LongKey";
        } else {
            throw new RuntimeException(type + " is not a valid JISP index type");
        }
        return var1_1;
    }

    protected List getKeysForPersistentObject(Class klass) {
        return (List)this.m_indexes.get(klass.getName());
    }

    protected static void createDatabaseDir(String databaseDir) {
        File dir = new File(databaseDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("could not create directory " + databaseDir);
        }
    }

    protected JispPersistenceManager() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

