/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.extension.persistence;

import java.io.File;
import java.util.Iterator;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.persistence.definition.IndexDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.IndexRefDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.ParameterDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceManagerDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistentObjectDefinition;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PersistenceDefinitionParser {
    private static PersistenceDefinition s_definition;

    public static PersistenceDefinition parse(File definitionFile) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(definitionFile.toURL());
            return PersistenceDefinitionParser.parseDocument(document);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    private static PersistenceDefinition parseDocument(Document document) {
        PersistenceDefinition definition = new PersistenceDefinition();
        Element root = document.getRootElement();
        PersistenceDefinitionParser.parseIndexElements(root, definition);
        PersistenceDefinitionParser.parsePersistenceManagerElements(root, definition);
        PersistenceDefinitionParser.parsePersistentElements(root, definition);
        return definition;
    }

    private static void parseIndexElements(Element root, PersistenceDefinition definition) {
        Iterator it1 = root.elementIterator("index");
        while (it1.hasNext()) {
            IndexDefinition indexDef = new IndexDefinition();
            Element introduction = (Element)it1.next();
            Iterator it2 = introduction.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equals("name")) {
                    indexDef.setName(value);
                    continue;
                }
                if (!name.equals("type")) continue;
                indexDef.setType(value);
            }
            definition.addIndex(indexDef);
        }
    }

    private static void parsePersistenceManagerElements(Element root, PersistenceDefinition definition) {
        Iterator it1 = root.elementIterator("persistence-manager");
        while (it1.hasNext()) {
            PersistenceManagerDefinition pmDef = new PersistenceManagerDefinition();
            Element pm = (Element)it1.next();
            Iterator it2 = pm.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equals("class")) {
                    pmDef.setClassName(value);
                    continue;
                }
                if (!name.equals("active")) continue;
                pmDef.setActive(value);
            }
            Iterator it22 = pm.elementIterator();
            while (it22.hasNext()) {
                Element nestedAdviceElement = (Element)it22.next();
                if (nestedAdviceElement.getName().trim().equals("index-ref")) {
                    IndexRefDefinition indexDef = new IndexRefDefinition();
                    indexDef.setName(nestedAdviceElement.attributeValue("name"));
                    pmDef.addIndexRef(indexDef);
                    continue;
                }
                if (!nestedAdviceElement.getName().trim().equals("param")) continue;
                ParameterDefinition paramDef = new ParameterDefinition();
                paramDef.setName(nestedAdviceElement.attributeValue("name"));
                paramDef.setValue(nestedAdviceElement.getText());
                pmDef.addParameter(paramDef);
            }
            definition.addPersistenceManager(pmDef);
        }
    }

    private static void parsePersistentElements(Element root, PersistenceDefinition definition) {
        Iterator it1 = root.elementIterator("persistent");
        while (it1.hasNext()) {
            PersistentObjectDefinition persistentDef = new PersistentObjectDefinition();
            Element persistent = (Element)it1.next();
            Iterator it2 = persistent.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (!name.equals("class")) continue;
                persistentDef.setClassName(value);
            }
            Iterator it22 = persistent.elementIterator();
            while (it22.hasNext()) {
                Element nestedAdviceElement = (Element)it22.next();
                if (!nestedAdviceElement.getName().trim().equals("index-ref")) continue;
                IndexRefDefinition indexDef = new IndexRefDefinition();
                indexDef.setName(nestedAdviceElement.attributeValue("name"));
                indexDef.setMethod(nestedAdviceElement.attributeValue("method"));
                persistentDef.addIndexRef(indexDef);
            }
            definition.addPersistentObject(persistentDef);
        }
    }
}

