/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.extension.service;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.extension.definition.Definition;
import org.codehaus.aspectwerkz.extension.persistence.PersistenceDefinitionParser;
import org.codehaus.aspectwerkz.extension.persistence.PersistenceManager;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceDefinition;
import org.codehaus.aspectwerkz.extension.persistence.definition.PersistenceManagerDefinition;
import org.codehaus.aspectwerkz.extension.service.Service;
import org.codehaus.aspectwerkz.extension.service.ServiceType;

public class ServiceManager {
    public static final String PERSISTENCE_DEFINITION = System.getProperty("aspectwerkz.extension.persistence.definition.file", null);
    protected static final ServiceManager s_soleInstance = new ServiceManager();
    protected ClassLoader m_loader = Thread.currentThread().getContextClassLoader();
    protected static boolean m_isRunning = false;
    protected PersistenceManager m_persistenceManager;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$extension$definition$Definition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        ServiceManager serviceManager = ServiceManager.getInstance();
        synchronized (serviceManager) {
            ServiceManager.getInstance();
            if (ServiceManager.isRunning()) {
                return;
            }
            ServiceManager.getInstance().startPersistenceManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ServiceManager serviceManager = ServiceManager.getInstance();
        synchronized (serviceManager) {
            ServiceManager.getInstance();
            if (ServiceManager.isRunning()) {
                // empty if block
            }
        }
    }

    public static Service getService(ServiceType type) {
        if (type.equals(ServiceType.PERSISTENCE_MANAGER)) {
            return ServiceManager.getInstance().m_persistenceManager;
        }
        throw new RuntimeException("no such service: " + type.toString());
    }

    public static boolean isRunning() {
        ServiceManager.getInstance();
        return m_isRunning;
    }

    protected void startPersistenceManager() {
        PersistenceDefinition persistenceDefinition = PersistenceDefinitionParser.parse(new File(PERSISTENCE_DEFINITION));
        List persistenceManagers = persistenceDefinition.getPersistenceManagers();
        Iterator it = persistenceManagers.iterator();
        while (it.hasNext()) {
            PersistenceManagerDefinition manager = (PersistenceManagerDefinition)it.next();
            if (!manager.isActive()) continue;
            this.m_persistenceManager = (PersistenceManager)ServiceManager.startService(this.m_loader, manager.getClassName(), persistenceDefinition);
            break;
        }
    }

    protected static Service startService(ClassLoader loader, String className, Definition definition) {
        try {
            Class<?> klass = loader.loadClass(className);
            Method getInstance = klass.getMethod("getInstance", new Class[0]);
            Object service = getInstance.invoke(null, new Object[0]);
            Method initialize = klass.getMethod("initialize", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ServiceManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$org$codehaus$aspectwerkz$extension$definition$Definition == null ? (class$org$codehaus$aspectwerkz$extension$definition$Definition = ServiceManager.class$("org.codehaus.aspectwerkz.extension.definition.Definition")) : class$org$codehaus$aspectwerkz$extension$definition$Definition);
            initialize.invoke(service, loader, definition);
            return (Service)service;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    protected static ServiceManager getInstance() {
        return s_soleInstance;
    }

    protected ServiceManager() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

