/*
 * Decompiled with CFR 0.152.
 */
package com.karneim.util.collection.automaton;

import com.karneim.util.collection.automaton.IProperties;
import com.karneim.util.collection.set.ISet_char;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class Automaton
implements Cloneable {
    protected static final int TRUE = 1;
    protected static final int FALSE = 0;
    protected static final int UNKNOWN = -1;
    private static int currentAutomatonNr;
    protected LinkedList listeners = null;
    protected State startState = null;
    protected LinkedSet_State aStates = new LinkedSet_State();
    protected int isDeterministic = 1;
    protected int automatonNr = currentAutomatonNr++;
    protected int currentStateNr = 0;

    protected void addChangedListener(IChangedListener iChangedListener) {
        if (iChangedListener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(iChangedListener);
    }

    protected boolean removeChangedListener(IChangedListener iChangedListener) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            for (int i = this.listeners.size(); i > 0; --i) {
                if (iChangedListener != iterator.next()) continue;
                if (this.listeners.size() > 1) {
                    iterator.remove();
                } else {
                    this.listeners = null;
                }
                return true;
            }
        }
        return false;
    }

    protected abstract LinkedSet_State newLinkedSet_State();

    protected abstract LinkedSet_State newLinkedSet_State(State var1);

    protected State createState() {
        return new State();
    }

    protected void setDeterminstic(Boolean bl) {
        if (bl == null) {
            this.isDeterministic = -1;
        }
        this.isDeterministic = bl != false ? 1 : 0;
    }

    protected boolean isDeterministic() {
        if (this.startState == null || this.isDeterministic(this.startState)) {
            this.isDeterministic = 1;
            return true;
        }
        this.isDeterministic = 0;
        return false;
    }

    protected boolean isDeterministic(State state) {
        LinkedSet_State linkedSet_State = new LinkedSet_State(state);
        Wrapper_State wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            if (wrapper_State.state.eTransitions != null || !wrapper_State.state.isDeterministic()) {
                return false;
            }
            State.Transition transition = wrapper_State.state.transitions;
            while (transition != null) {
                linkedSet_State.add(transition.toState);
                transition = transition.next;
            }
            wrapper_State = wrapper_State.next;
        }
        return true;
    }

    protected State addState() {
        State state = this.createState();
        this.addState(state);
        return state;
    }

    protected void setStartState(State state) {
        if (state == this.startState) {
            return;
        }
        if (state != null) {
            if (state.parent() != this) {
                throw new IllegalArgumentException("startState.parent()!=this");
            }
            if (!this.aStates.contains(state)) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("this.states.contains(startState=").append(state).append(")==false"))));
            }
        }
        State state2 = this.startState;
        this.startState = state;
        this.isDeterministic = -1;
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            for (int i = this.listeners.size(); i > 0; --i) {
                ((IChangedListener)iterator.next()).startStateChanged(state2, state);
            }
        }
    }

    protected State getStartState() {
        return this.startState;
    }

    protected void addState(State state) {
        if (state.parent() != this) {
            throw new IllegalArgumentException("state.parent()!=this");
        }
        this.aStates.add(state);
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            for (int i = this.listeners.size(); i > 0; --i) {
                ((IChangedListener)iterator.next()).stateAdded(state);
            }
        }
    }

    protected boolean removeState(State state) {
        if (state.parent() != this) {
            throw new IllegalArgumentException("removeState.parent()!=this");
        }
        if (this.startState == state) {
            this.setStartState(null);
        }
        Object object = this.aStates.elements;
        while (object != null) {
            if (((Wrapper_State)object).state != state) {
                State.Transition transition = ((Wrapper_State)object).state.transitions;
                while (transition != null) {
                    if (transition.toState == state) {
                        ((Wrapper_State)object).state.removeTransition(transition);
                    }
                    transition = transition.next;
                }
                transition = ((Wrapper_State)object).state.eTransitions;
                while (transition != null) {
                    if (transition.toState == state) {
                        ((Wrapper_State)object).state.removeTransition(transition);
                    }
                    transition = transition.next;
                }
            }
            object = ((Wrapper_State)object).next;
        }
        if (!this.aStates.remove(state)) {
            return false;
        }
        if (this.listeners != null) {
            object = this.listeners.iterator();
            for (int i = this.listeners.size(); i > 0; --i) {
                ((IChangedListener)object.next()).stateRemoved(state);
            }
        }
        return true;
    }

    protected void removeUnreachableStates() {
        if (this.startState == null) {
            return;
        }
        LinkedSet_State linkedSet_State = this.startState.getAllReachableStates();
        linkedSet_State.add(this.startState);
        Wrapper_State wrapper_State = this.aStates.elements;
        while (wrapper_State != null) {
            if (!linkedSet_State.contains(wrapper_State.state)) {
                this.removeState(wrapper_State.state);
            }
            wrapper_State = wrapper_State.next;
        }
    }

    protected void clear() {
        Wrapper_State wrapper_State = this.aStates.elements;
        while (wrapper_State != null) {
            this.removeState(wrapper_State.state);
            wrapper_State = wrapper_State.next;
        }
    }

    protected Map cloneState(State state) {
        Object object;
        HashMap<State, State> hashMap = new HashMap<State, State>();
        LinkedSet_State linkedSet_State = new LinkedSet_State(state);
        Wrapper_State wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            object = wrapper_State.state.eTransitions;
            while (object != null) {
                linkedSet_State.add(((State.Transition)object).toState);
                object = ((State.Transition)object).next;
            }
            object = wrapper_State.state.transitions;
            while (object != null) {
                linkedSet_State.add(((State.Transition)object).toState);
                object = ((State.Transition)object).next;
            }
            hashMap.put(wrapper_State.state, this.addState());
            wrapper_State = wrapper_State.next;
        }
        wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            object = (State)hashMap.get(wrapper_State.state);
            State.Transition transition = wrapper_State.state.eTransitions;
            while (transition != null) {
                if (transition.properties == null) {
                    ((State)object).addTransition(null, null, (State)hashMap.get(transition.toState));
                } else {
                    ((State)object).addTransition((IProperties)transition.properties.clone(), null, (State)hashMap.get(transition.toState));
                }
                transition = transition.next;
            }
            transition = wrapper_State.state.transitions;
            while (transition != null) {
                if (transition.properties == null) {
                    ((State)object).addTransition(null, (ISet_char)transition.charSet.clone(), (State)hashMap.get(transition.toState));
                } else {
                    ((State)object).addTransition((IProperties)transition.properties.clone(), (ISet_char)transition.charSet.clone(), (State)hashMap.get(transition.toState));
                }
                transition = transition.next;
            }
            wrapper_State = wrapper_State.next;
        }
        return hashMap;
    }

    protected Map cloneStates(LinkedSet_State linkedSet_State) {
        HashMap<State, State> hashMap = new HashMap<State, State>();
        Wrapper_State wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            hashMap.put(wrapper_State.state, this.addState());
            wrapper_State = wrapper_State.next;
        }
        wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            State state = (State)hashMap.get(wrapper_State.state);
            State.Transition transition = wrapper_State.state.eTransitions;
            while (transition != null) {
                if (transition.properties == null) {
                    state.addTransition(null, null, (State)hashMap.get(transition.toState));
                } else {
                    state.addTransition((IProperties)transition.properties.clone(), null, (State)hashMap.get(transition.toState));
                }
                transition = transition.next;
            }
            transition = wrapper_State.state.transitions;
            while (transition != null) {
                if (transition.properties == null) {
                    state.addTransition(null, (ISet_char)transition.charSet.clone(), (State)hashMap.get(transition.toState));
                } else {
                    state.addTransition((IProperties)transition.properties.clone(), (ISet_char)transition.charSet.clone(), (State)hashMap.get(transition.toState));
                }
                transition = transition.next;
            }
            wrapper_State = wrapper_State.next;
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Wrapper_State wrapper_State = this.aStates.elements;
        while (wrapper_State != null) {
            stringBuffer.append("  \n").append(wrapper_State.state);
            if (wrapper_State.state == this.startState) {
                stringBuffer.append('+');
            }
            State.Transition transition = wrapper_State.state.eTransitions;
            while (transition != null) {
                stringBuffer.append("    \n  -");
                if (transition.properties != null) {
                    stringBuffer.append(transition.properties).append(": ");
                }
                stringBuffer.append("-> ").append(transition.toState);
                transition = transition.next;
            }
            transition = wrapper_State.state.transitions;
            while (transition != null) {
                stringBuffer.append("    \n  -");
                if (transition.properties != null) {
                    stringBuffer.append(transition.properties).append(": ");
                }
                stringBuffer.append(transition.charSet).append("-> ").append(transition.toState);
                transition = transition.next;
            }
            wrapper_State = wrapper_State.next;
        }
        return stringBuffer.toString();
    }

    protected Object clone() {
        try {
            Automaton automaton = (Automaton)super.clone();
            automaton.automatonNr = currentAutomatonNr++;
            automaton.currentStateNr = 0;
            automaton.startState = null;
            automaton.listeners = null;
            automaton.aStates = automaton.newLinkedSet_State();
            Map map = automaton.cloneStates(this.aStates);
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            for (int i = set.size(); i > 0; --i) {
                State state = (State)iterator.next();
                State state2 = (State)map.get(state);
                state2.stateNr = state.stateNr;
                if (automaton.currentStateNr > state2.stateNr) continue;
                automaton.currentStateNr = state2.stateNr + 1;
            }
            if (this.startState != null) {
                automaton.setStartState((State)map.get(this.startState));
            }
            Automaton automaton2 = automaton;
            return automaton2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    static {
        TRUE = 1;
        FALSE = 0;
        UNKNOWN = -1;
        currentAutomatonNr = 0;
    }

    public class LinkedSet_State
    implements IState {
        public Wrapper_State elements = null;
        protected Wrapper_State lastElement = null;
        transient int size = 0;
        transient int hashCode = 0;
        transient boolean hashCodeIsValid = true;

        public LinkedSet_State() {
        }

        public LinkedSet_State(State state) {
            this.add(state);
        }

        public boolean add(State state) {
            if (this.size != 0 && this.elements.state.parent() != state.parent()) {
                throw new IllegalArgumentException("this.elements.state.parent()!=state.parent()");
            }
            if (this.contains(state)) {
                return false;
            }
            this.lastElement = this.lastElement == null ? (this.elements = new Wrapper_State(state)) : (this.lastElement.next = new Wrapper_State(state));
            this.hashCodeIsValid = false;
            ++this.size;
            return true;
        }

        public void addAll(LinkedSet_State linkedSet_State) {
            Wrapper_State wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                this.add(wrapper_State.state);
                wrapper_State = wrapper_State.next;
            }
        }

        public void addAll(IState iState) {
            if (iState instanceof State) {
                this.add((State)iState);
            } else {
                this.addAll((LinkedSet_State)iState);
            }
        }

        public boolean remove(State state) {
            if (this.size != 0 && this.elements.state.parent() != state.parent()) {
                throw new IllegalArgumentException("this.elements.state.parent()!=state.parent()");
            }
            Wrapper_State wrapper_State = null;
            Wrapper_State wrapper_State2 = this.elements;
            while (wrapper_State2 != null) {
                if (wrapper_State2.state == state) {
                    if (wrapper_State == null) {
                        this.elements = wrapper_State2.next;
                    } else {
                        wrapper_State.next = wrapper_State2.next;
                    }
                    if (wrapper_State2 == this.lastElement) {
                        this.lastElement = wrapper_State;
                    }
                    this.hashCodeIsValid = false;
                    --this.size;
                    return true;
                }
                wrapper_State = wrapper_State2;
                wrapper_State2 = wrapper_State2.next;
            }
            return false;
        }

        public boolean contains(State state) {
            if (this.size != 0 && this.elements.state.parent() != state.parent()) {
                throw new IllegalArgumentException("this.elements.state.parent()!=state.parent()");
            }
            Wrapper_State wrapper_State = this.elements;
            while (wrapper_State != null) {
                if (wrapper_State.state == state) {
                    return true;
                }
                wrapper_State = wrapper_State.next;
            }
            return false;
        }

        public void clear() {
            this.elements = null;
            this.lastElement = null;
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean equals(Object object) {
            try {
                boolean bl = this.equals((LinkedSet_State)object);
                return bl;
            }
            catch (ClassCastException classCastException) {
                if (!(object instanceof LinkedSet_State)) {
                    throw new IllegalArgumentException("obj not instanceof LinkedSet_State");
                }
                throw classCastException;
            }
        }

        public boolean equals(LinkedSet_State linkedSet_State) {
            if (this == linkedSet_State) {
                return true;
            }
            try {
                if (this.size != linkedSet_State.size) {
                    boolean bl = false;
                    return bl;
                }
                Wrapper_State wrapper_State = linkedSet_State.elements;
                while (wrapper_State != null) {
                    if (!this.contains(wrapper_State.state)) {
                        boolean bl = false;
                        return bl;
                    }
                    wrapper_State = wrapper_State.next;
                }
                boolean bl = true;
                return bl;
            }
            catch (NullPointerException nullPointerException) {
                if (linkedSet_State == null) {
                    throw new IllegalArgumentException("set==null");
                }
                throw nullPointerException;
            }
        }

        public int hashCode() {
            if (!this.hashCodeIsValid) {
                long l = 0L;
                Wrapper_State wrapper_State = this.elements;
                while (wrapper_State != null) {
                    l += (long)wrapper_State.state.hashCode();
                    wrapper_State = wrapper_State.next;
                }
                this.hashCode = (int)(l % 0xFFFFFFFBL);
            }
            return this.hashCode;
        }

        public Object clone() {
            try {
                LinkedSet_State linkedSet_State = (LinkedSet_State)super.clone();
                linkedSet_State.clear();
                linkedSet_State.addAll(this);
                LinkedSet_State linkedSet_State2 = linkedSet_State;
                return linkedSet_State2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            Wrapper_State wrapper_State = this.elements;
            while (wrapper_State != null) {
                if (wrapper_State != this.elements) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(wrapper_State.state.toString());
                wrapper_State = wrapper_State.next;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public LinkedSet_State getAllReachableStates() {
            Wrapper_State wrapper_State = this.elements;
            for (int i = this.size; i > 0; --i) {
                State.Transition transition = wrapper_State.state.transitions;
                while (transition != null) {
                    this.add(transition.toState);
                    transition = transition.next;
                }
                wrapper_State = wrapper_State.next;
            }
            while (wrapper_State != null) {
                State.Transition transition = wrapper_State.state.eTransitions;
                while (transition != null) {
                    this.add(transition.toState);
                    transition = transition.next;
                }
                transition = wrapper_State.state.transitions;
                while (transition != null) {
                    this.add(transition.toState);
                    transition = transition.next;
                }
                wrapper_State = wrapper_State.next;
            }
            return this;
        }

        public final IState next(char c) {
            Object object;
            LinkedSet_State linkedSet_State = Automaton.this.newLinkedSet_State();
            Wrapper_State wrapper_State = this.elements;
            while (wrapper_State != null) {
                wrapper_State.state.unVisit();
                wrapper_State = wrapper_State.next;
            }
            wrapper_State = this.elements;
            while (wrapper_State != null) {
                if (wrapper_State.state.isDeterministic()) {
                    object = wrapper_State.state.transitions;
                    while (object != null) {
                        if (((State.Transition)object).charSet.contains(c)) {
                            ((State.Transition)object).visit(c, linkedSet_State);
                            break;
                        }
                        object = ((State.Transition)object).next;
                    }
                } else {
                    object = wrapper_State.state.transitions;
                    while (object != null) {
                        if (((State.Transition)object).charSet.contains(c)) {
                            ((State.Transition)object).visit(c, linkedSet_State);
                        }
                        object = ((State.Transition)object).next;
                    }
                }
                wrapper_State = wrapper_State.next;
            }
            wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                if (wrapper_State.state.visitedListeners != null) {
                    object = wrapper_State.state.visitedListeners.iterator();
                    for (int i = wrapper_State.state.visitedListeners.size(); i > 0; --i) {
                        ((IStateVisitedListener)object.next()).stateVisited(wrapper_State.state, c);
                    }
                }
                object = wrapper_State.state.eTransitions;
                while (object != null) {
                    ((State.Transition)object).visit(linkedSet_State);
                    object = ((State.Transition)object).next;
                }
                wrapper_State = wrapper_State.next;
            }
            switch (linkedSet_State.size) {
                case 0: {
                    return null;
                }
                case 1: {
                    return linkedSet_State.elements.state;
                }
            }
            return linkedSet_State;
        }
    }

    public class State
    implements IState {
        private static final int TRUE = 1;
        private static final int FALSE = 0;
        private static final int UNKNOWN = -1;
        protected transient LinkedList visitedListeners = null;
        protected transient LinkedList changedListeners = null;
        public transient int stateNr;
        public Transition transitions;
        public Transition eTransitions;
        private transient int isDeterministic;
        private transient SoftReference nDetInterCharSet;

        public void addVisitedListener(IStateVisitedListener iStateVisitedListener) {
            if (this.visitedListeners == null) {
                this.visitedListeners = new LinkedList();
            }
            this.visitedListeners.add(iStateVisitedListener);
        }

        public boolean removeVisitedListener(IStateVisitedListener iStateVisitedListener) {
            if (this.visitedListeners != null) {
                Iterator iterator = this.visitedListeners.iterator();
                for (int i = this.visitedListeners.size(); i > 0; --i) {
                    if (iStateVisitedListener != iterator.next()) continue;
                    if (this.visitedListeners.size() > 1) {
                        iterator.remove();
                    } else {
                        this.visitedListeners = null;
                    }
                    return true;
                }
            }
            return false;
        }

        public void addChangedListener(IStateChangedListener iStateChangedListener) {
            if (this.changedListeners == null) {
                this.changedListeners = new LinkedList();
            }
            this.changedListeners.add(iStateChangedListener);
        }

        public boolean removeChangedListener(IStateChangedListener iStateChangedListener) {
            if (this.changedListeners != null) {
                Iterator iterator = this.changedListeners.iterator();
                for (int i = this.changedListeners.size(); i > 0; --i) {
                    if (iStateChangedListener != iterator.next()) continue;
                    if (this.changedListeners.size() > 1) {
                        iterator.remove();
                    } else {
                        this.changedListeners = null;
                    }
                    return true;
                }
            }
            return false;
        }

        public final IState visit() {
            if (this.eTransitions == null) {
                if (this.visitedListeners != null) {
                    Iterator iterator = this.visitedListeners.iterator();
                    for (int i = this.visitedListeners.size(); i > 0; --i) {
                        ((IStateVisitedListener)iterator.next()).stateVisited(this);
                    }
                }
                return this;
            }
            LinkedSet_State linkedSet_State = Automaton.this.newLinkedSet_State(this);
            Wrapper_State wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                Object object;
                if (wrapper_State.state.visitedListeners != null) {
                    object = wrapper_State.state.visitedListeners.iterator();
                    for (int i = wrapper_State.state.visitedListeners.size(); i > 0; --i) {
                        ((IStateVisitedListener)object.next()).stateVisited(wrapper_State.state);
                    }
                }
                object = wrapper_State.state.eTransitions;
                while (object != null) {
                    ((Transition)object).visit(linkedSet_State);
                    object = ((Transition)object).next;
                }
                wrapper_State = wrapper_State.next;
            }
            return linkedSet_State;
        }

        protected final void unVisit() {
            if (this.visitedListeners != null) {
                Iterator iterator = this.visitedListeners.iterator();
                for (int i = this.visitedListeners.size(); i > 0; --i) {
                    ((IStateVisitedListener)iterator.next()).stateUnVisited(this);
                }
            }
        }

        protected State() {
            this.stateNr = Automaton.this.currentStateNr++;
            this.transitions = null;
            this.eTransitions = null;
            this.isDeterministic = 1;
            this.nDetInterCharSet = null;
        }

        protected Automaton parent() {
            return Automaton.this;
        }

        protected Transition addTransition(IProperties iProperties, ISet_char iSet_char, State state) {
            Transition transition = new Transition(iProperties, iSet_char, state);
            this.addTransition(transition);
            return transition;
        }

        protected void addTransition(Transition transition) {
            if (transition.charSet == null) {
                transition.next = this.eTransitions;
                this.eTransitions = transition;
                Automaton.this.isDeterministic = 0;
            } else {
                transition.next = this.transitions;
                this.transitions = transition;
                if (this.isDeterministic == 1) {
                    this.isDeterministic = -1;
                }
                if (Automaton.this.isDeterministic == 1) {
                    Automaton.this.isDeterministic = -1;
                }
            }
            if (this.changedListeners != null) {
                Iterator iterator = this.changedListeners.iterator();
                for (int i = this.changedListeners.size(); i > 0; --i) {
                    ((IStateChangedListener)iterator.next()).transitionAdded(transition);
                }
            }
        }

        protected boolean removeTransition(Transition transition) {
            if (transition.getFromState() != this) {
                throw new IllegalArgumentException("transition.getFromState()!=this");
            }
            if (transition.charSet == null) {
                Transition transition2 = null;
                Transition transition3 = this.eTransitions;
                while (transition3 != null) {
                    if (transition3 == transition) {
                        if (transition2 == null) {
                            this.eTransitions = transition3.next;
                        } else {
                            transition2.next = transition3.next;
                        }
                        if (Automaton.this.isDeterministic == 0) {
                            Automaton.this.isDeterministic = -1;
                        }
                        if (this.changedListeners != null) {
                            Iterator iterator = this.changedListeners.iterator();
                            for (int i = this.changedListeners.size(); i > 0; --i) {
                                ((IStateChangedListener)iterator.next()).transitionRemoved(transition);
                            }
                        }
                        return true;
                    }
                    transition2 = transition3;
                    transition3 = transition3.next;
                }
            } else {
                Transition transition4 = null;
                Transition transition5 = this.transitions;
                while (transition5 != null) {
                    if (transition5 == transition) {
                        if (transition4 == null) {
                            this.transitions = transition5.next;
                        } else {
                            transition4.next = transition5.next;
                        }
                        if (this.isDeterministic == 0) {
                            this.isDeterministic = -1;
                        }
                        if (Automaton.this.isDeterministic == 0) {
                            Automaton.this.isDeterministic = -1;
                        }
                        if (this.changedListeners != null) {
                            Iterator iterator = this.changedListeners.iterator();
                            for (int i = this.changedListeners.size(); i > 0; --i) {
                                ((IStateChangedListener)iterator.next()).transitionRemoved(transition);
                            }
                        }
                        return true;
                    }
                    transition4 = transition5;
                    transition5 = transition5.next;
                }
            }
            return false;
        }

        protected void removeAllTransitions() {
            Transition transition = this.eTransitions;
            while (transition != null) {
                this.removeTransition(transition);
                transition = transition.next;
            }
            transition = this.transitions;
            while (transition != null) {
                this.removeTransition(transition);
                transition = transition.next;
            }
        }

        protected void setDeterministic(Boolean bl) {
            if (bl == null) {
                this.isDeterministic = -1;
            }
            this.isDeterministic = bl != false ? 1 : 0;
        }

        public final boolean isDeterministic() {
            switch (this.isDeterministic) {
                case 1: {
                    return true;
                }
                case 0: {
                    return false;
                }
                case -1: {
                    if (this.transitions == null) {
                        this.isDeterministic = 1;
                        return true;
                    }
                    ISet_char iSet_char = (ISet_char)this.transitions.charSet.clone();
                    Transition transition = this.transitions.next;
                    while (transition != null) {
                        int n = iSet_char.size();
                        iSet_char.addAll(transition.charSet);
                        int n2 = iSet_char.size();
                        if (n2 - n < transition.charSet.size()) {
                            this.isDeterministic = 0;
                            return false;
                        }
                        transition = transition.next;
                    }
                    this.isDeterministic = 1;
                    return true;
                }
            }
            throw new Error("Unknown deterministic state: ".concat(String.valueOf(String.valueOf(this.isDeterministic))));
        }

        public final IState next(char c) {
            this.unVisit();
            if (this.isDeterministic()) {
                Transition transition = this.transitions;
                while (transition != null) {
                    if (transition.charSet.contains(c)) {
                        State state = transition.visit(c);
                        if (state.eTransitions == null) {
                            if (state.visitedListeners != null) {
                                Iterator iterator = this.visitedListeners.iterator();
                                for (int i = this.visitedListeners.size(); i > 0; --i) {
                                    ((IStateVisitedListener)iterator.next()).stateVisited(state, c);
                                }
                            }
                            return state;
                        }
                        LinkedSet_State linkedSet_State = Automaton.this.newLinkedSet_State(state);
                        Wrapper_State wrapper_State = linkedSet_State.elements;
                        while (wrapper_State != null) {
                            Object object;
                            if (wrapper_State.state.visitedListeners != null) {
                                object = wrapper_State.state.visitedListeners.iterator();
                                for (int i = wrapper_State.state.visitedListeners.size(); i > 0; --i) {
                                    ((IStateVisitedListener)object.next()).stateVisited(wrapper_State.state, c);
                                }
                            }
                            object = wrapper_State.state.eTransitions;
                            while (object != null) {
                                ((Transition)object).visit(linkedSet_State);
                                object = ((Transition)object).next;
                            }
                            wrapper_State = wrapper_State.next;
                        }
                        return linkedSet_State;
                    }
                    transition = transition.next;
                }
                return null;
            }
            LinkedSet_State linkedSet_State = Automaton.this.newLinkedSet_State();
            Object object = this.transitions;
            while (object != null) {
                if (((Transition)object).charSet.contains(c)) {
                    ((Transition)object).visit(c, linkedSet_State);
                }
                object = ((Transition)object).next;
            }
            object = linkedSet_State.elements;
            while (object != null) {
                Object object2;
                if (((Wrapper_State)object).state.visitedListeners != null) {
                    object2 = ((Wrapper_State)object).state.visitedListeners.iterator();
                    for (int i = ((Wrapper_State)object).state.visitedListeners.size(); i > 0; --i) {
                        ((IStateVisitedListener)object2.next()).stateVisited(((Wrapper_State)object).state, c);
                    }
                }
                object2 = ((Wrapper_State)object).state.eTransitions;
                while (object2 != null) {
                    ((Transition)object2).visit(linkedSet_State);
                    object2 = ((Transition)object2).next;
                }
                object = ((Wrapper_State)object).next;
            }
            switch (linkedSet_State.size) {
                case 0: {
                    return null;
                }
                case 1: {
                    return linkedSet_State.elements.state;
                }
            }
            return linkedSet_State;
        }

        protected IState getEClosure() {
            if (this.eTransitions == null) {
                return this;
            }
            LinkedSet_State linkedSet_State = Automaton.this.newLinkedSet_State(this);
            Wrapper_State wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                Transition transition = wrapper_State.state.eTransitions;
                while (transition != null) {
                    linkedSet_State.add(transition.toState);
                    transition = transition.next;
                }
                wrapper_State = wrapper_State.next;
            }
            switch (linkedSet_State.size) {
                case 1: {
                    return linkedSet_State.elements.state;
                }
            }
            return linkedSet_State;
        }

        protected void addEClosure(LinkedSet_State linkedSet_State) {
            linkedSet_State.add(this);
            Wrapper_State wrapper_State = linkedSet_State.lastElement;
            Transition transition = this.eTransitions;
            while (transition != null) {
                linkedSet_State.add(transition.toState);
                transition = transition.next;
            }
            wrapper_State = wrapper_State.next;
            while (wrapper_State != null) {
                transition = wrapper_State.state.eTransitions;
                while (transition != null) {
                    linkedSet_State.add(transition.toState);
                    transition = transition.next;
                }
                wrapper_State = wrapper_State.next;
            }
        }

        public LinkedSet_State getAllReachableStates() {
            LinkedSet_State linkedSet_State = new LinkedSet_State();
            Object object = this.eTransitions;
            while (object != null) {
                linkedSet_State.add(((Transition)object).toState);
                object = ((Transition)object).next;
            }
            object = this.transitions;
            while (object != null) {
                if (!((Transition)object).charSet.isEmpty()) {
                    linkedSet_State.add(((Transition)object).toState);
                }
                object = ((Transition)object).next;
            }
            object = linkedSet_State.elements;
            while (object != null) {
                Transition transition = ((Wrapper_State)object).state.eTransitions;
                while (transition != null) {
                    linkedSet_State.add(transition.toState);
                    transition = transition.next;
                }
                transition = ((Wrapper_State)object).state.transitions;
                while (transition != null) {
                    if (!transition.charSet.isEmpty()) {
                        linkedSet_State.add(transition.toState);
                    }
                    transition = transition.next;
                }
                object = ((Wrapper_State)object).next;
            }
            return linkedSet_State;
        }

        public final Object clone() {
            return Automaton.this.cloneState(this).get(this);
        }

        public String toString() {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Automaton.this.automatonNr))).append(".(").append(String.valueOf(this.stateNr)).append(')')));
        }

        static {
            TRUE = 1;
            FALSE = 0;
            UNKNOWN = -1;
        }

        public final class Transition {
            transient LinkedList transitionVisitedListeners = null;
            public final ISet_char charSet;
            public final State toState;
            public IProperties properties = null;
            public Transition next = null;

            public void addVisitedListener(ITransitionVisitedListener iTransitionVisitedListener) {
                if (this.transitionVisitedListeners == null) {
                    this.transitionVisitedListeners = new LinkedList();
                }
                this.transitionVisitedListeners.add(iTransitionVisitedListener);
            }

            public boolean removeVisitedListener(ITransitionVisitedListener iTransitionVisitedListener) {
                if (this.transitionVisitedListeners != null) {
                    Iterator iterator = this.transitionVisitedListeners.iterator();
                    for (int i = this.transitionVisitedListeners.size(); i > 0; --i) {
                        if (iTransitionVisitedListener != iterator.next()) continue;
                        if (this.transitionVisitedListeners.size() > 1) {
                            iterator.remove();
                        } else {
                            this.transitionVisitedListeners = null;
                        }
                        return true;
                    }
                }
                return false;
            }

            public final State visit() {
                if (this.transitionVisitedListeners != null) {
                    Iterator iterator = this.transitionVisitedListeners.iterator();
                    for (int i = this.transitionVisitedListeners.size(); i > 0; --i) {
                        ((ITransitionVisitedListener)iterator.next()).transitionVisited(this);
                    }
                }
                return this.toState;
            }

            private final void visit(LinkedSet_State linkedSet_State) {
                if (this.transitionVisitedListeners != null) {
                    Iterator iterator = this.transitionVisitedListeners.iterator();
                    for (int i = this.transitionVisitedListeners.size(); i > 0; --i) {
                        ((ITransitionVisitedListener)iterator.next()).transitionVisited(this);
                    }
                }
                linkedSet_State.add(this.toState);
            }

            private final State visit(char c) {
                if (this.transitionVisitedListeners != null) {
                    Iterator iterator = this.transitionVisitedListeners.iterator();
                    for (int i = this.transitionVisitedListeners.size(); i > 0; --i) {
                        ((ITransitionVisitedListener)iterator.next()).transitionVisited(this, c);
                    }
                }
                return this.toState;
            }

            private final void visit(char c, LinkedSet_State linkedSet_State) {
                if (this.transitionVisitedListeners != null) {
                    Iterator iterator = this.transitionVisitedListeners.iterator();
                    for (int i = this.transitionVisitedListeners.size(); i > 0; --i) {
                        ((ITransitionVisitedListener)iterator.next()).transitionVisited(this, c);
                    }
                }
                linkedSet_State.add(this.toState);
            }

            protected Transition(IProperties iProperties, ISet_char iSet_char, State state2) {
                if (state2 == null) {
                    throw new IllegalArgumentException("toState==null");
                }
                this.properties = iProperties;
                this.charSet = iSet_char;
                this.toState = state2;
            }

            public State getFromState() {
                return State.this;
            }

            public State getToState() {
                return this.toState;
            }

            public ISet_char getCharSet() {
                return this.charSet;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(State.this);
                if (this.charSet == null) {
                    if (this.properties == null) {
                        stringBuffer.append(" --> ");
                    } else {
                        stringBuffer.append(" -").append(this.properties).append(": -> ");
                    }
                } else if (this.properties == null) {
                    stringBuffer.append(" -").append(this.charSet).append("-> ");
                } else {
                    stringBuffer.append(" -").append(this.properties).append(':').append(this.charSet).append("-> ");
                }
                stringBuffer.append(this.toState);
                return stringBuffer.toString();
            }
        }
    }

    public static interface IState
    extends Cloneable {
        public IState next(char var1);

        public LinkedSet_State getAllReachableStates();

        public Object clone();
    }

    public static final class Wrapper_State {
        public final State state;
        public Wrapper_State next = null;

        public Wrapper_State(State state) {
            this.state = state;
        }
    }

    public static interface ITransitionVisitedListener {
        public void transitionVisited(State.Transition var1);

        public void transitionVisited(State.Transition var1, char var2);
    }

    public static interface IStateChangedListener {
        public void transitionAdded(State.Transition var1);

        public void transitionRemoved(State.Transition var1);
    }

    public static interface IStateVisitedListener {
        public void stateVisited(State var1);

        public void stateVisited(State var1, char var2);

        public void stateUnVisited(State var1);
    }

    public static interface IChangedListener {
        public void stateAdded(State var1);

        public void stateRemoved(State var1);

        public void startStateChanged(State var1, State var2);
    }
}

