/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AspectContainer;
import org.codehaus.aspectwerkz.aspect.management.Aspects;
import org.codehaus.aspectwerkz.definition.AspectDefinition;

public final class AspectContext
implements Serializable {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String m_name;
    private String m_qName;
    private transient WeakReference m_aspectClassRef;
    private transient AspectContainer m_container = null;
    private DeploymentModel m_deploymentModel;
    private Map m_parameters = new HashMap();
    private Map m_metaData = new HashMap();
    private String m_uuid;
    private transient AspectDefinition m_aspectDefinition;

    public AspectContext(String uuid, Class aspectClass, String name, DeploymentModel deploymentModel, AspectDefinition aspectDef, Map parameters) {
        this.m_uuid = uuid;
        this.m_aspectClassRef = new WeakReference<Class>(aspectClass);
        this.m_name = name;
        this.m_qName = aspectDef.getQualifiedName();
        this.m_deploymentModel = deploymentModel;
        this.m_aspectDefinition = aspectDef;
        if (parameters != null) {
            this.m_parameters = parameters;
        }
    }

    public static AspectContext newInstance(AspectContext prototype) {
        try {
            return new AspectContext(prototype.m_uuid, (Class)prototype.m_aspectClassRef.get(), prototype.m_name, prototype.m_deploymentModel, prototype.m_aspectDefinition, prototype.m_parameters);
        }
        catch (Exception e) {
            throw new RuntimeException("could not clone cross-cutting info [" + prototype.getName() + "]: " + e.toString());
        }
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public String getName() {
        return this.m_name;
    }

    public DeploymentModel getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public Class getAspectClass() {
        return (Class)this.m_aspectClassRef.get();
    }

    public void setContainer(AspectContainer container) {
        this.m_container = container;
    }

    public AspectContainer getContainer() {
        return this.m_container;
    }

    public AspectDefinition getAspectDefinition() {
        return this.m_aspectDefinition;
    }

    public void setParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public String getParameter(String name) {
        return (String)this.m_parameters.get(name);
    }

    public void addMetaData(Object key, Object value) {
        this.m_metaData.put(key, value);
    }

    public Object getMetaData(Object key) {
        return this.m_metaData.get(key);
    }

    public boolean isPrototype() {
        return this.m_container == null;
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_name = (String)fields.get("m_name", null);
        this.m_qName = (String)fields.get("m_qName", null);
        Class<?> aspectClass = Class.forName(this.m_name);
        this.m_aspectClassRef = new WeakReference(aspectClass);
        this.m_deploymentModel = (DeploymentModel)fields.get("m_deploymentModel", DeploymentModel.PER_JVM);
        this.m_parameters = (Map)fields.get("m_parameters", new HashMap());
        this.m_metaData = (Map)fields.get("m_metaData", new HashMap());
        String containerClassName = Aspects.getAspectQNameContainerClassName(Thread.currentThread().getContextClassLoader(), this.m_qName)[1];
        Class<?> containerClass = Class.forName(containerClassName);
        this.m_container = Aspects.getContainerQNamed(Thread.currentThread().getContextClassLoader(), containerClass, this.m_qName);
    }
}

