/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect;

import java.io.Serializable;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class AdviceInfo
implements Serializable {
    public static final AdviceInfo[] EMPTY_ADVICE_INFO_ARRAY = new AdviceInfo[0];
    public static final int JOINPOINT_ARG = -1;
    public static final int STATIC_JOINPOINT_ARG = -2;
    public static final int TARGET_ARG = -3;
    public static final int THIS_ARG = -4;
    public static final int VALID_NON_AW_AROUND_CLOSURE_TYPE = -5;
    public static final int SPECIAL_ARGUMENT = -6;
    public static final int CUSTOM_JOIN_POINT_ARG = -7;
    private String m_methodName;
    private String m_methodSignature;
    private Type[] m_methodParameterTypes;
    private final String m_name;
    private String m_aspectClassName;
    private String m_aspectQualifiedName;
    private DeploymentModel m_aspectDeploymentModel;
    private int[] m_methodToArgIndexes;
    private String m_specialArgumentTypeDesc;
    private String m_specialArgumentTypeName;
    private AdviceType m_type;
    private boolean m_targetWithRuntimeCheck;
    private ExpressionInfo m_expressionInfo;
    private ExpressionContext m_expressionContext;
    private AdviceDefinition m_adviceDef;

    public AdviceInfo(String aspectQualifiedName, String aspectClassName, DeploymentModel aspectDeploymentModel, String methodName, String methodSignature, Type[] methodParameterTypes, AdviceType type, String specialArgumentType, String adviceName, boolean targetWithRuntimeCheck, ExpressionInfo expressionInfo, ExpressionContext expressionContext, AdviceDefinition adviceDef) {
        this.m_aspectQualifiedName = aspectQualifiedName;
        this.m_aspectClassName = aspectClassName;
        this.m_aspectDeploymentModel = aspectDeploymentModel;
        this.m_methodName = methodName;
        this.m_methodSignature = methodSignature;
        this.m_methodParameterTypes = methodParameterTypes;
        this.m_type = type;
        if (specialArgumentType != null && specialArgumentType.length() > 0) {
            this.m_specialArgumentTypeDesc = AsmHelper.convertReflectDescToTypeDesc(specialArgumentType);
            this.m_specialArgumentTypeName = specialArgumentType.replace('.', '/');
        }
        this.m_name = adviceName;
        this.m_targetWithRuntimeCheck = targetWithRuntimeCheck;
        this.m_expressionInfo = expressionInfo;
        this.m_expressionContext = expressionContext;
        this.m_adviceDef = adviceDef;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String getMethodSignature() {
        return this.m_methodSignature;
    }

    public Type[] getMethodParameterTypes() {
        return this.m_methodParameterTypes;
    }

    public String getAspectQualifiedName() {
        return this.m_aspectQualifiedName;
    }

    public String getAspectClassName() {
        return this.m_aspectClassName;
    }

    public DeploymentModel getAspectDeploymentModel() {
        return this.m_aspectDeploymentModel;
    }

    public String getName() {
        return this.m_name;
    }

    public void setMethodToArgIndexes(int[] map) {
        this.m_methodToArgIndexes = map;
    }

    public int[] getMethodToArgIndexes() {
        return this.m_methodToArgIndexes;
    }

    public String getSpecialArgumentTypeDesc() {
        return this.m_specialArgumentTypeDesc;
    }

    public String getSpecialArgumentTypeName() {
        return this.m_specialArgumentTypeName;
    }

    public AdviceType getType() {
        return this.m_type;
    }

    public boolean hasTargetWithRuntimeCheck() {
        return this.m_targetWithRuntimeCheck;
    }

    public ExpressionInfo getExpressionInfo() {
        return this.m_expressionInfo;
    }

    public ExpressionContext getExpressionContext() {
        return this.m_expressionContext;
    }

    public AdviceDefinition getAdviceDefinition() {
        return this.m_adviceDef;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AdviceInfo[");
        sb.append(this.m_type).append(',');
        sb.append(this.m_aspectQualifiedName).append(',');
        sb.append(this.m_name).append(',');
        sb.append(this.m_methodName).append(',');
        sb.append(this.m_methodSignature).append(',');
        sb.append(this.m_methodParameterTypes).append(',');
        sb.append(this.m_specialArgumentTypeDesc).append(',');
        sb.append(this.m_expressionInfo).append(',');
        sb.append(this.m_expressionContext).append(',');
        sb.append(this.m_targetWithRuntimeCheck).append(']');
        sb.append(this.hashCode());
        return sb.toString();
    }
}

