/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.connectivity;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.codehaus.aspectwerkz.connectivity.Invoker;
import org.codehaus.aspectwerkz.connectivity.RemoteProxyServerThread;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class RemoteProxyServer
implements Runnable {
    private static String HOST_NAME;
    private static int PORT;
    private static boolean BOUNDED_THREAD_POOL;
    private static boolean LISTENER_THREAD_RUN_AS_DAEMON;
    private static int BACKLOG;
    private static int NUM_LISTENER_THREADS;
    private static int LISTENER_THREAD_PRIORITY;
    private static int CLIENT_THREAD_TIMEOUT;
    private static int THREAD_POOL_MAX_SIZE;
    private static int THREAD_POOL_MIN_SIZE;
    private static int THREAD_POOL_INIT_SIZE;
    private static int THREAD_POOL_KEEP_ALIVE_TIME;
    private static boolean THREAD_POOL_WAIT_WHEN_BLOCKED;
    private ServerSocket m_serverSocket = null;
    private Thread[] m_listenerThreads = null;
    private PooledExecutor m_threadPool = null;
    private ClassLoader m_loader = null;
    private Invoker m_invoker = null;
    private boolean m_running = true;

    public RemoteProxyServer(ClassLoader loader, Invoker invoker) {
        this.m_invoker = invoker;
        this.m_loader = loader;
    }

    public void start() {
        this.m_running = true;
        try {
            InetAddress bindAddress = InetAddress.getByName(HOST_NAME);
            this.m_serverSocket = new ServerSocket(PORT, BACKLOG, bindAddress);
            if (BOUNDED_THREAD_POOL) {
                this.createBoundedThreadPool(THREAD_POOL_MAX_SIZE, THREAD_POOL_MIN_SIZE, THREAD_POOL_INIT_SIZE, THREAD_POOL_KEEP_ALIVE_TIME, THREAD_POOL_WAIT_WHEN_BLOCKED);
            } else {
                this.createDynamicThreadPool(THREAD_POOL_MIN_SIZE, THREAD_POOL_INIT_SIZE, THREAD_POOL_KEEP_ALIVE_TIME);
            }
            this.m_listenerThreads = new Thread[NUM_LISTENER_THREADS];
            for (int i = 0; i < NUM_LISTENER_THREADS; ++i) {
                this.m_listenerThreads[i] = new Thread(this);
                this.m_listenerThreads[i].setName("AspectWerkz::Listener " + (i + 1));
                this.m_listenerThreads[i].setDaemon(LISTENER_THREAD_RUN_AS_DAEMON);
                this.m_listenerThreads[i].setPriority(LISTENER_THREAD_PRIORITY);
                this.m_listenerThreads[i].start();
            }
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void stop() {
        this.m_running = false;
        for (int i = 0; i < NUM_LISTENER_THREADS; ++i) {
            this.m_listenerThreads[i].interrupt();
        }
        this.m_threadPool.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.m_running) {
                Socket clientSocket = this.m_serverSocket.accept();
                PooledExecutor pooledExecutor = this.m_threadPool;
                synchronized (pooledExecutor) {
                    this.m_threadPool.execute((Runnable)new RemoteProxyServerThread(clientSocket, this.m_loader, this.m_invoker, CLIENT_THREAD_TIMEOUT));
                }
            }
            this.m_serverSocket.close();
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private void createBoundedThreadPool(int threadPoolMaxSize, int threadPoolMinSize, int threadPoolInitSize, int keepAliveTime, boolean waitWhenBlocked) {
        this.m_threadPool = new PooledExecutor((Channel)new BoundedBuffer(threadPoolInitSize), threadPoolMaxSize);
        this.m_threadPool.setKeepAliveTime((long)keepAliveTime);
        this.m_threadPool.createThreads(threadPoolInitSize);
        this.m_threadPool.setMinimumPoolSize(threadPoolMinSize);
        if (waitWhenBlocked) {
            this.m_threadPool.waitWhenBlocked();
        }
    }

    private void createDynamicThreadPool(int threadPoolMinSize, int threadPoolInitSize, int keepAliveTime) {
        this.m_threadPool = new PooledExecutor((Channel)new LinkedQueue());
        this.m_threadPool.setKeepAliveTime((long)keepAliveTime);
        this.m_threadPool.createThreads(threadPoolInitSize);
        this.m_threadPool.setMinimumPoolSize(threadPoolMinSize);
    }

    static {
        LISTENER_THREAD_PRIORITY = 5;
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(System.getProperty("aspectwerkz.resource.bundle")));
        }
        catch (Exception e) {
            System.out.println("no aspectwerkz resource bundle found on classpath, using defaults");
        }
        String property = properties.getProperty("remote.server.hostname");
        HOST_NAME = property == null ? property : property;
        property = properties.getProperty("remote.server.port");
        PORT = property == null ? 7777 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.listener.threads.backlog");
        BACKLOG = property == null ? 200 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.listener.threads.nr");
        NUM_LISTENER_THREADS = property == null ? 10 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.client.threads.timeout");
        CLIENT_THREAD_TIMEOUT = property == null ? 60000 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.thread.pool.max.size");
        THREAD_POOL_MAX_SIZE = property == null ? 100 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.thread.pool.min.size");
        THREAD_POOL_MIN_SIZE = property == null ? 10 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.thread.pool.init.size");
        THREAD_POOL_INIT_SIZE = property == null ? 10 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.thread.pool.keep.alive.time");
        THREAD_POOL_KEEP_ALIVE_TIME = property == null ? 300000 : Integer.parseInt(property);
        property = properties.getProperty("remote.server.thread.pool.type");
        BOUNDED_THREAD_POOL = property == null || !property.equals("dynamic");
        property = properties.getProperty("remote.server.listener.threads.run.as.daemon");
        LISTENER_THREAD_RUN_AS_DAEMON = property != null && property.equals("true");
        property = properties.getProperty("remote.server.thread.pool.wait.when.blocked");
        THREAD_POOL_WAIT_WHEN_BLOCKED = property != null && property.equals("true");
    }
}

