/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.management;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;

public class AdviceInfoContainer {
    public static final AdviceInfoContainer NULL = new AdviceInfoContainer(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    private final AdviceInfo[] m_aroundAdvices;
    private final AdviceInfo[] m_beforeAdvices;
    private final AdviceInfo[] m_afterFinallyAdvices;
    private final AdviceInfo[] m_afterReturningAdvices;
    private final AdviceInfo[] m_afterThrowingAdvices;

    public AdviceInfoContainer(List aroundAdvices, List beforeAdvices, List afterFinallyAdvices, List afterReturningAdvices, List afterThrowingAdvices) {
        this.m_aroundAdvices = aroundAdvices.toArray(AdviceInfo.EMPTY_ADVICE_INFO_ARRAY);
        this.m_beforeAdvices = beforeAdvices.toArray(AdviceInfo.EMPTY_ADVICE_INFO_ARRAY);
        this.m_afterFinallyAdvices = afterFinallyAdvices.toArray(AdviceInfo.EMPTY_ADVICE_INFO_ARRAY);
        this.m_afterReturningAdvices = afterReturningAdvices.toArray(AdviceInfo.EMPTY_ADVICE_INFO_ARRAY);
        this.m_afterThrowingAdvices = afterThrowingAdvices.toArray(AdviceInfo.EMPTY_ADVICE_INFO_ARRAY);
    }

    public AdviceInfo[] getAroundAdviceInfos() {
        return this.m_aroundAdvices;
    }

    public AdviceInfo[] getBeforeAdviceInfos() {
        return this.m_beforeAdvices;
    }

    public AdviceInfo[] getAfterFinallyAdviceInfos() {
        return this.m_afterFinallyAdvices;
    }

    public AdviceInfo[] getAfterReturningAdviceInfos() {
        return this.m_afterReturningAdvices;
    }

    public AdviceInfo[] getAfterThrowingAdviceInfos() {
        return this.m_afterThrowingAdvices;
    }

    public AdviceInfo[] getAllAdviceInfos() {
        int size = this.m_beforeAdvices.length + this.m_aroundAdvices.length + this.m_afterReturningAdvices.length + this.m_afterThrowingAdvices.length + this.m_afterFinallyAdvices.length;
        AdviceInfo[] advices = new AdviceInfo[size];
        int destPos = 0;
        System.arraycopy(this.m_beforeAdvices, 0, advices, destPos, this.m_beforeAdvices.length);
        System.arraycopy(this.m_aroundAdvices, 0, advices, destPos += this.m_beforeAdvices.length, this.m_aroundAdvices.length);
        System.arraycopy(this.m_afterReturningAdvices, 0, advices, destPos += this.m_aroundAdvices.length, this.m_afterReturningAdvices.length);
        System.arraycopy(this.m_afterThrowingAdvices, 0, advices, destPos += this.m_afterReturningAdvices.length, this.m_afterThrowingAdvices.length);
        System.arraycopy(this.m_afterFinallyAdvices, 0, advices, destPos += this.m_afterThrowingAdvices.length, this.m_afterFinallyAdvices.length);
        destPos += this.m_afterFinallyAdvices.length;
        return advices;
    }
}

